/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.server;

import com.oracle.truffle.tools.chromeinspector.instrument.InspectorWSConnection;
import com.oracle.truffle.tools.chromeinspector.server.ConnectionWatcher;
import com.oracle.truffle.tools.chromeinspector.server.InspectServerSession;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import org.graalvm.polyglot.io.MessageEndpoint;

public final class WSInterceptorServer
implements InspectorWSConnection,
MessageEndpoint {
    private final URI uri;
    private final ConnectionWatcher connectionWatcher;
    private InspectServerSession iss;
    private MessageEndpoint inspectEndpoint;

    public WSInterceptorServer(URI uri, InspectServerSession iss, ConnectionWatcher connectionWatcher) {
        this.uri = uri;
        this.connectionWatcher = connectionWatcher;
        this.iss = iss;
        iss.setMessageListener(this);
    }

    public void newSession(InspectServerSession newIss) {
        this.iss.setMessageListener(null);
        this.iss = newIss;
        this.iss.setMessageListener(this);
    }

    public void opened(MessageEndpoint endpoint) {
        this.inspectEndpoint = endpoint;
        this.iss.setMessageListener(this);
        this.connectionWatcher.notifyOpen();
    }

    @Override
    public int getPort() {
        return this.uri.getPort();
    }

    @Override
    public void close(String path) throws IOException {
        this.iss.setMessageListener(null);
        if (this.inspectEndpoint != null && path.equals(this.uri.getPath())) {
            this.inspectEndpoint.sendClose();
        }
    }

    @Override
    public void consoleAPICall(String wsspath, String type, Object text) {
        this.iss.consoleAPICall(type, text);
    }

    public void sendText(String message) throws IOException {
        this.connectionWatcher.waitForOpen();
        this.inspectEndpoint.sendText(message);
    }

    public void sendBinary(ByteBuffer data) throws IOException {
        this.inspectEndpoint.sendBinary(data);
    }

    public void sendPing(ByteBuffer data) throws IOException {
        this.inspectEndpoint.sendPing(data);
    }

    public void sendPong(ByteBuffer data) throws IOException {
        this.inspectEndpoint.sendPong(data);
    }

    public void sendClose() throws IOException {
        if (this.inspectEndpoint != null) {
            this.inspectEndpoint.sendClose();
        }
    }
}

