/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.objects.AbstractInspectorObject;
import com.oracle.truffle.tools.chromeinspector.objects.Console;
import com.oracle.truffle.tools.chromeinspector.objects.Keys;
import com.oracle.truffle.tools.chromeinspector.objects.NullObject;
import com.oracle.truffle.tools.chromeinspector.objects.SessionClass;
import com.oracle.truffle.tools.chromeinspector.server.InspectorServerConnection;
import java.io.IOException;
import java.util.function.Supplier;

public final class Inspector
extends AbstractInspectorObject {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    private static final String FIELD_CONSOLE = "console";
    private static final String FIELD_SESSION = "Session";
    private static final String METHOD_CLOSE = "close";
    private static final String METHOD_OPEN = "open";
    private static final String METHOD_URL = "url";
    static final String[] NAMES = new String[]{"console", "Session", "close", "open", "url"};
    private static final TruffleObject KEYS = new Keys(NAMES);
    private InspectorServerConnection connection;
    private final InspectorServerConnection.Open open;
    private final Console console;
    private final SessionClass sessionType;

    public Inspector(InspectorServerConnection connection, InspectorServerConnection.Open open, Supplier<InspectorExecutionContext> contextSupplier) {
        this.connection = connection;
        this.open = open;
        this.console = new Console(connection);
        this.sessionType = new SessionClass(contextSupplier);
    }

    public static boolean isInstance(TruffleObject obj) {
        return obj instanceof Inspector;
    }

    protected TruffleObject getMembers(boolean includeInternal) {
        return KEYS;
    }

    @Override
    protected boolean isField(String name) {
        switch (name) {
            case "console": 
            case "Session": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Object getFieldValueOrNull(String name) {
        switch (name) {
            case "console": {
                return this.console;
            }
            case "Session": {
                return this.sessionType;
            }
        }
        return null;
    }

    @Override
    protected boolean isMethod(String name) {
        switch (name) {
            case "close": 
            case "open": 
            case "url": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Object invokeMember(String name, Object[] arguments) throws UnknownIdentifierException {
        switch (name) {
            case "close": {
                return this.methodClose();
            }
            case "open": {
                return this.methodOpen(arguments);
            }
            case "url": {
                return this.methodUrl();
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw UnknownIdentifierException.create((String)name);
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleObject methodClose() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connection = null;
        }
        return NullObject.INSTANCE;
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleObject methodOpen(Object[] arguments) {
        InspectorServerConnection newConnection;
        int port = -1;
        String host = null;
        boolean wait = false;
        if (arguments.length > 0) {
            try {
                if (INTEROP.fitsInInt(arguments[0])) {
                    port = INTEROP.asInt(arguments[0]);
                }
                if (arguments.length > 1) {
                    if (INTEROP.isString(arguments[1])) {
                        host = INTEROP.asString(arguments[1]);
                    }
                    if (arguments.length > 2 && INTEROP.isBoolean(arguments[2])) {
                        wait = INTEROP.asBoolean(arguments[2]);
                    }
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
        }
        if ((newConnection = this.open.open(port, host, wait)) != null) {
            this.connection = newConnection;
            this.console.setConnection(newConnection);
        }
        return NullObject.INSTANCE;
    }

    private Object methodUrl() {
        if (this.connection != null) {
            return this.connection.getURL();
        }
        return NullObject.INSTANCE;
    }
}

