/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector;

import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import java.util.HashMap;
import java.util.Map;

public final class RemoteObjectsHandler {
    private final Map<String, RemoteObject> remotesByIDs = new HashMap<String, RemoteObject>(100);
    private final Map<DebugValue, RemoteObject> remotesByValue = new HashMap<DebugValue, RemoteObject>(100);
    private final Map<String, DebugValue> customPreviewBodies = new HashMap<String, DebugValue>();
    private final Map<String, DebugValue> customPreviewConfigs = new HashMap<String, DebugValue>();
    private final InspectorExecutionContext context;

    RemoteObjectsHandler(InspectorExecutionContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteObject getRemote(DebugValue value) {
        RemoteObject remote;
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            remote = this.remotesByValue.get(value);
            if (remote == null) {
                remote = new RemoteObject(value, false, this.context);
                this.remotesByValue.put(value, remote);
                this.remotesByIDs.put(remote.getId(), remote);
            }
        }
        return remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteObject getRemote(String objectId) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            return this.remotesByIDs.get(objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(RemoteObject remote) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            this.remotesByIDs.put(remote.getId(), remote);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            this.remotesByIDs.clear();
            this.remotesByValue.clear();
            this.customPreviewBodies.clear();
            this.customPreviewConfigs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCustomPreviewBody(String id, DebugValue body) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            this.customPreviewBodies.put(id, body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebugValue getCustomPreviewBody(String id) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            return this.customPreviewBodies.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCustomPreviewConfig(String objectId, DebugValue config) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            this.customPreviewConfigs.put(objectId, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebugValue getCustomPreviewConfig(String id) {
        Map<String, RemoteObject> map = this.remotesByIDs;
        synchronized (map) {
            return this.customPreviewConfigs.get(id);
        }
    }
}

