/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NetworkAccess {
    private static final Logger err = Logger.getLogger(NetworkAccess.class.getName());
    private static final RequestProcessor NETWORK_ACCESS = new RequestProcessor("autoupdate-network-access", 10, false);
    private static final int MAX_REDIRECTS = 10;

    private NetworkAccess() {
    }

    public static Task createNetworkAcessTask(URL uRL, int n, NetworkListener networkListener) {
        return new Task(uRL, n, networkListener);
    }

    public static void initSSL(HttpURLConnection httpURLConnection) throws IOException {
        if (httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            try {
                TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }
                }};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(null, trustManagerArray, new SecureRandom());
                httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String string, SSLSession sSLSession) {
                        return true;
                    }
                });
                httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
            }
            catch (KeyManagementException keyManagementException) {
                throw new IOException(keyManagementException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException(noSuchAlgorithmException);
            }
        }
    }

    private static URLConnection checkRedirect(URLConnection uRLConnection, int n) throws IOException {
        if (uRLConnection instanceof HttpURLConnection) {
            String string;
            uRLConnection.connect();
            int n2 = ((HttpURLConnection)uRLConnection).getResponseCode();
            if (!(n2 != 302 && n2 != 301 || null == (string = uRLConnection.getHeaderField("Location")) || string.isEmpty())) {
                URL uRL = new URL(string);
                URLConnection uRLConnection2 = uRL.openConnection();
                uRLConnection2.setRequestProperty("User-Agent", "NetBeans");
                uRLConnection2.setConnectTimeout(n);
                uRLConnection2.setReadTimeout(n);
                if (uRLConnection2 instanceof HttpsURLConnection) {
                    NetworkAccess.initSSL((HttpsURLConnection)uRLConnection2);
                }
                return uRLConnection2;
            }
        }
        return uRLConnection;
    }

    public static interface NetworkListener {
        public void streamOpened(InputStream var1, int var2);

        public void accessCanceled();

        public void accessTimeOut();

        public void notifyException(Exception var1);
    }

    private static interface SizedConnection
    extends Callable<InputStream> {
        public int getContentLength();
    }

    public static class Task
    implements Cancellable {
        private URL url;
        private int timeout;
        private NetworkListener listener;
        private final ExecutorService es = Executors.newSingleThreadExecutor();
        private Future<InputStream> connect = null;
        private RequestProcessor.Task rpTask = null;

        private Task(URL uRL, int n, NetworkListener networkListener) {
            if (uRL == null) {
                throw new IllegalArgumentException("URL cannot be null.");
            }
            if (networkListener == null) {
                throw new IllegalArgumentException("NetworkListener cannot be null.");
            }
            this.url = uRL;
            this.timeout = n;
            this.listener = networkListener;
            this.postTask();
        }

        private void postTask() {
            final SizedConnection sizedConnection = this.createCallableNetwork(this.url, this.timeout);
            this.rpTask = NETWORK_ACCESS.post(new Runnable(){

                @Override
                public void run() {
                    connect = es.submit(sizedConnection);
                    try {
                        InputStream inputStream = (InputStream)connect.get(timeout, TimeUnit.MILLISECONDS);
                        if (connect.isDone()) {
                            listener.streamOpened(inputStream, sizedConnection.getContentLength());
                        } else if (connect.isCancelled()) {
                            listener.accessCanceled();
                        } else {
                            listener.accessTimeOut();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        listener.notifyException(interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        if (throwable != null && throwable instanceof Exception) {
                            listener.notifyException((Exception)throwable);
                        } else {
                            listener.notifyException(executionException);
                        }
                    }
                    catch (CancellationException cancellationException) {
                        listener.accessCanceled();
                    }
                    catch (TimeoutException timeoutException) {
                        IOException iOException = new IOException(NbBundle.getMessage(NetworkAccess.class, (String)"NetworkAccess_Timeout", (Object)url));
                        iOException.initCause(timeoutException);
                        listener.notifyException(iOException);
                    }
                }
            });
        }

        public void waitFinished() {
            assert (this.rpTask != null) : "RequestProcessor.Task must be initialized.";
            this.rpTask.waitFinished();
        }

        public boolean isFinished() {
            assert (this.rpTask != null) : "RequestProcessor.Task must be initialized.";
            return this.rpTask.isFinished();
        }

        private SizedConnection createCallableNetwork(final URL uRL, final int n) {
            return new SizedConnection(){
                private int contentLength = -1;

                @Override
                public int getContentLength() {
                    return this.contentLength;
                }

                @Override
                public InputStream call() throws Exception {
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(n);
                    uRLConnection.setReadTimeout(n);
                    if (uRLConnection instanceof HttpsURLConnection) {
                        NetworkAccess.initSSL((HttpsURLConnection)uRLConnection);
                    }
                    int n2 = 0;
                    URLConnection uRLConnection2 = uRLConnection;
                    while ((uRLConnection = uRLConnection2) != (uRLConnection2 = NetworkAccess.checkRedirect(uRLConnection, n)) && ++n2 <= 10) {
                    }
                    if (uRLConnection != uRLConnection2) {
                        throw new IOException("Too many redirects for " + uRL);
                    }
                    InputStream inputStream = uRLConnection.getInputStream();
                    this.contentLength = uRLConnection.getContentLength();
                    if (err.isLoggable(Level.FINE)) {
                        Map<String, List<String>> map = uRLConnection.getHeaderFields();
                        StringBuilder stringBuilder = new StringBuilder("Connection opened for:\n");
                        stringBuilder.append("    Url: ").append(uRLConnection.getURL()).append("\n");
                        for (String string : map.keySet()) {
                            stringBuilder.append("    ").append(string == null ? "Status" : string).append(": ").append(map.get(string)).append("\n");
                        }
                        stringBuilder.append("\n");
                        err.log(Level.FINE, stringBuilder.toString());
                    }
                    return new BufferedInputStream(inputStream);
                }
            };
        }

        public boolean cancel() {
            return this.connect.cancel(true);
        }
    }
}

