/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.nodes;

import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.ui.results.PackageColorer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NormalBoldGrayRenderer;
import org.openide.util.ImageUtilities;

public interface TruffleObjectNode<O extends TruffleObject> {
    public O getTruffleObject();

    public String getName(Heap var1);

    public String getObjectName(Heap var1);

    public String getTypeName();

    public String getLogicalValue(Heap var1);

    public static class Renderer
    extends NormalBoldGrayRenderer
    implements HeapViewerRenderer {
        private static final Image IMAGE_LOOP = Icons.getImage((String)"HeapWalkerIcons.Loop");
        private final Icon icon;
        private final Heap heap;

        public Renderer(Heap heap, Icon icon) {
            this.heap = heap;
            this.icon = icon;
        }

        public void setValue(Object value, int row) {
            String name;
            TruffleObjectNode node = (TruffleObjectNode)value;
            String string = name = node == null ? "" : node.getObjectName(this.heap);
            if (name != null && !"null".equals(name)) {
                super.setNormalValue("");
                super.setBoldValue(name);
            } else {
                super.setNormalValue("null");
                super.setBoldValue(null);
            }
            String logValue = node == null ? null : node.getLogicalValue(this.heap);
            this.setGrayValue(logValue == null ? "" : " : " + logValue);
            this.setIcon(this.icon);
            this.setIconTextGap(0);
            ((LabelRenderer)this.valueRenderers()[0]).setMargin(3, 0, 3, 0);
            this.setCustomForeground(PackageColorer.getForeground((String)this.getBoldValue()));
        }

        public void flagLoopTo() {
            Image loopImage = ImageUtilities.icon2Image((Icon)this.getIcon());
            this.setIcon(new ImageIcon(ImageUtilities.mergeImages((Image)loopImage, (Image)IMAGE_LOOP, (int)0, (int)0)));
            this.setIconTextGap(4);
            ((LabelRenderer)this.valueRenderers()[0]).setMargin(3, 1, 3, 0);
        }

        public String getShortName() {
            return this.getBoldValue();
        }

        protected boolean supportsCustomGrayForeground() {
            return false;
        }
    }

    public static abstract class InstanceBased<O extends TruffleObject.InstanceBased>
    extends InstanceNode
    implements TruffleObjectNode<O> {
        private final O object;
        private final String typeName;
        private String objectNameString;
        private String logicalValue;

        public InstanceBased(O object, String typeName) {
            super(((TruffleObject.InstanceBased)object).getInstance());
            this.object = object;
            this.typeName = typeName;
        }

        @Override
        public O getTruffleObject() {
            return this.object;
        }

        @Override
        public String getName(Heap heap) {
            return this.getObjectName(heap);
        }

        @Override
        public String getObjectName(Heap heap) {
            if (this.objectNameString == null) {
                this.objectNameString = this.computeObjectName(heap);
            }
            return this.objectNameString;
        }

        protected String computeObjectName(Heap heap) {
            return this.getTypeName() + "#" + this.getInstance().getInstanceNumber();
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public String getLogicalValue(Heap heap) {
            if (this.logicalValue == null) {
                this.logicalValue = this.computeLogicalValue(this.object, this.typeName, heap);
                if (this.logicalValue == null) {
                    this.logicalValue = "";
                }
            }
            return this.logicalValue.isEmpty() ? null : this.logicalValue;
        }

        protected String computeLogicalValue(O object, String type, Heap heap) {
            return DetailsSupport.getDetailsString((Instance)((TruffleObject.InstanceBased)object).getInstance(), (Heap)heap);
        }

        public long getOwnSize() {
            return ((TruffleObject)this.object).getSize();
        }

        public long getRetainedSize(Heap heap) {
            return DataType.RETAINED_SIZE.valuesAvailable(heap) ? ((TruffleObject)this.object).getRetainedSize() : ((Long)DataType.RETAINED_SIZE.getNotAvailableValue()).longValue();
        }

        protected Object getValue(DataType type, Heap heap) {
            if (type == TruffleType.TYPE_NAME) {
                return this.getTypeName();
            }
            if (type == TruffleObject.DATA_TYPE) {
                return this.getTruffleObject();
            }
            return super.getValue(type, heap);
        }

        protected void setupCopy(InstanceBased copy) {
            super.setupCopy((InstanceNode)copy);
            copy.objectNameString = this.objectNameString;
            copy.logicalValue = this.logicalValue;
        }
    }
}

