/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.dynamicobject;

import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;

public class DynamicObjectNode<O extends DynamicObject>
extends TruffleObjectNode.InstanceBased<O> {
    public DynamicObjectNode(O dobject, String type) {
        super(dobject, type);
    }

    @Override
    protected String computeLogicalValue(O object, String type, Heap heap) {
        return DynamicObjectNode.defaultLogicalValue(object, type, heap);
    }

    protected void setupCopy(DynamicObjectNode copy) {
        super.setupCopy(copy);
    }

    protected static String defaultLogicalValue(DynamicObject object, String type, Heap heap) {
        String val = DetailsSupport.getDetailsString((Instance)object.getInstance(), (Heap)heap);
        if (val != null && val.startsWith("(") && val.contains("#")) {
            val = null;
        }
        return val != null ? val : "shape #" + object.getShape().getInstanceNumber();
    }
}

