/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.cpu;

import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;

public abstract class FlatProfileContainer {
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_TIME = 2;
    public static final int SORT_BY_SECONDARY_TIME = 3;
    public static final int SORT_BY_INV_NUMBER = 4;
    public static final int SORT_BY_TOTAL_TIME = 5;
    public static final int SORT_BY_SECONDARY_TOTAL_TIME = 6;
    protected static boolean staticUsePrimaryTime;
    protected int[] methodIds;
    protected final char[] methodMarks;
    protected int[] nInvocations;
    protected float[] percent;
    protected long[] timeInMcs0;
    protected long[] timeInMcs1;
    protected long[] totalTimeInMcs0;
    protected long[] totalTimeInMcs1;
    protected boolean collectingTwoTimeStamps;
    protected long nTotalInvocations;
    protected int nRows;
    private int totalMethods;

    public FlatProfileContainer(long[] timeInMcs0, long[] timeInMcs1, long[] totalTimeInMcs0, long[] totalTimeInMcs1, int[] nInvocations, char[] marks, int nMethods) {
        this.timeInMcs0 = timeInMcs0;
        this.timeInMcs1 = timeInMcs1;
        this.totalTimeInMcs0 = totalTimeInMcs0;
        this.totalTimeInMcs1 = totalTimeInMcs1;
        this.nInvocations = nInvocations;
        this.methodMarks = marks;
        this.totalMethods = nMethods;
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public int getMethodIdAtRow(int row) {
        return this.methodIds[row];
    }

    public abstract String getMethodNameAtRow(int var1);

    public abstract ClientUtils.SourceCodeSelection getSourceCodeSelectionAtRow(int var1);

    public int getNInvocationsAtRow(int row) {
        return this.nInvocations[row];
    }

    public int getNRows() {
        return this.nRows;
    }

    public long getNTotalInvocations() {
        return this.nTotalInvocations;
    }

    public float getPercentAtRow(int row) {
        return this.percent[row];
    }

    public long getTimeInMcs0AtRow(int row) {
        return this.timeInMcs0[row];
    }

    public long getTimeInMcs1AtRow(int row) {
        return this.timeInMcs1[row];
    }

    public long getTotalTimeInMcs0AtRow(int row) {
        return this.totalTimeInMcs0[row];
    }

    public long getTotalTimeInMcs1AtRow(int row) {
        return this.totalTimeInMcs1[row];
    }

    public abstract double getWholeGraphNetTime0();

    public abstract double getWholeGraphNetTime1();

    public void filterOriginalData(String[] filters, int type, double valueFilter) {
    }

    public void sortBy(int sortCrit, boolean order) {
    }

    protected void removeZeroInvocationEntries() {
        this.nRows = 0;
        for (int i = 1; i < this.totalMethods; ++i) {
            if (this.nInvocations[i] <= 0) continue;
            ++this.nRows;
        }
        long[] oldTime0 = this.timeInMcs0;
        long[] oldTime1 = this.timeInMcs1;
        long[] oldTotalTime0 = this.totalTimeInMcs0;
        long[] oldTotalTime1 = this.totalTimeInMcs1;
        int[] oldNInvocations = this.nInvocations;
        this.timeInMcs0 = new long[this.nRows];
        this.totalTimeInMcs0 = new long[this.nRows];
        if (this.collectingTwoTimeStamps) {
            this.timeInMcs1 = new long[this.nRows];
            this.totalTimeInMcs1 = new long[this.nRows];
        }
        this.nInvocations = new int[this.nRows];
        this.methodIds = new int[this.nRows];
        int k = 0;
        for (int i = 1; i < this.totalMethods; ++i) {
            if (oldNInvocations[i] <= 0) continue;
            long time = oldTime0[i];
            if (time < 0L) {
                time = 0L;
            }
            this.timeInMcs0[k] = time;
            time = oldTotalTime0[i];
            if (time < 0L) {
                time = 0L;
            }
            this.totalTimeInMcs0[k] = time;
            if (this.collectingTwoTimeStamps) {
                time = oldTime1[i];
                if (time < 0L) {
                    time = 0L;
                }
                this.timeInMcs1[k] = time;
                time = oldTotalTime1[i];
                if (time < 0L) {
                    time = 0L;
                }
                this.totalTimeInMcs1[k] = time;
            }
            this.nInvocations[k] = oldNInvocations[i];
            this.nTotalInvocations += (long)oldNInvocations[i];
            this.methodIds[k] = i;
            ++k;
        }
        this.totalMethods = this.nRows;
    }

    private void calculatePercent(boolean usePrimaryTime) {
        this.percent = new float[this.nRows];
        double wholeNetTime = this.getWholeGraphNetTime0();
        long[] tpm = this.timeInMcs0;
        if (this.collectingTwoTimeStamps && !usePrimaryTime) {
            wholeNetTime = this.getWholeGraphNetTime1();
            tpm = this.timeInMcs1;
        }
        for (int i = 0; i < this.nRows; ++i) {
            this.percent[i] = (float)(wholeNetTime > 0.0 ? (double)tpm[i] / wholeNetTime * 100.0 : 0.0);
        }
        staticUsePrimaryTime = usePrimaryTime;
    }

    private boolean passedFilter(String value, String filter, int type) {
        return false;
    }

    protected void swap(int a, int b) {
    }
}

