/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.HprofByteBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.HprofGCRoots;
import org.graalvm.visualvm.lib.jfluid.heap.HprofObject;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

class HprofGCRoot
extends HprofObject
implements GCRoot {
    static Map kindMap = new HashMap();
    HprofGCRoots roots;

    HprofGCRoot(HprofGCRoots r, long offset) {
        super(offset);
        this.roots = r;
    }

    @Override
    public Instance getInstance() {
        return this.roots.heap.getInstanceByID(this.getInstanceId());
    }

    @Override
    public String getKind() {
        byte k = this.getHprofBuffer().get(this.fileOffset);
        return (String)kindMap.get(k & 0xFF);
    }

    long getInstanceId() {
        return this.getHprofBuffer().getID(this.fileOffset + 1L);
    }

    HprofByteBuffer getHprofBuffer() {
        return this.roots.heap.dumpBuffer;
    }

    static {
        kindMap.put(255, "unknown");
        kindMap.put(1, "JNI global");
        kindMap.put(2, "JNI local");
        kindMap.put(3, "Java frame");
        kindMap.put(4, "native stack");
        kindMap.put(5, "sticky class");
        kindMap.put(6, "thread block");
        kindMap.put(7, "monitor used");
        kindMap.put(8, "thread object");
        kindMap.put(137, "interned string");
        kindMap.put(138, "finalizing");
        kindMap.put(139, "debugger");
        kindMap.put(140, "reference cleanup");
        kindMap.put(141, "VM internal");
        kindMap.put(142, "JNI monitor");
    }
}

