/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.classfile;

import org.graalvm.visualvm.lib.jfluid.classfile.ClassInfo;
import org.graalvm.visualvm.lib.jfluid.instrumentation.JavaClassConstants;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;

public class ClassFileParser
implements JavaClassConstants {
    private ClassInfo classInfo;
    private byte[] classBuf;
    private Object[] cpObjectCache;
    private int[] cpOffsets;
    private byte[] cpTags;
    private int curBufPos;

    public void parseClassFile(byte[] classFile, ClassInfo classInfo) throws ClassFileReadException {
        this.classBuf = classFile;
        this.classInfo = classInfo;
        this.curBufPos = 0;
        try {
            this.readPreamble();
            this.readConstantPool();
            this.readIntermediate();
            this.skipFields();
            this.readMethods();
            this.readAttributes();
        }
        catch (ClassFileReadRuntimeException e) {
            throw new ClassFileReadException(e);
        }
    }

    private char getChar(int bufPos) {
        return (char)(((this.classBuf[bufPos++] & 0xFF) << 8) + (this.classBuf[bufPos++] & 0xFF));
    }

    private void badCPEntry(int entryNo) {
        throw this.classFileReadException("Constant pool entry " + entryNo + " : invalid type");
    }

    private void badCPReference(int ofs, int i) {
        throw this.classFileReadException("Bad constant pool reference: " + ofs + " from entry " + i);
    }

    private ClassFileReadRuntimeException classFileReadException(String msg) {
        msg = "Error reading class " + this.classInfo.name + ":\n" + msg;
        return new ClassFileReadRuntimeException(msg);
    }

    private String classNameAtCPIndex(int idx) {
        if (this.cpTags[idx] != 1) {
            throw this.classFileReadException("Constant pool entry " + idx + " should be UTF8 constant");
        }
        int arrayLevel = 0;
        if (this.cpObjectCache[idx] == null) {
            int stPos;
            int utf8Len = this.getChar(this.cpOffsets[idx]);
            int initStPos = stPos = this.cpOffsets[idx] + 2;
            while (this.classBuf[stPos] == 91) {
                ++stPos;
                ++arrayLevel;
            }
            if (stPos != initStPos && this.classBuf[stPos] == 76) {
                ++stPos;
                --utf8Len;
            }
            String res = StringUtils.utf8ToString(this.classBuf, stPos, utf8Len -= stPos - initStPos);
            for (int i = 0; i < arrayLevel; ++i) {
                res = "[" + res;
            }
            this.cpObjectCache[idx] = res;
        }
        return (String)this.cpObjectCache[idx];
    }

    private ClassFileReadRuntimeException dataFormatError() {
        return this.classFileReadException("Data format error");
    }

    private char nextChar() {
        return (char)(((this.classBuf[this.curBufPos++] & 0xFF) << 8) + (this.classBuf[this.curBufPos++] & 0xFF));
    }

    private int nextInt() {
        return ((this.classBuf[this.curBufPos++] & 0xFF) << 24) + ((this.classBuf[this.curBufPos++] & 0xFF) << 16) + ((this.classBuf[this.curBufPos++] & 0xFF) << 8) + (this.classBuf[this.curBufPos++] & 0xFF);
    }

    private void readAttributes() {
        this.classInfo.attrsStartOfs = this.curBufPos;
        int attrCount = this.nextChar();
        for (int i = 0; i < attrCount; ++i) {
            char attrNameIdx = this.nextChar();
            int attrLen = this.nextInt();
            if (this.utf8AtCPIndex(attrNameIdx).equals("InnerClasses")) {
                int nOfClasses = this.nextChar();
                String[] nestedClasses = new String[nOfClasses];
                int curIdx = 0;
                int nonMemberClassCount = 0;
                for (int j = 0; j < nOfClasses; ++j) {
                    char innerClassInfoIdx = this.nextChar();
                    char outerClassInfoIdx = this.nextChar();
                    char innerClassNameIdx = this.nextChar();
                    char innerClassAccessFlags = this.nextChar();
                    String nestedClassFullName = this.classNameAtCPIndex(this.getChar(this.cpOffsets[innerClassInfoIdx]));
                    if (innerClassNameIdx != '\u0000') {
                        String nestedClassSimpleName = this.utf8AtCPIndex(innerClassNameIdx);
                        if (!nestedClassFullName.equals(this.classInfo.name + "$" + nestedClassSimpleName)) {
                            int count = nonMemberClassCount + 1;
                            if (!nestedClassFullName.equals(this.classInfo.name + "$" + count + "$" + nestedClassSimpleName)) continue;
                            nonMemberClassCount = count;
                        }
                    } else if (!nestedClassFullName.equals(this.classInfo.name + "$" + ++nonMemberClassCount)) continue;
                    nestedClasses[curIdx++] = nestedClassFullName;
                }
                if (curIdx == nOfClasses) {
                    this.classInfo.nestedClassNames = nestedClasses;
                    break;
                }
                if (curIdx <= 0) break;
                this.classInfo.nestedClassNames = new String[curIdx];
                System.arraycopy(nestedClasses, 0, this.classInfo.nestedClassNames, 0, curIdx);
                break;
            }
            this.curBufPos += attrLen;
        }
    }

    private void readConstantPool() {
        int methodRefsNo = 0;
        int classRefsNo = 0;
        this.classInfo.cpoolStartOfs = this.curBufPos;
        this.classInfo.origCPoolCount = this.nextChar();
        this.cpOffsets = new int[this.classInfo.origCPoolCount];
        this.cpTags = new byte[this.classInfo.origCPoolCount];
        int cpStart = this.curBufPos;
        int i = 1;
        block9: while (i < this.cpOffsets.length) {
            byte tag = this.classBuf[this.curBufPos++];
            this.cpOffsets[i] = this.curBufPos;
            this.cpTags[i] = tag;
            ++i;
            switch (tag) {
                case 1: {
                    char len = this.nextChar();
                    this.curBufPos += len;
                    continue block9;
                }
                case 7: {
                    ++classRefsNo;
                }
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    this.curBufPos += 2;
                    continue block9;
                }
                case 15: {
                    this.curBufPos += 3;
                    continue block9;
                }
                case 3: 
                case 4: 
                case 9: 
                case 12: 
                case 17: 
                case 18: {
                    this.curBufPos += 4;
                    continue block9;
                }
                case 10: 
                case 11: {
                    ++methodRefsNo;
                    this.curBufPos += 4;
                    continue block9;
                }
                case 5: 
                case 6: {
                    this.curBufPos += 8;
                    ++i;
                    continue block9;
                }
            }
            throw this.classFileReadException("Bad constant pool tag: " + tag + " at " + Integer.toString(this.curBufPos - 1));
        }
        this.classInfo.cpoolRefsToMethodIdx = new char[methodRefsNo];
        this.classInfo.cpoolRefsToMethodClassNameAndSig = new String[methodRefsNo][3];
        this.classInfo.cpoolRefsToClassIdx = new char[classRefsNo];
        this.classInfo.cpoolRefsToClassName = new String[classRefsNo];
        int curMethodRef = 0;
        int curClassRef = 0;
        this.cpObjectCache = new Object[this.cpOffsets.length];
        for (i = 0; i < this.cpOffsets.length; ++i) {
            int ofs = this.cpOffsets[i];
            if (this.cpTags[i] == 10 || this.cpTags[i] == 11) {
                this.classInfo.cpoolRefsToMethodIdx[curMethodRef] = (char)i;
                this.classInfo.cpoolRefsToMethodClassNameAndSig[curMethodRef] = new String[3];
                char classIdx = this.getChar(ofs);
                char nameAndTypeIdx = this.getChar(ofs + 2);
                if (this.cpTags[classIdx] != 7 || this.cpTags[nameAndTypeIdx] != 12) {
                    this.badCPReference(ofs, i);
                }
                this.classInfo.cpoolRefsToMethodClassNameAndSig[curMethodRef][0] = this.classNameAtCPIndex(this.getChar(this.cpOffsets[classIdx]));
                ofs = this.cpOffsets[nameAndTypeIdx];
                char nameIdx = this.getChar(ofs);
                char sigIdx = this.getChar(ofs + 2);
                if (this.cpTags[nameIdx] != 1 || this.cpTags[sigIdx] != 1) {
                    this.badCPReference(ofs, i);
                }
                this.classInfo.cpoolRefsToMethodClassNameAndSig[curMethodRef][1] = this.utf8AtCPIndex(nameIdx);
                this.classInfo.cpoolRefsToMethodClassNameAndSig[curMethodRef][2] = this.signatureAtCPIndex(sigIdx);
                ++curMethodRef;
                continue;
            }
            if (this.cpTags[i] != 7) continue;
            this.classInfo.cpoolRefsToClassIdx[curClassRef] = (char)i;
            this.classInfo.cpoolRefsToClassName[curClassRef] = this.classNameAtCPIndex(this.getChar(ofs));
            ++curClassRef;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readIntermediate() {
        this.classInfo.intermediateDataStartOfs = this.curBufPos;
        this.classInfo.accessFlags = this.nextChar();
        char classIdx = this.nextChar();
        this.classInfo.classIndex = classIdx;
        if (this.cpTags[classIdx] != 7) {
            throw this.classFileReadException("Bad reference to this class name");
        }
        this.classInfo.name = this.classNameAtCPIndex(this.getChar(this.cpOffsets[classIdx]));
        char superClassIdx = this.nextChar();
        if (this.cpTags[superClassIdx] != 7) {
            if (superClassIdx != '\u0000' || !this.classInfo.name.equals("java/lang/Object")) throw this.classFileReadException("Bad reference to super class name");
            this.classInfo.superName = "java/lang/Object";
        } else {
            this.classInfo.superName = this.classNameAtCPIndex(this.getChar(this.cpOffsets[superClassIdx]));
        }
        int intfCount = this.nextChar();
        if (intfCount == 0) return;
        this.classInfo.interfaces = new String[intfCount];
        for (int i = 0; i < intfCount; ++i) {
            classIdx = this.nextChar();
            if (this.cpTags[classIdx] != 7) {
                throw this.classFileReadException("Bad reference to an implemented interface");
            }
            this.classInfo.interfaces[i] = this.classNameAtCPIndex(this.getChar(this.cpOffsets[classIdx]));
        }
    }

    private void readMethods() {
        this.classInfo.methodsStartOfs = this.curBufPos;
        int methodCount = this.nextChar();
        if (methodCount == 0) {
            this.classInfo.methodNames = new String[0];
            return;
        }
        String[] names = new String[methodCount];
        String[] signatures = new String[methodCount];
        char[] accessFlags = new char[methodCount];
        int[] methodInfoOffsets = new int[methodCount];
        int[] methodInfoLengths = new int[methodCount];
        int[] bytecodeOffsets = new int[methodCount];
        char[] bytecodeLengths = new char[methodCount];
        int[] exceptionTableStartOffsets = new int[methodCount];
        int[] lineNumberTableOffsets = new int[methodCount];
        char[] lineNumberTableLengths = new char[methodCount];
        int[] localVariableTableOffsets = new int[methodCount];
        char[] localVariableTableLengths = new char[methodCount];
        int localVaribaleTableCPindex = 0;
        int[] localVariableTypeTableOffsets = new int[methodCount];
        char[] localVariableTypeTableLengths = new char[methodCount];
        int localVaribaleTypeTableCPindex = 0;
        int[] stackMapTableOffsets = new int[methodCount];
        char[] stackMapTableLengths = new char[methodCount];
        int stackMapTableCPindex = 0;
        for (int i = 0; i < methodCount; ++i) {
            methodInfoOffsets[i] = this.curBufPos;
            accessFlags[i] = this.nextChar();
            names[i] = this.utf8AtCPIndex(this.nextChar());
            signatures[i] = this.signatureAtCPIndex(this.nextChar());
            bytecodeOffsets[i] = 0;
            lineNumberTableOffsets[i] = 0;
            localVariableTableOffsets[i] = 0;
            localVariableTypeTableOffsets[i] = 0;
            int attrCount = this.nextChar();
            for (int j = 0; j < attrCount; ++j) {
                char attrNameIdx = this.nextChar();
                int attrLen = this.nextInt();
                if (this.utf8AtCPIndex(attrNameIdx).equals("Code")) {
                    this.curBufPos += 4;
                    char codeLen = bytecodeLengths[i] = (char)this.nextInt();
                    bytecodeOffsets[i] = this.curBufPos - methodInfoOffsets[i];
                    this.curBufPos += codeLen;
                    exceptionTableStartOffsets[i] = this.curBufPos - methodInfoOffsets[i];
                    int count = this.nextChar();
                    this.curBufPos += 8 * count;
                    count = this.nextChar();
                    for (int k = 0; k < count; ++k) {
                        char tableLen;
                        attrNameIdx = this.nextChar();
                        attrLen = this.nextInt();
                        if (this.utf8AtCPIndex(attrNameIdx).equals("LineNumberTable")) {
                            tableLen = lineNumberTableLengths[i] = this.nextChar();
                            lineNumberTableOffsets[i] = this.curBufPos - methodInfoOffsets[i];
                            this.curBufPos += 4 * tableLen;
                            continue;
                        }
                        if (this.utf8AtCPIndex(attrNameIdx).equals("LocalVariableTable")) {
                            tableLen = localVariableTableLengths[i] = this.nextChar();
                            localVariableTableOffsets[i] = this.curBufPos - methodInfoOffsets[i];
                            this.curBufPos += 10 * tableLen;
                            if (localVaribaleTableCPindex == 0) {
                                localVaribaleTableCPindex = attrNameIdx;
                                continue;
                            }
                            assert (localVaribaleTableCPindex == attrNameIdx);
                            continue;
                        }
                        if (this.utf8AtCPIndex(attrNameIdx).equals("LocalVariableTypeTable")) {
                            tableLen = localVariableTypeTableLengths[i] = this.nextChar();
                            localVariableTypeTableOffsets[i] = this.curBufPos - methodInfoOffsets[i];
                            this.curBufPos += 10 * tableLen;
                            if (localVaribaleTypeTableCPindex == 0) {
                                localVaribaleTypeTableCPindex = attrNameIdx;
                                continue;
                            }
                            assert (localVaribaleTypeTableCPindex == attrNameIdx);
                            continue;
                        }
                        if (this.utf8AtCPIndex(attrNameIdx).equals("StackMapTable")) {
                            tableLen = stackMapTableLengths[i] = this.nextChar();
                            stackMapTableOffsets[i] = this.curBufPos - methodInfoOffsets[i];
                            this.curBufPos += attrLen - 2;
                            if (stackMapTableCPindex == 0) {
                                stackMapTableCPindex = attrNameIdx;
                                continue;
                            }
                            assert (stackMapTableCPindex == attrNameIdx);
                            continue;
                        }
                        this.curBufPos += attrLen;
                    }
                    continue;
                }
                this.curBufPos += attrLen;
            }
            methodInfoLengths[i] = this.curBufPos - methodInfoOffsets[i];
        }
        this.classInfo.methodNames = names;
        this.classInfo.methodSignatures = signatures;
        this.classInfo.methodAccessFlags = accessFlags;
        this.classInfo.methodInfoOffsets = methodInfoOffsets;
        this.classInfo.methodInfoLengths = methodInfoLengths;
        this.classInfo.methodBytecodesOffsets = bytecodeOffsets;
        this.classInfo.methodBytecodesLengths = bytecodeLengths;
        this.classInfo.exceptionTableStartOffsets = exceptionTableStartOffsets;
        this.classInfo.lineNumberTablesOffsets = lineNumberTableOffsets;
        this.classInfo.lineNumberTablesLengths = lineNumberTableLengths;
        this.classInfo.localVariableTablesOffsets = localVariableTableOffsets;
        this.classInfo.localVariableTablesLengths = localVariableTableLengths;
        this.classInfo.localVaribaleTableCPindex = localVaribaleTableCPindex;
        this.classInfo.localVariableTypeTablesOffsets = localVariableTypeTableOffsets;
        this.classInfo.localVariableTypeTablesLengths = localVariableTypeTableLengths;
        this.classInfo.localVaribaleTypeTableCPindex = localVaribaleTypeTableCPindex;
        this.classInfo.stackMapTablesOffsets = stackMapTableOffsets;
        this.classInfo.stackMapTablesLengths = stackMapTableLengths;
        this.classInfo.stackMapTableCPindex = stackMapTableCPindex;
    }

    private void readPreamble() {
        int magic = this.nextInt();
        if (magic != -889275714) {
            throw this.classFileReadException("Illegal start of class file");
        }
        char minorVersion = this.nextChar();
        char majorVersion = this.nextChar();
        if (majorVersion > '9' || majorVersion * 1000 + minorVersion < 45003) {
            String versionCode = majorVersion + "." + minorVersion;
            String message = "Unsupported class file version: " + versionCode;
            throw this.classFileReadException(message);
        }
        this.classInfo.majorVersion = majorVersion;
    }

    private String signatureAtCPIndex(int idx) {
        return this.utf8AtCPIndex(idx);
    }

    private void skipFields() {
        this.classInfo.fieldsStartOfs = this.curBufPos;
        int definedFieldCount = this.nextChar();
        for (int i = 0; i < definedFieldCount; ++i) {
            this.curBufPos += 6;
            int attrCount = this.nextChar();
            for (int j = 0; j < attrCount; ++j) {
                this.curBufPos += 2;
                int attrLen = this.nextInt();
                this.curBufPos += attrLen;
            }
        }
    }

    private String utf8AtCPIndex(int idx) {
        if (this.cpTags[idx] != 1) {
            throw this.classFileReadException("Constant pool entry " + idx + " should be UTF8 constant");
        }
        if (this.cpObjectCache[idx] == null) {
            char utf8Len = this.getChar(this.cpOffsets[idx]);
            this.cpObjectCache[idx] = StringUtils.utf8ToString(this.classBuf, this.cpOffsets[idx] + 2, utf8Len);
        }
        return (String)this.cpObjectCache[idx];
    }

    private static class ClassFileReadRuntimeException
    extends RuntimeException {
        public ClassFileReadRuntimeException(String msg) {
            super(msg);
        }
    }

    public static class ClassFileReadException
    extends Exception {
        ClassFileReadRuntimeException e;

        private ClassFileReadException(ClassFileReadRuntimeException e) {
            this.e = e;
        }

        @Override
        public Throwable getCause() {
            return this.e;
        }

        @Override
        public String getMessage() {
            return this.e.getMessage();
        }

        @Override
        public String toString() {
            return this.e.toString();
        }
    }
}

