/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.server;

import com.oracle.svm.hosted.server.SubstrateServerMessage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedByInterruptException;

public class StreamingServerMessageOutputStream
extends OutputStream {
    private final SubstrateServerMessage.ServerCommand command;
    private DataOutputStream original;
    private volatile boolean interrupted;
    private volatile boolean writing;

    public void setOriginal(OutputStream original) {
        this.original = new DataOutputStream(original);
    }

    StreamingServerMessageOutputStream(SubstrateServerMessage.ServerCommand command, OutputStream original) {
        this.command = command;
        this.original = new DataOutputStream(original);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.interrupted) {
            throw new ClosedByInterruptException();
        }
        this.writing = true;
        try {
            SubstrateServerMessage message = new SubstrateServerMessage(this.command, b, off, len);
            SubstrateServerMessage.send(message, this.original);
        }
        finally {
            this.writing = false;
        }
    }

    @Override
    public void flush() throws IOException {
        this.original.flush();
    }

    @Override
    public void close() throws IOException {
        this.original.close();
    }

    void writingInterrupted(boolean value) {
        this.interrupted = value;
    }

    public boolean isWriting() {
        return this.writing;
    }
}

