/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import java.io.File;
import java.io.FileDescriptor;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticFeature
class JNIRegistrationJava
extends JNIRegistrationUtil
implements GraalFeature {
    private NativeLibraries nativeLibraries;
    private final ConcurrentMap<String, Boolean> registeredLibraries = new ConcurrentHashMap<String, Boolean>();

    JNIRegistrationJava() {
    }

    @Override
    public void registerGraphBuilderPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, boolean analysis, boolean hosted) {
        InvocationPlugins.Registration systemRegistration = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), System.class);
        systemRegistration.register1("loadLibrary", String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode libnameNode) {
                String libname;
                if (libnameNode.isConstant() && (libname = (String)SubstrateObjectConstant.asObject(libnameNode.asConstant())) != null && NativeLibrarySupport.singleton().isPreregisteredBuiltinLibrary(libname) && JNIRegistrationJava.this.registeredLibraries.putIfAbsent(libname, Boolean.TRUE) != Boolean.TRUE) {
                    JNIRegistrationJava.this.nativeLibraries.addLibrary(libname, true);
                }
                return false;
            }
        });
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        JNIRegistrationJava.rerunClassInit((Feature.FeatureAccess)a, "java.io.RandomAccessFile", "java.lang.ProcessEnvironment");
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            if (JNIRegistrationJava.isPosix()) {
                JNIRegistrationJava.rerunClassInit((Feature.FeatureAccess)a, "java.lang.UNIXProcess");
            }
        } else {
            JNIRegistrationJava.rerunClassInit((Feature.FeatureAccess)a, "java.lang.ProcessImpl", "java.lang.ProcessHandleImpl", "java.io.FilePermission");
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        this.nativeLibraries = ((FeatureImpl.BeforeAnalysisAccessImpl)a).getNativeLibraries();
        JNIRegistrationJava.registerForThrowNew((Feature.FeatureAccess)a, "java.lang.Exception", "java.lang.Error", "java.lang.OutOfMemoryError", "java.lang.RuntimeException", "java.lang.NullPointerException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.IllegalArgumentException", "java.lang.IllegalAccessException", "java.lang.IllegalAccessError", "java.lang.InternalError", "java.lang.NoSuchFieldException", "java.lang.NoSuchMethodException", "java.lang.ClassNotFoundException", "java.lang.NumberFormatException", "java.lang.NoSuchFieldError", "java.lang.NoSuchMethodError", "java.lang.UnsatisfiedLinkError", "java.lang.StringIndexOutOfBoundsException", "java.lang.InstantiationException", "java.lang.UnsupportedOperationException", "java.io.IOException", "java.io.FileNotFoundException", "java.io.SyncFailedException", "java.io.InterruptedIOException", "java.util.zip.DataFormatException");
        JNIRuntimeAccess.register(JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.io.FileNotFoundException", String.class, String.class));
        JNIRuntimeAccess.register(JNIRegistrationJava.clazz((Feature.FeatureAccess)a, "java.lang.Integer"));
        JNIRuntimeAccess.register(JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.lang.Integer", Integer.TYPE));
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.lang.Integer", "value"));
        JNIRuntimeAccess.register(JNIRegistrationJava.clazz((Feature.FeatureAccess)a, "java.lang.Boolean"));
        JNIRuntimeAccess.register(JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.lang.Boolean", Boolean.TYPE));
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.lang.Boolean", "value"));
        JNIRuntimeAccess.register(JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.Boolean", "getBoolean", String.class));
        JNIRuntimeAccess.register(FileDescriptor.class);
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileDescriptor", "fd"));
        if (JNIRegistrationJava.isWindows()) {
            JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileDescriptor", "handle"));
        }
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileDescriptor", "append"));
        }
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileOutputStream", "fd"));
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileInputStream", "fd"));
        JNIRuntimeAccess.register(File.class);
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.File", "path"));
        JNIRuntimeAccess.register(byte[].class);
        JNIRuntimeAccess.register(String.class);
        JNIRuntimeAccess.register(System.class);
        JNIRuntimeAccess.register(JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.System", "getProperty", String.class));
        JNIRuntimeAccess.register(Charset.class);
        JNIRuntimeAccess.register(JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.nio.charset.Charset", "isSupported", String.class));
        JNIRuntimeAccess.register(JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.lang.String", byte[].class, String.class));
        JNIRuntimeAccess.register(JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.String", "getBytes", String.class));
        JNIRuntimeAccess.register(JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.String", "concat", String.class));
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.lang.String", "coder", "value"));
        }
        a.registerReachabilityHandler(JNIRegistrationJava::registerRandomAccessFileInitIDs, new Object[]{JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.io.RandomAccessFile", "initIDs", new Class[0])});
    }

    private static void registerRandomAccessFileInitIDs(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.RandomAccessFile", "fd"));
    }
}

