/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.UnknownClass;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.JavaLangSubstitutions;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoader;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageSingletonsSupportImpl;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.phases.AnalysisGraphBuilderPhase;
import com.oracle.svm.hosted.substitute.UnsafeAutomaticSubstitutionProcessor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.StaticDeoptimizingNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.nativeimage.hosted.Feature;

public final class SVMHost
implements HostVM {
    private final ConcurrentHashMap<AnalysisType, DynamicHub> typeToHub = new ConcurrentHashMap();
    private final ConcurrentHashMap<DynamicHub, AnalysisType> hubToType = new ConcurrentHashMap();
    private final Map<String, EnumSet<AnalysisType.UsageKind>> forbiddenTypes;
    private final OptionValues options;
    private final ClassLoader classLoader;
    private final ClassInitializationSupport classInitializationSupport;
    private final HostedStringDeduplication stringTable;
    private final UnsafeAutomaticSubstitutionProcessor automaticSubstitutions;
    private final List<BiConsumer<Feature.DuringAnalysisAccess, Class<?>>> classReachabilityListeners;

    public SVMHost(OptionValues options, ClassLoader classLoader, ClassInitializationSupport classInitializationSupport, UnsafeAutomaticSubstitutionProcessor automaticSubstitutions) {
        this.options = options;
        this.classLoader = classLoader;
        this.classInitializationSupport = classInitializationSupport;
        this.stringTable = HostedStringDeduplication.singleton();
        this.classReachabilityListeners = new ArrayList();
        this.forbiddenTypes = SVMHost.setupForbiddenTypes(options);
        this.automaticSubstitutions = automaticSubstitutions;
    }

    private static Map<String, EnumSet<AnalysisType.UsageKind>> setupForbiddenTypes(OptionValues options) {
        String[] forbiddenTypesOptionValues = (String[])SubstrateOptions.ReportAnalysisForbiddenType.getValue(options);
        HashMap<String, EnumSet<AnalysisType.UsageKind>> forbiddenTypes = new HashMap<String, EnumSet<AnalysisType.UsageKind>>();
        for (String forbiddenTypesOptionValue : forbiddenTypesOptionValues) {
            EnumSet<AnalysisType.UsageKind> usageKinds;
            String[] typeNameUsageKind = forbiddenTypesOptionValue.split(":", 2);
            if (typeNameUsageKind.length == 1) {
                usageKinds = EnumSet.allOf(AnalysisType.UsageKind.class);
            } else {
                String[] usageKindValues;
                usageKinds = EnumSet.noneOf(AnalysisType.UsageKind.class);
                for (String usageKindValue : usageKindValues = typeNameUsageKind[1].split(",")) {
                    usageKinds.add(AnalysisType.UsageKind.valueOf((String)usageKindValue));
                }
            }
            forbiddenTypes.put(typeNameUsageKind[0], usageKinds);
        }
        return forbiddenTypes.isEmpty() ? null : forbiddenTypes;
    }

    public void checkForbidden(AnalysisType type, AnalysisType.UsageKind kind) {
        if (this.forbiddenTypes == null) {
            return;
        }
        for (AnalysisType cur = type; cur != null; cur = cur.getSuperclass()) {
            EnumSet<AnalysisType.UsageKind> forbiddenType = this.forbiddenTypes.get(cur.getWrapped().toJavaName());
            if (forbiddenType == null || !forbiddenType.contains(kind)) continue;
            throw new UnsupportedFeatureException("Forbidden type " + cur.getWrapped().toJavaName() + (cur.equals((Object)type) ? "" : " (superclass of " + type.getWrapped().toJavaName() + ")") + " UsageKind: " + kind);
        }
    }

    public OptionValues options() {
        return this.options;
    }

    public GraphBuilderPhase.Instance createGraphBuilderPhase(HostedProviders providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
        return new AnalysisGraphBuilderPhase((Providers)providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, providers.getWordTypes());
    }

    public String inspectServerContentPath() {
        return (String)PointstoOptions.InspectServerContentPath.getValue(this.options);
    }

    public void warn(String message) {
        System.err.println("warning: " + message);
    }

    public String getImageName() {
        return (String)SubstrateOptions.Name.getValue(this.options);
    }

    public boolean isRelocatedPointer(Object originalObject) {
        return originalObject instanceof RelocatedPointer;
    }

    public void clearInThread() {
        Thread.currentThread().setContextClassLoader(SVMHost.class.getClassLoader());
        ImageSingletonsSupportImpl.HostedManagement.clearInThread();
    }

    public void installInThread(Object vmConfig) {
        Thread.currentThread().setContextClassLoader(this.classLoader);
        ImageSingletonsSupportImpl.HostedManagement.installInThread((ImageSingletonsSupportImpl.HostedManagement)vmConfig);
    }

    public Object getConfiguration() {
        return ImageSingletonsSupportImpl.HostedManagement.getAndAssertExists();
    }

    public void registerType(AnalysisType analysisType) {
        this.classInitializationSupport.maybeInitializeHosted((ResolvedJavaType)analysisType);
        DynamicHub hub = this.createHub(analysisType);
        DynamicHub existing = this.typeToHub.put(analysisType, hub);
        assert (existing == null);
        existing = this.hubToType.put(hub, analysisType);
        assert (existing == null);
        this.automaticSubstitutions.computeSubstitutions(this, GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType(analysisType.getJavaClass()), this.options);
    }

    public boolean isInitialized(AnalysisType type) {
        boolean shouldInitializeAtRuntime = this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)type);
        assert (shouldInitializeAtRuntime || type.getWrapped().isInitialized()) : "Types that are not marked for runtime initializations must have been initialized: " + type;
        return !shouldInitializeAtRuntime;
    }

    public Optional<AnalysisMethod> handleForeignCall(ForeignCallDescriptor foreignCallDescriptor, ForeignCallsProvider foreignCallsProvider) {
        SubstrateForeignCallsProvider foreignCalls = (SubstrateForeignCallsProvider)foreignCallsProvider;
        Optional<AnalysisMethod> targetMethod = Optional.empty();
        if (foreignCalls.getForeignCalls().size() > 0) {
            SubstrateForeignCallLinkage linkage = foreignCalls.lookupForeignCall(foreignCallDescriptor);
            targetMethod = Optional.of((AnalysisMethod)linkage.getMethod());
        }
        return targetMethod;
    }

    public DynamicHub dynamicHub(ResolvedJavaType type) {
        AnalysisType aType;
        if (type instanceof AnalysisType) {
            aType = (AnalysisType)type;
        } else if (type instanceof HostedType) {
            aType = ((HostedType)type).getWrapped();
        } else {
            throw VMError.shouldNotReachHere("Found unsupported type: " + type);
        }
        return this.typeToHub.get(aType);
    }

    public AnalysisType lookupType(DynamicHub hub) {
        assert (hub != null) : "Hub must not be null";
        return this.hubToType.get(hub);
    }

    private DynamicHub createHub(AnalysisType type) {
        DynamicHub superHub = null;
        if (type.isInstanceClass() && type.getSuperclass() != null || type.isArray()) {
            superHub = this.dynamicHub((ResolvedJavaType)type.getSuperclass());
        }
        DynamicHub componentHub = null;
        if (type.isArray()) {
            componentHub = this.dynamicHub((ResolvedJavaType)type.getComponentType());
        }
        Class javaClass = type.getJavaClass();
        int modifiers = javaClass.getModifiers();
        Target_java_lang_ClassLoader hubClassLoader = JavaLangSubstitutions.ClassLoaderSupport.getInstance().getOrCreate(javaClass.getClassLoader());
        String className = type.toClassName().intern();
        String sourceFileName = this.stringTable.deduplicate(type.getSourceFileName(), true);
        return new DynamicHub(className, type.isLocal(), this.isAnonymousClass(javaClass), superHub, componentHub, sourceFileName, modifiers, hubClassLoader);
    }

    private boolean isAnonymousClass(Class<?> javaClass) {
        try {
            return javaClass.isAnonymousClass();
        }
        catch (InternalError e) {
            this.warn("unknown anonymous info of class " + javaClass.getName() + ", assuming class is not anonymous. To remove the warning report an issue to the library or language author. The issue is caused by " + javaClass.getName() + " which is not following the naming convention.");
            return false;
        }
    }

    public static boolean isUnknownClass(ResolvedJavaType resolvedJavaType) {
        return resolvedJavaType.getAnnotation(UnknownClass.class) != null;
    }

    public static boolean isUnknownObjectField(ResolvedJavaField resolvedJavaField) {
        return resolvedJavaField.getAnnotation(UnknownObjectField.class) != null;
    }

    public static boolean isUnknownPrimitiveField(AnalysisField field) {
        return field.getAnnotation(UnknownPrimitiveField.class) != null;
    }

    public void registerClassReachabilityListener(BiConsumer<Feature.DuringAnalysisAccess, Class<?>> listener) {
        this.classReachabilityListeners.add(listener);
    }

    void notifyClassReachabilityListener(AnalysisUniverse universe, Feature.DuringAnalysisAccess access) {
        for (AnalysisType type : universe.getTypes()) {
            if (!type.isInTypeCheck() && !type.isInstantiated() || type.getReachabilityListenerNotified()) continue;
            type.setReachabilityListenerNotified(true);
            for (BiConsumer<Feature.DuringAnalysisAccess, Class<?>> listener : this.classReachabilityListeners) {
                listener.accept(access, type.getJavaClass());
            }
        }
    }

    public ClassInitializationSupport getClassInitializationSupport() {
        return this.classInitializationSupport;
    }

    public UnsafeAutomaticSubstitutionProcessor getAutomaticSubstitutionProcessor() {
        return this.automaticSubstitutions;
    }

    public void checkMethod(BigBang bb, AnalysisMethod method, StructuredGraph graph) {
        ValueNode receiver;
        if (method.isEntryPoint() && !Modifier.isStatic(graph.method().getModifiers()) && (receiver = graph.start().stateAfter().localAt(0)) != null && receiver.hasUsages()) {
            bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, "Entry point is non-static and uses its receiver: " + method.format("%r %H.%n(%p)"));
        }
        if (!NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            for (Node n : graph.getNodes()) {
                StaticDeoptimizingNode node;
                if (!(n instanceof StaticDeoptimizingNode) || (node = (StaticDeoptimizingNode)n).getReason() != DeoptimizationReason.JavaSubroutineMismatch) continue;
                bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, "The bytecodes of the method " + method.format("%H.%n(%p)") + " contain a JSR/RET structure that could not be simplified by the compiler. The JSR bytecode is unused and deprecated since Java 6. Please recompile your application with a newer Java compiler." + System.lineSeparator() + "To diagnose the issue, you can add the option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportUnsupportedElementsAtRuntime, "+") + ". The error is then reported at run time when the JSR/RET is executed.");
            }
        }
    }
}

