/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.JavaUtilZipSubstitutions;
import com.oracle.svm.core.posix.Util_java_util_zip_Deflater;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.ZLib;
import java.util.zip.Deflater;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
@TargetClass(value=Deflater.class)
final class Target_java_util_zip_Deflater {
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private byte[] buf;
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    int off;
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    int len;
    @Alias
    private int level;
    @Alias
    private int strategy;
    @Alias
    private boolean setParams;
    @Alias
    private boolean finish;
    @Alias
    private boolean finished;

    Target_java_util_zip_Deflater() {
    }

    @Substitute
    private static long init(int level, int strategy, boolean nowrap) {
        ZLib.z_stream strm = (ZLib.z_stream)LibC.calloc(WordFactory.unsigned((int)1), SizeOf.unsigned(ZLib.z_stream.class));
        if (strm.isNull()) {
            throw new OutOfMemoryError();
        }
        int ret = ZLib.deflateInit2(strm, level, ZLib.Z_DEFLATED(), nowrap ? -ZLib.MAX_WBITS() : ZLib.MAX_WBITS(), JavaUtilZipSubstitutions.Util_java_util_zip_Deflater.DEF_MEM_LEVEL, strategy);
        if (ret == ZLib.Z_OK()) {
            return strm.rawValue();
        }
        LibC.free(strm);
        if (ret == ZLib.Z_MEM_ERROR()) {
            throw new OutOfMemoryError();
        }
        if (ret == ZLib.Z_STREAM_ERROR()) {
            throw new IllegalArgumentException(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
        }
        throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
    }

    @Substitute
    private static void setDictionary(long addr, byte[] b, int off, int len) {
        try (PinnedObject pinned = PinnedObject.create((Object)b);){
            JavaUtilZipSubstitutions.Util_java_util_zip_Deflater.doSetDictionary(addr, (CCharPointer)pinned.addressOfArrayElement(off), len);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private int deflateBytes(long addr, byte[] b, int off, int len, int flush) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        try (PinnedObject pinnedInBuf = PinnedObject.create((Object)this.buf);
             PinnedObject pinnedOutBuf = PinnedObject.create((Object)b);){
            int res;
            strm.set_next_in((CCharPointer)pinnedInBuf.addressOfArrayElement(this.off));
            strm.set_next_out((CCharPointer)pinnedOutBuf.addressOfArrayElement(off));
            strm.set_avail_in(this.len);
            strm.set_avail_out(len);
            if (this.setParams) {
                res = ZLib.deflateParams(strm, this.level, this.strategy);
                this.setParams = false;
                if (res == ZLib.Z_OK()) {
                    int n = Util_java_util_zip_Deflater.update(this, len, strm);
                    return n;
                }
                if (res != ZLib.Z_BUF_ERROR()) throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
                int n = 0;
                return n;
            }
            res = ZLib.deflate(strm, this.finish ? ZLib.Z_FINISH() : flush);
            if (res == ZLib.Z_STREAM_END()) {
                this.finished = true;
                int n = Util_java_util_zip_Deflater.update(this, len, strm);
                return n;
            }
            if (res == ZLib.Z_OK()) {
                int n = Util_java_util_zip_Deflater.update(this, len, strm);
                return n;
            }
            if (res != ZLib.Z_BUF_ERROR()) throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
            int n = 0;
            return n;
        }
    }

    @Substitute
    private static int getAdler(long addr) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        return (int)strm.adler().rawValue();
    }

    @Substitute
    private static void reset(long addr) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        if (ZLib.deflateReset(strm) != ZLib.Z_OK()) {
            throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
        }
    }

    @Substitute
    private static void end(long addr) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        if (ZLib.deflateEnd(strm) == ZLib.Z_STREAM_ERROR()) {
            throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
        }
        LibC.free(strm);
    }
}

