/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.VmPrimsJNI;
import com.oracle.svm.core.posix.VmPrimsJVM;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Netdb;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Socket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

@TargetClass(className="java.net.Inet4AddressImpl")
@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
final class Target_java_net_Inet4AddressImpl {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    InetAddress anyLocalAddress;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    InetAddress loopbackAddress;

    Target_java_net_Inet4AddressImpl() {
    }

    @Substitute
    public String getLocalHostName() {
        CCharPointer hostname = (CCharPointer)StackValue.get((int)(Netdb.NI_MAXHOST() + 1), CCharPointer.class);
        hostname.write(0, (byte)0);
        if (CTypeConversion.toBoolean((int)VmPrimsJVM.JVM_GetHostName(hostname, Netdb.NI_MAXHOST() + 1))) {
            try (CTypeConversion.CCharPointerHolder pin = CTypeConversion.toCString((CharSequence)"localhost");){
                LibC.strcpy(hostname, pin.get());
            }
        } else {
            Netdb.addrinfo hints = (Netdb.addrinfo)StackValue.get(Netdb.addrinfo.class);
            Netdb.addrinfoPointer res = (Netdb.addrinfoPointer)StackValue.get(Netdb.addrinfoPointer.class);
            hostname.write(Netdb.NI_MAXHOST(), (byte)0);
            LibC.memset(hints, (SignedWord)WordFactory.zero(), SizeOf.unsigned(Netdb.addrinfo.class));
            hints.set_ai_flags(Netdb.AI_CANONNAME());
            hints.set_ai_family(Socket.AF_INET());
            int error = Netdb.getaddrinfo(hostname, (CCharPointer)WordFactory.nullPointer(), hints, res);
            if (error == 0) {
                Netdb.getnameinfo(res.read().ai_addr(), res.read().ai_addrlen(), hostname, Netdb.NI_MAXHOST(), (CCharPointer)WordFactory.nullPointer(), 0, Netdb.NI_NAMEREQD());
                Netdb.freeaddrinfo(res.read());
            }
        }
        return CTypeConversion.toJavaString((CCharPointer)hostname);
    }

    /*
     * Exception decompiling
     */
    @Substitute
    InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Substitute
    public String getHostByAddr(byte[] addrArray) throws UnknownHostException {
        String ret = null;
        CCharPointer host = (CCharPointer)StackValue.get((int)(Netdb.NI_MAXHOST() + 1), CCharPointer.class);
        int error = 0;
        int len = 0;
        CCharPointer caddr = (CCharPointer)StackValue.get((int)4, CCharPointer.class);
        NetinetIn.sockaddr_in him4 = (NetinetIn.sockaddr_in)StackValue.get(NetinetIn.sockaddr_in.class);
        VmPrimsJNI.GetByteArrayRegion(addrArray, 0, 4, caddr);
        int addr = caddr.read(0) << 24 & 0xFF000000;
        addr |= caddr.read(1) << 16 & 0xFF0000;
        addr |= caddr.read(2) << 8 & 0xFF00;
        LibC.memset(him4, (SignedWord)WordFactory.zero(), SizeOf.unsigned(NetinetIn.sockaddr_in.class));
        him4.sin_addr().set_s_addr(NetinetIn.htonl(addr |= caddr.read(3) & 0xFF));
        him4.set_sin_family(Socket.AF_INET());
        Socket.sockaddr sa = (Socket.sockaddr)((Object)him4);
        len = SizeOf.get(NetinetIn.sockaddr_in.class);
        error = Netdb.getnameinfo(sa, len, host, Netdb.NI_MAXHOST(), (CCharPointer)WordFactory.nullPointer(), 0, Netdb.NI_NAMEREQD());
        if (!CTypeConversion.toBoolean((int)error)) {
            ret = CTypeConversion.toJavaString((CCharPointer)host);
        }
        if (ret == null) {
            throw new UnknownHostException();
        }
        return ret;
    }
}

