/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_java_io_ExpiringCache;
import com.oracle.svm.core.posix.headers.Dirent;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Limits;
import com.oracle.svm.core.posix.headers.Stat;
import com.oracle.svm.core.posix.headers.Statvfs;
import com.oracle.svm.core.posix.headers.Stdio;
import com.oracle.svm.core.posix.headers.Stdlib;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

@TargetClass(className="java.io.UnixFileSystem")
@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
final class Target_java_io_UnixFileSystem {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClassName="java.io.ExpiringCache")
    private Target_java_io_ExpiringCache cache;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClassName="java.io.ExpiringCache")
    private Target_java_io_ExpiringCache javaHomePrefixCache;

    Target_java_io_UnixFileSystem() {
    }

    @Substitute
    public int getBooleanAttributes0(File f) {
        Stat.stat stat2 = (Stat.stat)StackValue.get(Stat.stat.class);
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)f.getPath());){
            CCharPointer pathPtr = pathPin.get();
            if (Stat.stat(pathPtr, stat2) == 0) {
                int fmt = stat2.st_mode() & Stat.S_IFMT();
                int n = Target_java_io_FileSystem.BA_EXISTS | (fmt == Stat.S_IFREG() ? Target_java_io_FileSystem.BA_REGULAR : 0) | (fmt == Stat.S_IFDIR() ? Target_java_io_FileSystem.BA_DIRECTORY : 0);
                return n;
            }
            int n = 0;
            return n;
        }
    }

    @Substitute
    private boolean delete0(File f) {
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)f.getPath());){
            CCharPointer pathPtr = pathPin.get();
            boolean bl = Stdio.remove(pathPtr) == 0;
            return bl;
        }
    }

    @Substitute
    private boolean rename0(File f1, File f2) {
        try (CTypeConversion.CCharPointerHolder pathPin1 = CTypeConversion.toCString((CharSequence)f1.getPath());){
            boolean bl;
            block12: {
                CCharPointer pathPtr1 = pathPin1.get();
                CTypeConversion.CCharPointerHolder pathPin2 = CTypeConversion.toCString((CharSequence)f2.getPath());
                try {
                    CCharPointer pathPtr2 = pathPin2.get();
                    boolean bl2 = bl = Stdio.rename(pathPtr1, pathPtr2) == 0;
                    if (pathPin2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (pathPin2 != null) {
                        try {
                            pathPin2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pathPin2.close();
            }
            return bl;
        }
    }

    @Substitute
    private long getLength(File f) {
        Stat.stat stat2 = (Stat.stat)StackValue.get(Stat.stat.class);
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)f.getPath());){
            CCharPointer pathPtr = pathPin.get();
            if (Stat.stat(pathPtr, stat2) == 0) {
                long l = stat2.st_size();
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    public String[] list(File f) {
        Dirent.DIR dir;
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)f.getPath());){
            CCharPointer pathPtr = pathPin.get();
            dir = Dirent.opendir(pathPtr);
        }
        if (dir.isNull()) {
            return null;
        }
        try {
            ArrayList<String> entries = new ArrayList<String>();
            Dirent.dirent dirent2 = (Dirent.dirent)StackValue.get((int)(SizeOf.get(Dirent.dirent.class) + Limits.PATH_MAX() + 1));
            Dirent.direntPointer resultDirent = (Dirent.direntPointer)StackValue.get(Dirent.direntPointer.class);
            while (Dirent.readdir_r(dir, dirent2, resultDirent) == 0 && !resultDirent.read().isNull()) {
                String name = CTypeConversion.toJavaString((CCharPointer)dirent2.d_name());
                if (name.equals(".") || name.equals("..")) continue;
                entries.add(name);
            }
            String[] stringArray = entries.toArray(new String[entries.size()]);
            return stringArray;
        }
        finally {
            Dirent.closedir(dir);
        }
    }

    @Substitute
    private String canonicalize0(String path) throws IOException {
        int maxPathLen = Limits.MAXPATHLEN();
        if (path.length() > maxPathLen) {
            throw new IOException("Bad pathname");
        }
        CCharPointer resolved = (CCharPointer)StackValue.get((int)maxPathLen);
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)path);){
            CCharPointer pathPtr = pathPin.get();
            if (Stdlib.realpath(pathPtr, resolved).notEqual((ComparableWord)WordFactory.zero())) {
                String string = PosixUtils.collapse(CTypeConversion.toJavaString((CCharPointer)resolved));
                return string;
            }
        }
        String resolvedPart = path;
        String unresolvedPart = "";
        CCharPointer r = (CCharPointer)WordFactory.nullPointer();
        int lastSep = resolvedPart.lastIndexOf(47);
        while (lastSep != -1) {
            unresolvedPart = resolvedPart.substring(lastSep) + unresolvedPart;
            resolvedPart = lastSep == 0 ? "" : resolvedPart.substring(0, lastSep);
            if ((lastSep = resolvedPart.lastIndexOf(47)) == -1) break;
            try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)resolvedPart);){
                CCharPointer resolvedPartPtr = pathPin.get();
                r = Stdlib.realpath(resolvedPartPtr, resolved);
            }
            int errno = Errno.errno();
            if (r.notEqual((ComparableWord)WordFactory.zero())) break;
            if (errno == Errno.ENOENT() || errno == Errno.ENOTDIR() || errno == Errno.EACCES()) continue;
            throw PosixUtils.newIOExceptionWithLastError("Bad pathname");
        }
        if (r.notEqual((ComparableWord)WordFactory.zero())) {
            String rs = CTypeConversion.toJavaString((CCharPointer)r);
            if (rs.length() + 1 + unresolvedPart.length() > maxPathLen) {
                throw PosixUtils.newIOExceptionWithLastError("Bad pathname");
            }
            return PosixUtils.collapse(rs + "/" + unresolvedPart);
        }
        return PosixUtils.collapse(path);
    }

    @Substitute
    public boolean createDirectory(File f) {
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)f.getPath());){
            CCharPointer pathPtr = pathPin.get();
            boolean bl = Stat.mkdir(pathPtr, 511) == 0;
            return bl;
        }
    }

    @Substitute
    public boolean checkAccess(File f, int access) {
        int mode;
        int n = access == Target_java_io_FileSystem.ACCESS_READ ? Unistd.R_OK() : (access == Target_java_io_FileSystem.ACCESS_WRITE ? Unistd.W_OK() : (mode = access == Target_java_io_FileSystem.ACCESS_EXECUTE ? Unistd.X_OK() : -1));
        if (mode == -1) {
            throw VMError.shouldNotReachHere("illegal access mode");
        }
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)f.getPath());){
            CCharPointer path = pathPin.get();
            boolean bl = Unistd.access(path, mode) == 0;
            return bl;
        }
    }

    @Substitute
    public long getSpace(File f, int t) {
        Statvfs.statvfs statvfs2 = (Statvfs.statvfs)StackValue.get(Statvfs.statvfs.class);
        LibC.memset(statvfs2, (SignedWord)WordFactory.zero(), WordFactory.unsigned((int)SizeOf.get(Statvfs.statvfs.class)));
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)f.getPath());){
            CCharPointer pathPtr = pathPin.get();
            if (Statvfs.statvfs(pathPtr, statvfs2) == 0) {
                long frsize = statvfs2.f_frsize();
                if (t == Target_java_io_FileSystem.SPACE_TOTAL) {
                    long l = frsize * statvfs2.f_blocks();
                    return l;
                }
                if (t == Target_java_io_FileSystem.SPACE_FREE) {
                    long l = frsize * statvfs2.f_bfree();
                    return l;
                }
                if (t == Target_java_io_FileSystem.SPACE_USABLE) {
                    long l = frsize * statvfs2.f_bavail();
                    return l;
                }
                throw VMError.shouldNotReachHere("illegal space mode");
            }
        }
        return 0L;
    }

    @Substitute
    public boolean setReadOnly(File f) {
        Stat.stat stat2 = (Stat.stat)StackValue.get(Stat.stat.class);
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)f.getPath());){
            CCharPointer pathPtr = pathPin.get();
            if (Stat.stat(pathPtr, stat2) == 0 && Stat.chmod(pathPtr, stat2.st_mode() & ~(Stat.S_IWUSR() | Stat.S_IWGRP() | Stat.S_IWOTH())) >= 0) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Substitute
    public boolean setPermission(File f, int access, boolean enable, boolean owneronly) {
        int amode = 0;
        if (access == Target_java_io_FileSystem.ACCESS_READ) {
            amode = owneronly ? Stat.S_IRUSR() : Stat.S_IRUSR() | Stat.S_IRGRP() | Stat.S_IROTH();
        } else if (access == Target_java_io_FileSystem.ACCESS_WRITE) {
            amode = owneronly ? Stat.S_IWUSR() : Stat.S_IWUSR() | Stat.S_IWGRP() | Stat.S_IWOTH();
        } else if (access == Target_java_io_FileSystem.ACCESS_EXECUTE) {
            amode = owneronly ? Stat.S_IXUSR() : Stat.S_IXUSR() | Stat.S_IXGRP() | Stat.S_IXOTH();
        } else {
            throw VMError.shouldNotReachHere("illegal access mode");
        }
        Stat.stat stat2 = (Stat.stat)StackValue.get(Stat.stat.class);
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)f.getPath());){
            int newMode;
            CCharPointer pathPtr = pathPin.get();
            if (Stat.stat(pathPtr, stat2) == 0 && Stat.chmod(pathPtr, newMode = enable ? stat2.st_mode() | amode : stat2.st_mode() & ~amode) >= 0) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Substitute
    public boolean createFileExclusively(String path) throws IOException {
        int fd;
        if (path.equals("/")) {
            return false;
        }
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)PosixUtils.removeTrailingSlashes(path));){
            CCharPointer pathPtr = pathPin.get();
            fd = Fcntl.open(pathPtr, Fcntl.O_RDWR() | Fcntl.O_CREAT(), 438);
        }
        if (fd < 0) {
            if (fd != Errno.EEXIST()) {
                throw PosixUtils.newIOExceptionWithLastError(path);
            }
        } else {
            Unistd.close(fd);
            return true;
        }
        return false;
    }

    @Substitute
    public long getLastModifiedTime(File f) {
        Stat.stat stat2 = (Stat.stat)StackValue.get(Stat.stat.class);
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)f.getPath());){
            CCharPointer pathPtr = pathPin.get();
            if (Stat.stat(pathPtr, stat2) == 0) {
                long l = 1000L * stat2.st_mtime();
                return l;
            }
        }
        return 0L;
    }

    @Substitute
    public boolean setLastModifiedTime(File f, long time) {
        Stat.stat stat2 = (Stat.stat)StackValue.get(Stat.stat.class);
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)f.getPath());){
            CCharPointer pathPtr = pathPin.get();
            if (Stat.stat(pathPtr, stat2) == 0) {
                Time.timeval timeval2 = (Time.timeval)StackValue.get((int)2, Time.timeval.class);
                Time.timeval access = timeval2.addressOf(0);
                access.set_tv_sec(stat2.st_atime());
                access.set_tv_usec(0L);
                Time.timeval last = timeval2.addressOf(1);
                last.set_tv_sec(time / 1000L);
                last.set_tv_usec(time % 1000L * 1000L);
                if (Time.utimes(pathPtr, timeval2) == 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    @TargetClass(className="java.io.FileSystem")
    static final class Target_java_io_FileSystem {
        @Alias
        static int BA_EXISTS;
        @Alias
        static int BA_REGULAR;
        @Alias
        static int BA_DIRECTORY;
        @Alias
        static int ACCESS_EXECUTE;
        @Alias
        static int ACCESS_READ;
        @Alias
        static int ACCESS_WRITE;
        @Alias
        static int SPACE_FREE;
        @Alias
        static int SPACE_TOTAL;
        @Alias
        static int SPACE_USABLE;

        Target_java_io_FileSystem() {
        }
    }
}

