/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.LibCHelper;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Dirent;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.UnistdNoTransitions;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ThreadFactory;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
public final class Java_lang_Process_Supplement {
    static final ThreadFactory reaperFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable reaper) {
            long stackSize = Boolean.getBoolean("jdk.lang.processReaperUseDefaultStackSize") ? 0L : 32768L;
            Thread t = new Thread(null, reaper, "Process Reaper", stackSize);
            t.setDaemon(true);
            t.setPriority(10);
            return t;
        }
    };

    /*
     * Exception decompiling
     */
    static int doForkAndExec(CCharPointer file, CCharPointer dir, CCharPointerPointer argv, CCharPointerPointer envp, int[] stdioFds, int failFd, boolean redirectErrorStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="fragile state after fork()")
    private static int uninterruptibleForkAndExec(CCharPointer file, CCharPointer dir, CCharPointerPointer argv, CCharPointerPointer envp, int[] stdioFds, int initialFailFd, PointerBase buffer, int buflen, CCharPointer procFdsPath, CCharPointer searchPaths, CCharPointer searchPathSeparator, boolean redirectErrorStream) {
        int childPid = UnistdNoTransitions.fork();
        if (childPid != 0) {
            return childPid;
        }
        int failFd = initialFailFd;
        try {
            int fddirfd;
            int gotoFinally = -1;
            if (Java_lang_Process_Supplement.dup2(stdioFds[0], 0) < 0) {
                int n = -1;
                return n;
            }
            if (Java_lang_Process_Supplement.dup2(stdioFds[1], 1) < 0) {
                int n = -1;
                return n;
            }
            if (redirectErrorStream) {
                if (UnistdNoTransitions.close(stdioFds[2]) < 0 || Java_lang_Process_Supplement.dup2(1, 2) < 0) {
                    int n = -1;
                    return n;
                }
            } else if (Java_lang_Process_Supplement.dup2(stdioFds[2], 2) < 0) {
                int n = -1;
                return n;
            }
            if (Java_lang_Process_Supplement.dup2(failFd, 3) < 0) {
                int n = -1;
                return n;
            }
            failFd = 3;
            if (Fcntl.fcntl_no_transition(failFd, Fcntl.F_SETFD(), Fcntl.FD_CLOEXEC()) < 0) {
                int n = -1;
                return n;
            }
            if (procFdsPath.isNull()) {
                int maxOpenFds = (int)UnistdNoTransitions.sysconf(Unistd._SC_OPEN_MAX());
                for (int fd = failFd + 1; fd < maxOpenFds; ++fd) {
                    UnistdNoTransitions.close(fd);
                }
            } else {
                int status;
                fddirfd = Fcntl.NoTransitions.open(procFdsPath, Fcntl.O_RDONLY(), 0);
                if (fddirfd < 0) {
                    int fd = -1;
                    return fd;
                }
                Dirent.DIR fddir = Dirent.fdopendir_no_transition(fddirfd);
                if (fddir.isNull()) {
                    int intSize = -1;
                    return intSize;
                }
                Dirent.dirent dirent2 = (Dirent.dirent)WordFactory.pointer((long)buffer.rawValue());
                Dirent.direntPointer direntptr = (Dirent.direntPointer)StackValue.get(Dirent.direntPointer.class);
                while ((status = Dirent.readdir_r_no_transition(fddir, dirent2, direntptr)) == 0 && direntptr.read().isNonNull()) {
                    CCharPointerPointer endptr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                    long fd = LibC.strtol(dirent2.d_name(), endptr, 10);
                    if (fd <= (long)failFd || fd == (long)fddirfd || !endptr.read().isNonNull() || endptr.read().read() != 0) continue;
                    UnistdNoTransitions.close((int)fd);
                }
                if (status != 0) {
                    Errno.set_errno(status);
                    int endptr = -1;
                    return endptr;
                }
                Dirent.closedir_no_transition(fddir);
            }
            if (dir.isNonNull() && UnistdNoTransitions.chdir(dir) < 0) {
                fddirfd = -1;
                return fddirfd;
            }
            CCharPointerPointer actualEnvp = envp;
            if (actualEnvp.isNull()) {
                actualEnvp = LibCHelper.getEnviron();
            }
            if (SubstrateUtil.strchr(file, 47).isNonNull()) {
                UnistdNoTransitions.execve(argv.read(0), argv, actualEnvp);
            } else {
                int fileStrlen = (int)SubstrateUtil.strlen(file).rawValue();
                int stickyErrno = 0;
                CCharPointerPointer saveptr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                saveptr.write((CCharPointer)WordFactory.nullPointer());
                CCharPointer searchDir = LibC.strtok_r(searchPaths, searchPathSeparator, saveptr);
                while (searchDir.isNonNull()) {
                    CCharPointer bufptr = (CCharPointer)WordFactory.pointer((long)buffer.rawValue());
                    int len0 = (int)SubstrateUtil.strlen(searchDir).rawValue();
                    if (len0 + fileStrlen + 2 > buflen) {
                        Errno.set_errno(Errno.ENAMETOOLONG());
                        continue;
                    }
                    if (len0 > 0) {
                        LibC.strcpy(bufptr, searchDir);
                        if (bufptr.read(len0 - 1) != 47) {
                            bufptr.write(len0, (byte)47);
                            ++len0;
                        }
                    }
                    LibC.strcpy(bufptr.addressOf(len0), file);
                    UnistdNoTransitions.execve(bufptr, argv, actualEnvp);
                    int e = Errno.errno();
                    if (e == Errno.EACCES()) {
                        stickyErrno = e;
                    } else if (e != Errno.ENOENT() && e != Errno.ENOTDIR() && e != Errno.ELOOP() && e != Errno.ESTALE() && e != Errno.ENODEV() && e != Errno.ETIMEDOUT()) {
                        stickyErrno = e;
                        break;
                    }
                    searchDir = LibC.strtok_r((CCharPointer)WordFactory.nullPointer(), searchPathSeparator, saveptr);
                }
                if (stickyErrno != 0) {
                    Errno.set_errno(stickyErrno);
                }
            }
        }
        catch (Throwable t) {
            Errno.set_errno(Integer.MIN_VALUE);
        }
        finally {
            try {
                int intSize = SizeOf.get(CIntPointer.class);
                CIntPointer pErrno = (CIntPointer)StackValue.get((int)intSize);
                pErrno.write(Errno.errno());
                Java_lang_Process_Supplement.writeEntirely(failFd, (PointerBase)pErrno, WordFactory.unsigned((int)intSize));
                UnistdNoTransitions.close(failFd);
            }
            finally {
                UnistdNoTransitions._exit(-1);
            }
        }
        throw VMError.shouldNotReachHere();
    }

    static void gatherCStringPointers(CCharPointer cstrblock, int nbytes, CCharPointerPointer ptrblock, int nptrs) {
        int i;
        assert (nptrs > 0);
        int k = 0;
        for (i = 0; i < nbytes && k < nptrs - 1; ++i) {
            ptrblock.write(k, cstrblock.addressOf(i));
            ++k;
            while (i < nbytes && cstrblock.read(i) != 0) {
                ++i;
            }
        }
        assert (i == nbytes && k == nptrs - 1);
        ptrblock.write(k, (CCharPointer)WordFactory.nullPointer());
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    static int dup2(int fd, int fd2) {
        int result;
        do {
            Errno.set_errno(0);
        } while ((result = UnistdNoTransitions.dup2(fd, fd2)) != fd2 && Errno.errno() == Errno.EINTR());
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    static SignedWord writeEntirely(int fd, PointerBase buf, UnsignedWord count) {
        SignedWord written;
        Pointer ptr = (Pointer)WordFactory.pointer((long)buf.rawValue());
        Pointer end = ptr.add(count);
        do {
            Errno.set_errno(0);
            written = UnistdNoTransitions.write(fd, (PointerBase)ptr, (UnsignedWord)end.subtract((UnsignedWord)ptr));
            if (!written.greaterThan(0)) continue;
            ptr = ptr.add((int)written.rawValue());
        } while (ptr.notEqual((UnsignedWord)end) && (written.notEqual(-1) || Errno.errno() == Errno.EINTR()));
        if (ptr.notEqual((ComparableWord)buf)) {
            return WordFactory.signed((long)(ptr.rawValue() - buf.rawValue()));
        }
        return written;
    }

    static SignedWord readEntirely(int fd, PointerBase buf, UnsignedWord count) {
        SignedWord read;
        Pointer ptr = (Pointer)WordFactory.pointer((long)buf.rawValue());
        Pointer end = ptr.add(count);
        do {
            Errno.set_errno(0);
            read = Unistd.read(fd, (PointerBase)ptr, (UnsignedWord)end.subtract((UnsignedWord)ptr));
            if (read.equal(0)) break;
            if (!read.greaterThan(0)) continue;
            ptr = ptr.add((int)read.rawValue());
        } while (ptr.notEqual((UnsignedWord)end) && (read.notEqual(-1) || Errno.errno() == Errno.EINTR()));
        if (ptr.notEqual((ComparableWord)buf)) {
            return WordFactory.signed((long)(ptr.rawValue() - buf.rawValue()));
        }
        return read;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int forkAndExec(int mode, byte[] helperpath, byte[] file, byte[] argBlock, int argCount, byte[] envBlock, int envCount, byte[] dir, int[] fds, boolean redirectErrorStream) throws IOException {
        int[] pipes = new int[8];
        Arrays.fill(pipes, -1);
        try (PinnedObject filePin = PinnedObject.create((Object)file);
             PinnedObject dirPin = PinnedObject.create((Object)dir);
             PinnedObject argBlockPin = PinnedObject.create((Object)argBlock);
             PinnedObject argvPin = PinnedObject.create((Object)new CCharPointerPointer[argCount + 2]);
             PinnedObject envBlockPin = PinnedObject.create((Object)envBlock);
             PinnedObject envpPin = PinnedObject.create((Object)new CCharPointerPointer[envCount + 1]);
             PinnedObject pipesPin = PinnedObject.create((Object)pipes);){
            CCharPointer dirp;
            CCharPointerPointer argv = (CCharPointerPointer)argvPin.addressOfArrayElement(0);
            argv.write(0, (CCharPointer)filePin.addressOfArrayElement(0));
            Java_lang_Process_Supplement.gatherCStringPointers((CCharPointer)argBlockPin.addressOfArrayElement(0), argBlock.length, argv.addressOf(1), argCount + 1);
            CCharPointerPointer envp = (CCharPointerPointer)WordFactory.nullPointer();
            if (envBlock != null) {
                envp = (CCharPointerPointer)envpPin.addressOfArrayElement(0);
                Java_lang_Process_Supplement.gatherCStringPointers((CCharPointer)envBlockPin.addressOfArrayElement(0), envBlock.length, envp.addressOf(0), envCount + 1);
            }
            CIntPointer[] stdioPipes = new CIntPointer[3];
            for (int i = 0; i <= 2; ++i) {
                if (fds[i] != -1) continue;
                stdioPipes[i] = (CIntPointer)pipesPin.addressOfArrayElement(2 * i);
                if (Unistd.pipe(stdioPipes[i]) >= 0) continue;
                throw new IOException("pipe() failed");
            }
            CIntPointer failPipe = (CIntPointer)pipesPin.addressOfArrayElement(2 * stdioPipes.length);
            if (Unistd.pipe(failPipe) < 0) {
                throw new IOException("pipe() failed");
            }
            int[] childStdioFds = new int[]{fds[0] != -1 ? fds[0] : stdioPipes[0].read(0), fds[1] != -1 ? fds[1] : stdioPipes[1].read(1), fds[2] != -1 ? fds[2] : stdioPipes[2].read(1)};
            int childFailFd = failPipe.read(1);
            CCharPointer filep = (CCharPointer)filePin.addressOfArrayElement(0);
            int childPid = Java_lang_Process_Supplement.doForkAndExec(filep, dirp = dir != null ? (CCharPointer)dirPin.addressOfArrayElement(0) : (CCharPointer)WordFactory.nullPointer(), argv, envp, childStdioFds, childFailFd, redirectErrorStream);
            if (childPid < 0) {
                throw new IOException("fork() failed");
            }
            fds[2] = -1;
            fds[1] = -1;
            fds[0] = -1;
            if (stdioPipes[0].isNonNull()) {
                fds[0] = stdioPipes[0].read(1);
                Unistd.close(stdioPipes[0].read(0));
            }
            if (stdioPipes[1].isNonNull()) {
                fds[1] = stdioPipes[1].read(0);
                Unistd.close(stdioPipes[1].read(1));
            }
            if (stdioPipes[2].isNonNull()) {
                fds[2] = stdioPipes[2].read(0);
                Unistd.close(stdioPipes[2].read(1));
            }
            Unistd.close(failPipe.read(1));
            int intSize = SizeOf.get(CIntPointer.class);
            CIntPointer pErrno = (CIntPointer)StackValue.get((int)intSize);
            SignedWord failBytes = Java_lang_Process_Supplement.readEntirely(failPipe.read(0), (PointerBase)pErrno, WordFactory.unsigned((int)intSize));
            Unistd.close(failPipe.read(0));
            if (failBytes.equal(0)) {
                int n = childPid;
                return n;
            }
            if (!failBytes.equal(SizeOf.get(CIntPointer.class))) throw new IOException("unexpected data from child");
            int errbuflen = 256;
            PinnedObject errbuf = PinnedObject.create((Object)new byte[errbuflen]);
            try {
                CCharPointer detailCstr = Errno.strerror_r(pErrno.read(), (CCharPointer)errbuf.addressOfArrayElement(0), WordFactory.unsigned((int)errbuflen));
                String detail = CTypeConversion.toJavaString((CCharPointer)detailCstr);
                throw new IOException("error=" + pErrno.read() + ", " + detail);
            }
            catch (Throwable throwable) {
                if (errbuf == null) throw throwable;
                try {
                    errbuf.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            int[] nArray = pipes;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int fd = nArray[n2];
                if (fd != -1) {
                    Unistd.close(fd);
                }
                ++n2;
            }
            throw e;
        }
    }

    public static int waitForProcessExit0(long pid, boolean reapvalue) {
        if (reapvalue) {
            return PosixUtils.waitForProcessExit(Math.toIntExact(pid));
        }
        throw VMError.unimplemented();
    }
}

