/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.log.Log;

final class ProviderUtil {
    private static volatile boolean initialized = false;

    ProviderUtil() {
    }

    static void initSunEC() {
        if (initialized) {
            return;
        }
        ProviderUtil.initOnce();
    }

    private static synchronized void initOnce() {
        if (!initialized) {
            try {
                System.loadLibrary("sunec");
            }
            catch (UnsatisfiedLinkError e) {
                Log.log().string("WARNING: The sunec native library, required by the SunEC provider, could not be loaded. This library is usually shipped as part of the JDK and can be found under <JAVA_HOME>/jre/lib/<platform>/libsunec.so. It is loaded at run time via System.loadLibrary(\"sunec\"), the first time services from SunEC are accessed. To use this provider's services the java.library.path system property needs to be set accordingly to point to a location that contains libsunec.so. Note that if java.library.path is not set it defaults to the current working directory.").newline();
            }
            initialized = true;
        }
    }
}

