/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.Generation;
import com.oracle.svm.core.genscavenge.GreyObjectsWalker;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.HeapVerifierImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.SpaceVerifierImpl;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class OldGeneration
extends Generation {
    private final Space fromSpace = new Space("fromSpace", false);
    private final Space toSpace = new Space("toSpace", false);
    private final GreyObjectsWalker toGreyObjectsWalker = GreyObjectsWalker.factory();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    OldGeneration(String name) {
        super(name);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void tearDown() {
        this.fromSpace.tearDown();
        this.toSpace.tearDown();
    }

    @Override
    public boolean walkObjects(ObjectVisitor visitor) {
        if (!this.getFromSpace().walkObjects(visitor)) {
            return false;
        }
        return this.getToSpace().walkObjects(visitor);
    }

    @Override
    public Object promoteObject(Object original) {
        Object result;
        Log trace = Log.noopLog().string("[OldGeneration.promoteObject:").string("  original: ").object(original).newline();
        if (ObjectHeaderImpl.getObjectHeaderImpl().isAlignedObject(original)) {
            trace.string("  aligned header: ").hex((WordBase)ObjectHeaderImpl.readHeaderFromObject(original)).newline();
            result = this.promoteAlignedObject(original);
        } else {
            trace.string("  unaligned header: ").hex((WordBase)ObjectHeaderImpl.readHeaderFromObject(original)).newline();
            result = this.promoteUnalignedObjectChunk(original);
        }
        trace.string("  OldGeneration.promoteObject returns: ").object(result).string("]").newline();
        return result;
    }

    void releaseSpaces() {
        this.getFromSpace().release();
        this.getToSpace().cleanRememberedSet();
    }

    private boolean shouldPromoteFrom(Space originalSpace) {
        Log trace = Log.noopLog();
        trace.string("[OldGeneration.shouldPromoteFrom:").string("  originalSpace: ").string(originalSpace.getName());
        HeapImpl heap = HeapImpl.getHeapImpl();
        boolean result = heap.isYoungGeneration(originalSpace) ? true : originalSpace == this.getFromSpace();
        trace.string("  returns: ").bool(result);
        trace.string("]").newline();
        return result;
    }

    private Object promoteAlignedObject(Object original) {
        Log trace = Log.noopLog().string("[OldGeneration.promoteAlignedObject:").string("  original: ").object(original);
        assert (ObjectHeaderImpl.getObjectHeaderImpl().isAlignedObject(original));
        AlignedHeapChunk.AlignedHeader originalChunk = AlignedHeapChunk.getEnclosingAlignedHeapChunk(original);
        Space originalSpace = originalChunk.getSpace();
        trace.string("  originalSpace: ").string(originalSpace.getName());
        Object result = original;
        if (this.shouldPromoteFrom(originalSpace)) {
            trace.string("  promoting");
            if (HeapOptions.TraceObjectPromotion.getValue().booleanValue()) {
                Log promotionTrace = Log.log().string("[OldGeneration.promoteAlignedObject:").string("  original: ").object(original);
                UnsignedWord size = LayoutEncoding.getSizeFromObject(original);
                promotionTrace.string("  size: ").unsigned((WordBase)size).string("]").newline();
            }
            result = this.getToSpace().promoteAlignedObject(original);
        } else {
            trace.string("  not promoting");
        }
        trace.string("  returns: ").object(result);
        if (trace.isEnabled()) {
            AlignedHeapChunk.AlignedHeader resultChunk = AlignedHeapChunk.getEnclosingAlignedHeapChunk(result);
            Space resultSpace = resultChunk.getSpace();
            trace.string("  resultSpace: ").string(resultSpace.getName());
        }
        trace.string("]").newline();
        return result;
    }

    private Object promoteUnalignedObjectChunk(Object original) {
        Log trace = Log.noopLog().string("[OldGeneration.promoteUnalignedObjectChunk:").string("  original: ").object(original);
        assert (ObjectHeaderImpl.getObjectHeaderImpl().isUnalignedObject(original));
        UnalignedHeapChunk.UnalignedHeader uChunk = UnalignedHeapChunk.getEnclosingUnalignedHeapChunk(original);
        Space originalSpace = uChunk.getSpace();
        trace.string("  originalSpace: ").string(originalSpace.getName());
        if (this.shouldPromoteFrom(originalSpace)) {
            trace.string("  promoting");
            if (HeapOptions.TraceObjectPromotion.getValue().booleanValue()) {
                Log promotionTrace = Log.log().string("[OldGeneration.promoteUnalignedObjectChunk:").string("  original: ").object(original);
                UnsignedWord size = LayoutEncoding.getSizeFromObject(original);
                promotionTrace.string("  size: ").unsigned((WordBase)size).string("]").newline();
            }
            this.getToSpace().promoteUnalignedHeapChunk(uChunk);
        } else {
            trace.string("  not promoting");
        }
        trace.string("  returns: ").object(original);
        if (trace.isEnabled()) {
            UnalignedHeapChunk.UnalignedHeader resultChunk = UnalignedHeapChunk.getEnclosingUnalignedHeapChunk(original);
            Space resultSpace = resultChunk.getSpace();
            trace.string("  resultSpace: ").string(resultSpace.getName());
        }
        trace.string("]").newline();
        return original;
    }

    protected void walkDirtyObjects(ObjectVisitor visitor, boolean clean) {
        this.getToSpace().walkDirtyObjects(visitor, clean);
    }

    protected void prepareForPromotion() {
        this.getToGreyObjectsWalker().setScanStart(this.getToSpace());
    }

    protected void scanGreyObjects() {
        Log trace = Log.noopLog().string("[OldGeneration.scanGreyObjects:");
        GCImpl gc = HeapImpl.getHeapImpl().getGCImpl();
        this.getToGreyObjectsWalker().walkGreyObjects(gc.getGreyToBlackObjectVisitor());
        trace.string("]").newline();
    }

    @Override
    public Log report(Log log, boolean traceHeapChunks) {
        log.string("[Old generation: ").indent(true);
        this.getFromSpace().report(log, traceHeapChunks).newline();
        this.getToSpace().report(log, traceHeapChunks).newline();
        log.redent(false).string("]");
        return log;
    }

    @Override
    protected boolean isValidSpace(Space space) {
        return space == this.getFromSpace() || space == this.getToSpace();
    }

    @Override
    protected boolean verify(HeapVerifier.Occasion occasion) {
        boolean result = true;
        HeapImpl heap = HeapImpl.getHeapImpl();
        HeapVerifierImpl heapVerifier = heap.getHeapVerifierImpl();
        SpaceVerifierImpl spaceVerifier = heapVerifier.getSpaceVerifierImpl();
        spaceVerifier.initialize(heap.getOldGeneration().getFromSpace());
        if (!spaceVerifier.verify()) {
            result = false;
            heapVerifier.getWitnessLog().string("[OldGeneration.verify:").string("  old from space fails to verify").string("]").newline();
        }
        if (occasion.equals((Object)HeapVerifier.Occasion.AFTER_COLLECTION) && !spaceVerifier.verifyOnlyCleanCards()) {
            result = false;
            heapVerifier.getWitnessLog().string("[OldGeneration.verify:").string("  old from space contains dirty cards").string("]").newline();
        }
        spaceVerifier.initialize(heap.getOldGeneration().getToSpace());
        if (!spaceVerifier.verify()) {
            result = false;
            heapVerifier.getWitnessLog().string("[OldGeneration.verify:").string("  old to space fails to verify").string("]").newline();
        }
        if (!occasion.equals((Object)HeapVerifier.Occasion.DURING_COLLECTION) && spaceVerifier.containsChunks()) {
            result = false;
            heapVerifier.getWitnessLog().string("[OldGeneration.verify:").string("  old to space contains chunks").string("]").newline();
        }
        return result;
    }

    boolean slowlyFindPointer(Pointer p) {
        if (this.slowlyFindPointerInFromSpace(p)) {
            return true;
        }
        if (this.slowlyFindPointerInToSpace(p)) {
            try (Log paranoia = Log.noopLog();){
                if (paranoia.isEnabled()) {
                    paranoia.string("[OldGeneration.slowlyFindPointerInOldGeneration:");
                    paranoia.string("  p: ").hex((WordBase)p);
                    paranoia.string("  found in: ").string(this.getToSpace().getName());
                    paranoia.string("]").newline();
                }
            }
            return false;
        }
        return false;
    }

    boolean slowlyFindPointerInFromSpace(Pointer p) {
        return HeapVerifierImpl.slowlyFindPointerInSpace(this.getFromSpace(), p, HeapVerifierImpl.ChunkLimit.top);
    }

    boolean slowlyFindPointerInToSpace(Pointer p) {
        return HeapVerifierImpl.slowlyFindPointerInSpace(this.getToSpace(), p, HeapVerifierImpl.ChunkLimit.top);
    }

    int classifyPointer(Pointer p) {
        if (p.isNull()) {
            return 0;
        }
        if (this.slowlyFindPointerInFromSpace(p)) {
            return 1;
        }
        if (this.slowlyFindPointerInToSpace(p)) {
            return 2;
        }
        return -1;
    }

    public Space getFromSpace() {
        return this.fromSpace;
    }

    Space getToSpace() {
        return this.toSpace;
    }

    void swapSpaces() {
        assert (this.getFromSpace().isEmpty()) : "fromSpace should be empty.";
        this.getFromSpace().absorb(this.getToSpace());
    }

    void emptyFromSpaceIntoToSpace() {
        this.getToSpace().absorb(this.getFromSpace());
    }

    private GreyObjectsWalker getToGreyObjectsWalker() {
        return this.toGreyObjectsWalker;
    }

    boolean walkHeapChunks(MemoryWalker.Visitor visitor) {
        return this.getFromSpace().walkHeapChunks(visitor) && this.getToSpace().walkHeapChunks(visitor);
    }
}

