/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.jdk11;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.posix.JavaUtilZipSubstitutions;
import com.oracle.svm.core.posix.jdk11.Util_java_util_zip_Inflater;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
@TargetClass(value=Inflater.class, onlyWith={JDK11OrLater.class})
final class Target_java_util_zip_Inflater {
    @Alias
    @TargetElement(onlyWith={JDK11OrLater.class})
    int inputConsumed;
    @Alias
    @TargetElement(onlyWith={JDK11OrLater.class})
    int outputConsumed;

    Target_java_util_zip_Inflater() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static void initIDs() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static void setDictionaryBuffer(long addr, long bufAddress, int len) {
        JavaUtilZipSubstitutions.Util_java_util_zip_Deflater.doSetDictionary(addr, (CCharPointer)WordFactory.pointer((long)bufAddress), len);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private long inflateBytesBytes(long addr, byte[] inputArray, int inputOff, int inputLen, byte[] outputArray, int outputOff, int outputLen) throws DataFormatException {
        try (PinnedObject inputPinned = PinnedObject.create((Object)inputArray);){
            long l;
            block12: {
                CCharPointer inputBytes = (CCharPointer)inputPinned.addressOfArrayElement(inputOff);
                PinnedObject outputPinned = PinnedObject.create((Object)outputArray);
                try {
                    CCharPointer outputBytes = (CCharPointer)outputPinned.addressOfArrayElement(outputOff);
                    l = Util_java_util_zip_Inflater.doInflate(this, addr, inputBytes, inputLen, outputBytes, outputLen);
                    if (outputPinned == null) break block12;
                }
                catch (Throwable throwable) {
                    if (outputPinned != null) {
                        try {
                            outputPinned.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputPinned.close();
            }
            return l;
        }
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private long inflateBytesBuffer(long addr, byte[] inputArray, int inputOff, int inputLen, long outputAddress, int outputLen) throws DataFormatException {
        try (PinnedObject inputPinned = PinnedObject.create((Object)inputArray);){
            CCharPointer inputBytes = (CCharPointer)inputPinned.addressOfArrayElement(inputOff);
            CCharPointer outputBytes = (CCharPointer)WordFactory.pointer((long)outputAddress);
            long l = Util_java_util_zip_Inflater.doInflate(this, addr, inputBytes, inputLen, outputBytes, outputLen);
            return l;
        }
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private long inflateBufferBytes(long addr, long inputAddress, int inputLen, byte[] outputArray, int outputOff, int outputLen) throws DataFormatException {
        CCharPointer inputBytes = (CCharPointer)WordFactory.pointer((long)inputAddress);
        try (PinnedObject outputPinned = PinnedObject.create((Object)outputArray);){
            CCharPointer outputBytes = (CCharPointer)outputPinned.addressOfArrayElement(outputOff);
            long l = Util_java_util_zip_Inflater.doInflate(this, addr, inputBytes, inputLen, outputBytes, outputLen);
            return l;
        }
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private long inflateBufferBuffer(long addr, long inputAddress, int inputLen, long outputAddress, int outputLen) throws DataFormatException {
        CCharPointer inputBytes = (CCharPointer)WordFactory.pointer((long)inputAddress);
        CCharPointer outputBytes = (CCharPointer)WordFactory.pointer((long)outputAddress);
        return Util_java_util_zip_Inflater.doInflate(this, addr, inputBytes, inputLen, outputBytes, outputLen);
    }
}

