/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.jdk11;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.posix.JavaUtilZipSubstitutions;
import com.oracle.svm.core.posix.jdk11.Util_java_util_zip_Deflater;
import java.util.zip.Deflater;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
@TargetClass(value=Deflater.class, onlyWith={JDK11OrLater.class})
final class Target_java_util_zip_Deflater {
    Target_java_util_zip_Deflater() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static void setDictionaryBuffer(long addr, long bufAddress, int len) {
        JavaUtilZipSubstitutions.Util_java_util_zip_Deflater.doSetDictionary(addr, (CCharPointer)WordFactory.pointer((long)bufAddress), len);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private long deflateBytesBytes(long addr, byte[] inputArray, int inputOff, int inputLen, byte[] outputArray, int outputOff, int outputLen, int flush, int params) {
        try (PinnedObject inputPinned = PinnedObject.create((Object)inputArray);){
            long l;
            block12: {
                PinnedObject outputPinned = PinnedObject.create((Object)outputArray);
                try {
                    l = Util_java_util_zip_Deflater.doDeflate(addr, (CCharPointer)inputPinned.addressOfArrayElement(inputOff), inputLen, (CCharPointer)outputPinned.addressOfArrayElement(outputOff), outputLen, flush, params);
                    if (outputPinned == null) break block12;
                }
                catch (Throwable throwable) {
                    if (outputPinned != null) {
                        try {
                            outputPinned.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputPinned.close();
            }
            return l;
        }
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private long deflateBytesBuffer(long addr, byte[] inputArray, int inputOff, int inputLen, long outputBuffer, int outputLen, int flush, int params) {
        try (PinnedObject inputPinned = PinnedObject.create((Object)inputArray);){
            long l = Util_java_util_zip_Deflater.doDeflate(addr, (CCharPointer)inputPinned.addressOfArrayElement(inputOff), inputLen, (CCharPointer)WordFactory.pointer((long)outputBuffer), outputLen, flush, params);
            return l;
        }
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private long deflateBufferBytes(long addr, long inputBuffer, int inputLen, byte[] outputArray, int outputOff, int outputLen, int flush, int params) {
        try (PinnedObject outputPinned = PinnedObject.create((Object)outputArray);){
            long l = Util_java_util_zip_Deflater.doDeflate(addr, (CCharPointer)WordFactory.pointer((long)inputBuffer), inputLen, (CCharPointer)outputPinned.addressOfArrayElement(outputOff), outputLen, flush, params);
            return l;
        }
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private long deflateBufferBuffer(long addr, long inputBuffer, int inputLen, long outputBuffer, int outputLen, int flush, int params) {
        return Util_java_util_zip_Deflater.doDeflate(addr, (CCharPointer)WordFactory.pointer((long)inputBuffer), inputLen, (CCharPointer)WordFactory.pointer((long)outputBuffer), outputLen, flush, params);
    }
}

