/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Unistd;
import java.io.IOException;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
@TargetClass(className="java.io.FileCleanable", onlyWith={JDK11OrLater.class})
final class Target_java_io_FileCleanable {
    Target_java_io_FileCleanable() {
    }

    @Substitute
    private static void cleanupClose0(int fd, long handle) throws IOException {
        if (fd != -1 && Unistd.close(fd) == -1) {
            throw PosixUtils.newIOExceptionWithLastError("close failed");
        }
    }
}

