/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;

public final class VectorType
extends AggregateType {
    @CompilerDirectives.CompilationFinal
    private Assumption elementTypeAssumption;
    @CompilerDirectives.CompilationFinal
    private Type elementType;
    private final int length;

    public VectorType(Type elementType, int length) {
        if (elementType != null && !(elementType instanceof PrimitiveType) && !(elementType instanceof PointerType)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new AssertionError((Object)("Invalid ElementType of Vector: " + elementType));
        }
        this.elementTypeAssumption = Truffle.getRuntime().createAssumption("VectorType.elementType");
        this.elementType = elementType;
        this.length = length;
    }

    public Type getElementType() {
        if (!this.elementTypeAssumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        return this.elementType;
    }

    @Override
    public int getBitSize() {
        return this.getElementType().getBitSize() * this.length;
    }

    @Override
    public int getNumberOfElements() {
        return this.length;
    }

    public void setElementType(Type elementType) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (elementType == null || !(elementType instanceof PrimitiveType) && !(elementType instanceof PointerType)) {
            throw new AssertionError((Object)("Invalid ElementType of Vector: " + elementType));
        }
        this.elementTypeAssumption.invalidate();
        this.elementType = elementType;
        this.elementTypeAssumption = Truffle.getRuntime().createAssumption("VectorType.elementType");
    }

    @Override
    public Type getElementType(long index) {
        return this.getElementType();
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        return this.getElementType().getAlignment(targetDataLayout);
    }

    @Override
    public int getSize(DataLayout targetDataLayout) {
        return this.getElementType().getSize(targetDataLayout) * this.length;
    }

    @Override
    public long getOffsetOf(long index, DataLayout targetDataLayout) {
        return (long)this.getElementType().getSize(targetDataLayout) * index;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return String.format("< %d x %s >", this.getNumberOfElements(), this.getElementType());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getElementType() == null ? 0 : this.getElementType().hashCode());
        result = 31 * result + this.length;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VectorType other = (VectorType)obj;
        if (this.getElementType() == null ? other.getElementType() != null : !this.getElementType().equals(other.getElementType())) {
            return false;
        }
        return this.length == other.length;
    }
}

