/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;

public final class PointerType
extends AggregateType {
    public static final PointerType I8 = new PointerType(PrimitiveType.I8);
    public static final PointerType VOID = new PointerType(VoidType.INSTANCE);
    @CompilerDirectives.CompilationFinal
    private Type pointeeType;
    @CompilerDirectives.CompilationFinal
    private Assumption pointeeTypeAssumption = Truffle.getRuntime().createAssumption("PointerType.pointeeType");

    public PointerType(Type pointeeType) {
        this.pointeeType = pointeeType;
    }

    public Type getPointeeType() {
        if (!this.pointeeTypeAssumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        return this.pointeeType;
    }

    public void setPointeeType(Type type) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.pointeeTypeAssumption.invalidate();
        this.pointeeType = type;
        this.pointeeTypeAssumption = Truffle.getRuntime().createAssumption("PointerType.pointeeType");
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        if (targetDataLayout != null) {
            return targetDataLayout.getBitAlignment(this) / 8;
        }
        return 8;
    }

    @Override
    public int getSize(DataLayout targetDataLayout) {
        return 8;
    }

    @Override
    public long getOffsetOf(long index, DataLayout targetDataLayout) {
        return (long)this.getPointeeType().getSize(targetDataLayout) * index;
    }

    @Override
    public Type getElementType(long index) {
        return this.getPointeeType();
    }

    @Override
    public int getNumberOfElements() {
        CompilerDirectives.transferToInterpreter();
        throw new IllegalStateException();
    }

    @Override
    public int getBitSize() {
        return 64;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return String.format("%s*", this.getPointeeType());
    }

    @Override
    public int hashCode() {
        return PointerType.class.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PointerType;
    }
}

