/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;
import java.util.Arrays;

public final class FunctionType
extends Type {
    @CompilerDirectives.CompilationFinal
    private Assumption returnTypeAssumption = Truffle.getRuntime().createAssumption("FunctionType.returnType");
    @CompilerDirectives.CompilationFinal
    private Type returnType;
    private final Type[] argumentTypes;
    private final boolean isVarargs;

    public FunctionType(Type returnType, Type[] argumentTypes, boolean isVarargs) {
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
        this.isVarargs = isVarargs;
    }

    public Type[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public Type getReturnType() {
        if (!this.returnTypeAssumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        return this.returnType;
    }

    public void setReturnType(Type returnType) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.returnTypeAssumption.invalidate();
        this.returnType = returnType;
        this.returnTypeAssumption = Truffle.getRuntime().createAssumption("FunctionType.returnType");
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }

    @Override
    public int getBitSize() {
        return 0;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        if (targetDataLayout != null) {
            return targetDataLayout.getBitAlignment(this) / 8;
        }
        return 8;
    }

    @Override
    public int getSize(DataLayout targetDataLayout) {
        return 8;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReturnType()).append(" (");
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.argumentTypes[i]);
        }
        if (this.isVarargs) {
            if (this.argumentTypes.length > 0) {
                sb.append(", ");
            }
            sb.append("...");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.argumentTypes);
        result = 31 * result + (this.isVarargs ? 1231 : 1237);
        result = 31 * result + (this.getReturnType() == null ? 0 : this.getReturnType().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionType other = (FunctionType)obj;
        if (!Arrays.equals(this.argumentTypes, other.argumentTypes)) {
            return false;
        }
        if (this.isVarargs != other.isVarargs) {
            return false;
        }
        return !(this.getReturnType() == null ? other.getReturnType() != null : !this.getReturnType().equals(other.getReturnType()));
    }
}

