/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMShuffleVectorNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@GeneratedBy(value=LLVMShuffleVectorNode.class)
public final class LLVMShuffleVectorNodeFactory {

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleDoubleVectorNode.class)
    public static final class LLVMShuffleDoubleVectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleDoubleVectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMShuffleDoubleVectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (state != 0 && leftValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector leftValue__ = (LLVMDoubleVector)leftValue_;
                if (rightValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector rightValue__ = (LLVMDoubleVector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        return this.doOp(leftValue__, rightValue__, maskValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state = this.state_;
            if (leftValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector leftValue_ = (LLVMDoubleVector)leftValue;
                if (rightValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector rightValue_ = (LLVMDoubleVector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        this.state_ = state |= 1;
                        return this.doOp(leftValue_, rightValue_, maskValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMShuffleVectorNode.LLVMShuffleDoubleVectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleDoubleVectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleFloatVectorNode.class)
    public static final class LLVMShuffleFloatVectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleFloatVectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMShuffleFloatVectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (state != 0 && leftValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector leftValue__ = (LLVMFloatVector)leftValue_;
                if (rightValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector rightValue__ = (LLVMFloatVector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        return this.doOp(leftValue__, rightValue__, maskValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMFloatVector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state = this.state_;
            if (leftValue instanceof LLVMFloatVector) {
                LLVMFloatVector leftValue_ = (LLVMFloatVector)leftValue;
                if (rightValue instanceof LLVMFloatVector) {
                    LLVMFloatVector rightValue_ = (LLVMFloatVector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        this.state_ = state |= 1;
                        return this.doOp(leftValue_, rightValue_, maskValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMShuffleVectorNode.LLVMShuffleFloatVectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleFloatVectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleI64VectorNode.class)
    public static final class LLVMShuffleI64VectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleI64VectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMShuffleI64VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (state != 0 && maskValue_ instanceof LLVMI32Vector) {
                LLVMVector rightValue__;
                LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                if ((state & 3) != 0 && rightValue_ instanceof LLVMI64Vector) {
                    rightValue__ = (LLVMI64Vector)rightValue_;
                    if ((state & 1) != 0 && leftValue_ instanceof LLVMI64Vector) {
                        LLVMI64Vector leftValue__ = (LLVMI64Vector)leftValue_;
                        return this.doI64Vector(leftValue__, (LLVMI64Vector)rightValue__, maskValue__);
                    }
                    if ((state & 2) != 0 && leftValue_ instanceof LLVMPointerVector) {
                        LLVMPointerVector leftValue__ = (LLVMPointerVector)leftValue_;
                        return this.doPointerVector(leftValue__, (LLVMI64Vector)rightValue__, maskValue__);
                    }
                }
                if ((state & 0xC) != 0 && rightValue_ instanceof LLVMPointerVector) {
                    rightValue__ = (LLVMPointerVector)rightValue_;
                    if ((state & 4) != 0 && leftValue_ instanceof LLVMI64Vector) {
                        LLVMI64Vector leftValue__ = (LLVMI64Vector)leftValue_;
                        return this.doPointerVector(leftValue__, (LLVMPointerVector)rightValue__, maskValue__);
                    }
                    if ((state & 8) != 0 && leftValue_ instanceof LLVMPointerVector) {
                        LLVMPointerVector leftValue__ = (LLVMPointerVector)leftValue_;
                        return this.doPointerVector(leftValue__, (LLVMPointerVector)rightValue__, maskValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMVector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state = this.state_;
            if (maskValue instanceof LLVMI32Vector) {
                LLVMVector rightValue_;
                LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                if (rightValue instanceof LLVMI64Vector) {
                    rightValue_ = (LLVMI64Vector)rightValue;
                    if (leftValue instanceof LLVMI64Vector) {
                        LLVMI64Vector leftValue_ = (LLVMI64Vector)leftValue;
                        this.state_ = state |= 1;
                        return this.doI64Vector(leftValue_, (LLVMI64Vector)rightValue_, maskValue_);
                    }
                    if (leftValue instanceof LLVMPointerVector) {
                        LLVMPointerVector leftValue_ = (LLVMPointerVector)leftValue;
                        this.state_ = state |= 2;
                        return this.doPointerVector(leftValue_, (LLVMI64Vector)rightValue_, maskValue_);
                    }
                }
                if (rightValue instanceof LLVMPointerVector) {
                    rightValue_ = (LLVMPointerVector)rightValue;
                    if (leftValue instanceof LLVMI64Vector) {
                        LLVMI64Vector leftValue_ = (LLVMI64Vector)leftValue;
                        this.state_ = state |= 4;
                        return this.doPointerVector(leftValue_, (LLVMPointerVector)rightValue_, maskValue_);
                    }
                    if (leftValue instanceof LLVMPointerVector) {
                        LLVMPointerVector leftValue_ = (LLVMPointerVector)leftValue;
                        this.state_ = state |= 8;
                        return this.doPointerVector(leftValue_, (LLVMPointerVector)rightValue_, maskValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMShuffleVectorNode.LLVMShuffleI64VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI64VectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleI32VectorNode.class)
    public static final class LLVMShuffleI32VectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleI32VectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMShuffleI32VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (state != 0 && leftValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue__ = (LLVMI32Vector)leftValue_;
                if (rightValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue__ = (LLVMI32Vector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        return this.doI32Vector(leftValue__, rightValue__, maskValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state = this.state_;
            if (leftValue instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue_ = (LLVMI32Vector)leftValue;
                if (rightValue instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue_ = (LLVMI32Vector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        this.state_ = state |= 1;
                        return this.doI32Vector(leftValue_, rightValue_, maskValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMShuffleVectorNode.LLVMShuffleI32VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI32VectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleI16VectorNode.class)
    public static final class LLVMShuffleI16VectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleI16VectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMShuffleI16VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (state != 0 && leftValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue__ = (LLVMI16Vector)leftValue_;
                if (rightValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue__ = (LLVMI16Vector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        return this.doI8Vector(leftValue__, rightValue__, maskValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state = this.state_;
            if (leftValue instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue_ = (LLVMI16Vector)leftValue;
                if (rightValue instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue_ = (LLVMI16Vector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        this.state_ = state |= 1;
                        return this.doI8Vector(leftValue_, rightValue_, maskValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMShuffleVectorNode.LLVMShuffleI16VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI16VectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleI8VectorNode.class)
    public static final class LLVMShuffleI8VectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleI8VectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMShuffleI8VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (state != 0 && leftValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue__ = (LLVMI8Vector)leftValue_;
                if (rightValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue__ = (LLVMI8Vector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        return this.doI8Vector(leftValue__, rightValue__, maskValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state = this.state_;
            if (leftValue instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue_ = (LLVMI8Vector)leftValue;
                if (rightValue instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue_ = (LLVMI8Vector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        this.state_ = state |= 1;
                        return this.doI8Vector(leftValue_, rightValue_, maskValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMShuffleVectorNode.LLVMShuffleI8VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI8VectorNodeGen(left, right, mask, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMShuffleVectorNode.LLVMShuffleI1VectorNode.class)
    public static final class LLVMShuffleI1VectorNodeGen
    extends LLVMShuffleVectorNode.LLVMShuffleI1VectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode mask_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMShuffleI1VectorNodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            this.vectorLength = vectorLength;
            this.left_ = left;
            this.right_ = right;
            this.mask_ = mask;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object maskValue_ = this.mask_.executeGeneric(frameValue);
            if (state != 0 && leftValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector leftValue__ = (LLVMI1Vector)leftValue_;
                if (rightValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector rightValue__ = (LLVMI1Vector)rightValue_;
                    if (maskValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue__ = (LLVMI32Vector)maskValue_;
                        return this.doI1Vector(leftValue__, rightValue__, maskValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, maskValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object leftValue, Object rightValue, Object maskValue) {
            int state = this.state_;
            if (leftValue instanceof LLVMI1Vector) {
                LLVMI1Vector leftValue_ = (LLVMI1Vector)leftValue;
                if (rightValue instanceof LLVMI1Vector) {
                    LLVMI1Vector rightValue_ = (LLVMI1Vector)rightValue;
                    if (maskValue instanceof LLVMI32Vector) {
                        LLVMI32Vector maskValue_ = (LLVMI32Vector)maskValue;
                        this.state_ = state |= 1;
                        return this.doI1Vector(leftValue_, rightValue_, maskValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.mask_}, new Object[]{leftValue, rightValue, maskValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMShuffleVectorNode.LLVMShuffleI1VectorNode create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode mask, int vectorLength) {
            return new LLVMShuffleI1VectorNodeGen(left, right, mask, vectorLength);
        }
    }
}

