/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vars;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMFunctionStartNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@NodeChild(value="valueNode", type=LLVMExpressionNode.class)
public abstract class LLVMWriteNode
extends LLVMStatementNode {
    protected final FrameSlot slot;

    protected LLVMWriteNode(FrameSlot slot) {
        this.slot = slot;
    }

    public abstract void executeWithTarget(VirtualFrame var1, Object var2);

    @Override
    public String getSourceDescription() {
        LLVMBasicBlockNode basicBlock = (LLVMBasicBlockNode)((Object)NodeUtil.findParent((Node)this, LLVMBasicBlockNode.class));
        assert (basicBlock != null) : this.getParent().getClass();
        LLVMFunctionStartNode functionStartNode = (LLVMFunctionStartNode)NodeUtil.findParent((Node)basicBlock, LLVMFunctionStartNode.class);
        assert (functionStartNode != null) : basicBlock.getParent().getClass();
        if (basicBlock.getBlockId() == 0) {
            return String.format("assignment of %s in first basic block in function %s", this.slot.getIdentifier(), functionStartNode.getBcName());
        }
        return String.format("assignment of %s in basic block %s in function %s", this.slot.getIdentifier(), basicBlock.getBlockName(), functionStartNode.getBcName());
    }

    public static abstract class LLVMWriteVectorNode
    extends LLVMWriteNode {
        protected LLVMWriteVectorNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected void writeVector(VirtualFrame frame, LLVMVector value) {
            frame.setObject(this.slot, (Object)value);
        }
    }

    public static abstract class LLVMWritePointerNode
    extends LLVMWriteNode {
        protected LLVMWritePointerNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected void writeObject(VirtualFrame frame, Object value) {
            frame.setObject(this.slot, value);
        }
    }

    public static abstract class LLVMWrite80BitFloatingNode
    extends LLVMWriteNode {
        protected LLVMWrite80BitFloatingNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected void write80BitFloat(VirtualFrame frame, LLVM80BitFloat value) {
            frame.setObject(this.slot, (Object)value);
        }
    }

    public static abstract class LLVMWriteDoubleNode
    extends LLVMWriteNode {
        protected LLVMWriteDoubleNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected void writeDouble(VirtualFrame frame, double value) {
            frame.setDouble(this.slot, value);
        }
    }

    public static abstract class LLVMWriteFloatNode
    extends LLVMWriteNode {
        protected LLVMWriteFloatNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected void writeFloat(VirtualFrame frame, float value) {
            frame.setFloat(this.slot, value);
        }
    }

    public static abstract class LLVMWriteIVarBitNode
    extends LLVMWriteNode {
        protected LLVMWriteIVarBitNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected void writeIVarBit(VirtualFrame frame, LLVMIVarBit value) {
            frame.setObject(this.slot, (Object)value);
        }
    }

    public static abstract class LLVMWriteI64Node
    extends LLVMWriteNode {
        protected LLVMWriteI64Node(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected void writeI64(VirtualFrame frame, long value) {
            if (frame.getFrameDescriptor().getFrameSlotKind(this.slot) == FrameSlotKind.Long) {
                frame.setLong(this.slot, value);
            } else {
                frame.setObject(this.slot, (Object)value);
            }
        }

        @Specialization(replaces={"writeI64"})
        protected void writePointer(VirtualFrame frame, Object value) {
            if (frame.getFrameDescriptor().getFrameSlotKind(this.slot) == FrameSlotKind.Long) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                frame.getFrameDescriptor().setFrameSlotKind(this.slot, FrameSlotKind.Object);
            }
            frame.setObject(this.slot, value);
        }
    }

    public static abstract class LLVMWriteI32Node
    extends LLVMWriteNode {
        protected LLVMWriteI32Node(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected void writeI32(VirtualFrame frame, int value) {
            frame.setInt(this.slot, value);
        }
    }

    public static abstract class LLVMWriteI16Node
    extends LLVMWriteNode {
        protected LLVMWriteI16Node(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected void writeI16(VirtualFrame frame, short value) {
            frame.setInt(this.slot, (int)value);
        }
    }

    public static abstract class LLVMWriteI8Node
    extends LLVMWriteNode {
        protected LLVMWriteI8Node(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected void writeI8(VirtualFrame frame, byte value) {
            frame.setByte(this.slot, value);
        }
    }

    public static abstract class LLVMWriteI1Node
    extends LLVMWriteNode {
        protected LLVMWriteI1Node(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected void writeI1(VirtualFrame frame, boolean value) {
            frame.setBoolean(this.slot, value);
        }
    }
}

