/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesLongPointer;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAbstractCompareNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
@TypeSystemReference(value=LLVMTypesLongPointer.class)
public abstract class LLVMCompareNode
extends LLVMAbstractCompareNode {
    private static boolean areOrdered(double v1, double v2) {
        return !Double.isNaN(v1) && !Double.isNaN(v2);
    }

    private static boolean areOrdered(float v1, float v2) {
        return !Float.isNaN(v1) && !Float.isNaN(v2);
    }

    public static abstract class LLVMFalseCmpNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean op(Object val1, Object val2) {
            return false;
        }
    }

    public static abstract class LLVMTrueCmpNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean op(Object val1, Object val2) {
            return true;
        }
    }

    public static abstract class LLVMUnorderedNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean uno(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return !LLVM80BitFloat.areOrdered(val1, val2);
        }

        @Specialization
        protected boolean uno(double val1, double val2) {
            return !LLVMCompareNode.areOrdered(val1, val2);
        }

        @Specialization
        protected boolean uno(float val1, float val2) {
            return !LLVMCompareNode.areOrdered(val1, val2);
        }
    }

    public static abstract class LLVMUnorderedNeNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean une(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return !LLVM80BitFloat.areOrdered(val1, val2) || LLVM80BitFloat.compare(val1, val2) != 0;
        }

        @Specialization
        protected boolean une(double val1, double val2) {
            return LLVMUnorderedNeNode.doubleCompare(val1, val2);
        }

        private static boolean doubleCompare(double val1, double val2) {
            return val1 != val2;
        }

        @Specialization
        protected boolean une(float val1, float val2) {
            return LLVMUnorderedNeNode.floatCompare(val1, val2);
        }

        private static boolean floatCompare(float val1, float val2) {
            return val1 != val2;
        }
    }

    public static abstract class LLVMUnorderedEqNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean ueq(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return !LLVM80BitFloat.areOrdered(val1, val2) || LLVM80BitFloat.compare(val1, val2) == 0;
        }

        @Specialization
        protected boolean ueq(double val1, double val2) {
            return !LLVMCompareNode.areOrdered(val1, val2) || val1 == val2;
        }

        @Specialization
        protected boolean ueq(float val1, float val2) {
            return !LLVMCompareNode.areOrdered(val1, val2) || val1 == val2;
        }
    }

    public static abstract class LLVMUnorderedGeNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean uge(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return !LLVM80BitFloat.areOrdered(val1, val2) || LLVM80BitFloat.compare(val1, val2) >= 0;
        }

        @Specialization
        protected boolean uge(double val1, double val2) {
            return !(val1 < val2);
        }

        @Specialization
        protected boolean uge(float val1, float val2) {
            return !(val1 < val2);
        }
    }

    public static abstract class LLVMUnorderedGtNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean ugt(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return !LLVM80BitFloat.areOrdered(val1, val2) || LLVM80BitFloat.compare(val1, val2) > 0;
        }

        @Specialization
        protected boolean ugt(double val1, double val2) {
            return !(val1 <= val2);
        }

        @Specialization
        protected boolean ugt(float val1, float val2) {
            return !(val1 <= val2);
        }
    }

    public static abstract class LLVMUnorderedLeNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean ule(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return !LLVM80BitFloat.areOrdered(val1, val2) || LLVM80BitFloat.compare(val1, val2) <= 0;
        }

        @Specialization
        protected boolean ule(double val1, double val2) {
            return !(val1 > val2);
        }

        @Specialization
        protected boolean ule(float val1, float val2) {
            return !(val1 > val2);
        }
    }

    public static abstract class LLVMUnorderedLtNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean ult(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return !LLVM80BitFloat.areOrdered(val1, val2) || LLVM80BitFloat.compare(val1, val2) < 0;
        }

        @Specialization
        protected boolean ult(double val1, double val2) {
            return !(val1 >= val2);
        }

        @Specialization
        protected boolean ult(float val1, float val2) {
            return !(val1 >= val2);
        }
    }

    public static abstract class LLVMOrderedNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean ord(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return LLVM80BitFloat.areOrdered(val1, val2);
        }

        @Specialization
        protected boolean ord(double val1, double val2) {
            return LLVMCompareNode.areOrdered(val1, val2);
        }

        @Specialization
        protected boolean ord(float val1, float val2) {
            return LLVMCompareNode.areOrdered(val1, val2);
        }
    }

    public static abstract class LLVMOrderedNeNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean one(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return LLVM80BitFloat.areOrdered(val1, val2) && LLVM80BitFloat.compare(val1, val2) != 0;
        }

        @Specialization
        protected boolean one(double val1, double val2) {
            return LLVMOrderedNeNode.doubleCompare(val1, val2);
        }

        private static boolean doubleCompare(double val1, double val2) {
            if (val1 != val2) {
                return LLVMCompareNode.areOrdered(val1, val2);
            }
            return false;
        }

        @Specialization
        protected boolean one(float val1, float val2) {
            return LLVMOrderedNeNode.floatCompare(val1, val2);
        }

        private static boolean floatCompare(float val1, float val2) {
            if (val1 != val2) {
                return LLVMCompareNode.areOrdered(val1, val2);
            }
            return false;
        }
    }

    public static abstract class LLVMOrderedEqNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean oeq(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return LLVM80BitFloat.areOrdered(val1, val2) && LLVM80BitFloat.compare(val1, val2) == 0;
        }

        @Specialization
        protected boolean oeq(double val1, double val2) {
            return LLVMOrderedEqNode.doubleCompare(val1, val2);
        }

        private static boolean doubleCompare(double val1, double val2) {
            return val1 == val2;
        }

        @Specialization
        protected boolean oeq(float val1, float val2) {
            return LLVMOrderedEqNode.floatCompare(val1, val2);
        }

        private static boolean floatCompare(float val1, float val2) {
            assert (val1 != val2 || LLVMCompareNode.areOrdered(val1, val2));
            return val1 == val2;
        }
    }

    public static abstract class LLVMOrderedLeNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean ole(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return LLVM80BitFloat.areOrdered(val1, val2) && LLVM80BitFloat.compare(val1, val2) <= 0;
        }

        @Specialization
        protected boolean oleDouble(double val1, double val2) {
            return LLVMOrderedLeNode.doubleCompare(val1, val2);
        }

        private static boolean doubleCompare(double val1, double val2) {
            return val1 <= val2;
        }

        @Specialization
        protected boolean oleFloat(float val1, float val2) {
            return LLVMOrderedLeNode.floatCompare(val1, val2);
        }

        private static boolean floatCompare(float val1, float val2) {
            assert (!(val1 <= val2) || LLVMCompareNode.areOrdered(val1, val2));
            return val1 <= val2;
        }
    }

    public static abstract class LLVMOrderedGeNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean oge(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return LLVM80BitFloat.areOrdered(val1, val2) && LLVM80BitFloat.compare(val1, val2) >= 0;
        }

        @Specialization
        protected boolean oge(double val1, double val2) {
            return LLVMOrderedGeNode.doubleCompare(val1, val2);
        }

        private static boolean doubleCompare(double val1, double val2) {
            return val1 >= val2;
        }

        @Specialization
        protected boolean oge(float val1, float val2) {
            return LLVMOrderedGeNode.floatCompare(val1, val2);
        }

        private static boolean floatCompare(float val1, float val2) {
            assert (!(val1 >= val2) || LLVMCompareNode.areOrdered(val1, val2));
            return val1 >= val2;
        }
    }

    public static abstract class LLVMOrderedGtNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean ogt(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return LLVM80BitFloat.areOrdered(val1, val2) && LLVM80BitFloat.compare(val1, val2) > 0;
        }

        @Specialization
        protected boolean ogt(double val1, double val2) {
            return LLVMOrderedGtNode.doubleCompare(val1, val2);
        }

        private static boolean doubleCompare(double val1, double val2) {
            return val1 > val2;
        }

        @Specialization
        protected boolean ogt(float val1, float val2) {
            return LLVMOrderedGtNode.floatCompare(val1, val2);
        }

        private static boolean floatCompare(float val1, float val2) {
            assert (!(val1 > val2) || LLVMCompareNode.areOrdered(val1, val2));
            return val1 > val2;
        }
    }

    public static abstract class LLVMOrderedLtNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean olt(LLVM80BitFloat val1, LLVM80BitFloat val2) {
            return LLVM80BitFloat.areOrdered(val1, val2) && LLVM80BitFloat.compare(val1, val2) < 0;
        }

        @Specialization
        protected boolean olt(double val1, double val2) {
            return LLVMOrderedLtNode.doubleCompare(val1, val2);
        }

        private static boolean doubleCompare(double val1, double val2) {
            return val1 < val2;
        }

        @Specialization
        protected boolean olt(float val1, float val2) {
            return LLVMOrderedLtNode.floatCompare(val1, val2);
        }

        private static boolean floatCompare(float val1, float val2) {
            assert (!(val1 < val2) || LLVMCompareNode.areOrdered(val1, val2));
            return val1 < val2;
        }
    }

    public static abstract class LLVMUnsignedLeNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean ule(short val1, short val2) {
            return Integer.compareUnsigned(val1, val2) <= 0;
        }

        @Specialization
        protected boolean ule(LLVMIVarBit val1, LLVMIVarBit val2) {
            return val1.unsignedCompare(val2) <= 0;
        }

        @Specialization
        protected boolean ule(int val1, int val2) {
            return Integer.compareUnsigned(val1, val2) <= 0;
        }

        @Specialization
        protected boolean ule(long val1, long val2) {
            return Long.compareUnsigned(val1, val2) <= 0;
        }

        @Specialization
        protected boolean ule(byte val1, byte val2) {
            return Integer.compareUnsigned(val1, val2) <= 0;
        }
    }

    public static abstract class LLVMUnsignedLtNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean ult(short val1, short val2) {
            return Integer.compareUnsigned(val1, val2) < 0;
        }

        @Specialization
        protected boolean ult(LLVMIVarBit val1, LLVMIVarBit val2) {
            return val1.unsignedCompare(val2) < 0;
        }

        @Specialization
        protected boolean ult(int val1, int val2) {
            return Integer.compareUnsigned(val1, val2) < 0;
        }

        @Specialization
        protected boolean ult(long val1, long val2) {
            return Long.compareUnsigned(val1, val2) < 0;
        }

        @Specialization
        protected boolean ult(byte val1, byte val2) {
            return Integer.compareUnsigned(val1, val2) < 0;
        }
    }

    public static abstract class LLVMSignedLeNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean sle(short val1, short val2) {
            return val1 <= val2;
        }

        @Specialization
        protected boolean sle(LLVMIVarBit val1, LLVMIVarBit val2) {
            return val1.signedCompare(val2) <= 0;
        }

        @Specialization
        protected boolean sle(int val1, int val2) {
            return val1 <= val2;
        }

        @Specialization
        protected boolean sle(long val1, long val2) {
            return val1 <= val2;
        }

        @Specialization
        protected boolean sle(byte val1, byte val2) {
            return val1 <= val2;
        }
    }

    public static abstract class LLVMSignedLtNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean slt(short val1, short val2) {
            return val1 < val2;
        }

        @Specialization
        protected boolean slt(LLVMIVarBit val1, LLVMIVarBit val2) {
            return val1.signedCompare(val2) < 0;
        }

        @Specialization
        protected boolean slt(int val1, int val2) {
            return val1 < val2;
        }

        @Specialization
        protected boolean slt(long val1, long val2) {
            return val1 < val2;
        }

        @Specialization
        protected boolean slt(byte val1, byte val2) {
            return val1 < val2;
        }
    }

    public static abstract class LLVMNeNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean nq(boolean val1, boolean val2) {
            return val1 != val2;
        }

        @Specialization
        protected boolean nq(byte val1, byte val2) {
            return val1 != val2;
        }

        @Specialization
        protected boolean nq(short val1, short val2) {
            return val1 != val2;
        }

        @Specialization
        protected boolean nq(int val1, int val2) {
            return val1 != val2;
        }

        @Specialization
        protected boolean nqLong(long val1, long val2) {
            return val1 != val2;
        }

        @Specialization(replaces={"nqLong"})
        protected boolean nqPointer(LLVMPointer val1, LLVMPointer val2, @Cached LLVMAddressEqualsNode.LLVMPointerEqualsNode equals) {
            return !equals.execute(val1, val2);
        }

        @Specialization
        protected boolean nq(LLVMIVarBit val1, LLVMIVarBit val2) {
            return !val1.isEqual(val2);
        }
    }

    public static abstract class LLVMEqNode
    extends LLVMCompareNode {
        @Specialization
        protected boolean eq(boolean val1, boolean val2) {
            return val1 == val2;
        }

        @Specialization
        protected boolean eq(byte val1, byte val2) {
            return val1 == val2;
        }

        @Specialization
        protected boolean eq(short val1, short val2) {
            return val1 == val2;
        }

        @Specialization
        protected boolean eq(int val1, int val2) {
            return val1 == val2;
        }

        @Specialization
        protected boolean eqLong(long val1, long val2) {
            return val1 == val2;
        }

        @Specialization(replaces={"eqLong"})
        protected boolean eqPointer(LLVMPointer val1, LLVMPointer val2, @Cached LLVMAddressEqualsNode.LLVMPointerEqualsNode equals) {
            return equals.execute(val1, val2);
        }

        @Specialization
        protected boolean eq(LLVMIVarBit val1, LLVMIVarBit val2) {
            return val1.isEqual(val2);
        }
    }
}

