/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.llvm.runtime.ArithmeticOperation;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMArithmetic;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMArithmeticNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.ReferenceLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMArithmeticNode.class)
public final class LLVMArithmeticNodeFactory {
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);
    private static final LibraryFactory<ReferenceLibrary> REFERENCE_LIBRARY_ = LibraryFactory.resolve(ReferenceLibrary.class);

    @GeneratedBy(value=LLVMArithmeticNode.ManagedXorNode.class)
    static final class ManagedXorNodeGen
    extends LLVMArithmeticNode.ManagedXorNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private ValueProfile type_;

        private ManagedXorNodeGen() {
        }

        @Override
        Object execute(LLVMManagedPointer arg0Value, long arg1Value) {
            int state = this.state_;
            if (state != 0) {
                return this.doXor(arg0Value, arg1Value, this.type_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMManagedPointer executeAndSpecialize(LLVMManagedPointer arg0Value, long arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.type_ = ValueProfile.createClassProfile();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.doXor(arg0Value, arg1Value, this.type_);
                return lLVMManagedPointer;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMArithmeticNode.ManagedXorNode create() {
            return new ManagedXorNodeGen();
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.ManagedAndNode.class)
    static final class ManagedAndNodeGen
    extends LLVMArithmeticNode.ManagedAndNode {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ManagedAndNodeGen() {
        }

        @Override
        Object execute(LLVMManagedPointer arg0Value, long arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && LLVMArithmeticNode.ManagedAndNode.highBitsSet(arg1Value)) {
                    return this.doAlign(arg0Value, arg1Value);
                }
                if ((state & 2) != 0 && LLVMArithmeticNode.ManagedAndNode.highBitsClear(arg1Value)) {
                    return this.doMask(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        long executeLong(LLVMManagedPointer arg0Value, long arg1Value) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 2) != 0 && LLVMArithmeticNode.ManagedAndNode.highBitsClear(arg1Value)) {
                return this.doMask(arg0Value, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(arg0Value, arg1Value));
        }

        private Object executeAndSpecialize(LLVMManagedPointer arg0Value, long arg1Value) {
            int state = this.state_;
            if (LLVMArithmeticNode.ManagedAndNode.highBitsSet(arg1Value)) {
                this.state_ = state |= 1;
                return this.doAlign(arg0Value, arg1Value);
            }
            if (LLVMArithmeticNode.ManagedAndNode.highBitsClear(arg1Value)) {
                this.state_ = state |= 2;
                return this.doMask(arg0Value, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticNode.ManagedAndNode create() {
            return new ManagedAndNodeGen();
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.ManagedSubNode.class)
    static final class ManagedSubNodeGen
    extends LLVMArithmeticNode.ManagedSubNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private ValueProfile right_type_;

        private ManagedSubNodeGen() {
        }

        @Override
        Object execute(LLVMManagedPointer arg0Value, long arg1Value) {
            int state = this.state_;
            if ((state & 1) != 0) {
                return this.doLeft(arg0Value, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        Object execute(long arg0Value, LLVMManagedPointer arg1Value) {
            int state = this.state_;
            if ((state & 2) != 0) {
                return this.doRight(arg0Value, arg1Value, this.right_type_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private LLVMManagedPointer executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if (arg1Value instanceof Long) {
                        long arg1Value_ = (Long)arg1Value;
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMManagedPointer lLVMManagedPointer = this.doLeft(arg0Value_, arg1Value_);
                        return lLVMManagedPointer;
                    }
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    if (LLVMTypes.isManagedPointer(arg1Value)) {
                        LLVMManagedPointer arg1Value_ = LLVMTypes.asManagedPointer(arg1Value);
                        this.right_type_ = ValueProfile.createClassProfile();
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMManagedPointer lLVMManagedPointer = this.doRight(arg0Value_, arg1Value_, this.right_type_);
                        return lLVMManagedPointer;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticNode.ManagedSubNode create() {
            return new ManagedSubNodeGen();
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.ManagedMulNode.class)
    static final class ManagedMulNodeGen
    extends LLVMArithmeticNode.ManagedMulNode {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ManagedMulNodeGen() {
        }

        @Override
        Object execute(LLVMManagedPointer arg0Value, long arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg1Value == 1L) {
                    return this.doIdentity(arg0Value, arg1Value);
                }
                if ((state & 2) != 0 && arg1Value == 0L) {
                    return this.doZero(arg0Value, arg1Value);
                }
                if ((state & 4) != 0 && LLVMArithmeticNode.ManagedMulNode.isMinusOne(arg1Value)) {
                    return this.doNegate(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        long executeLong(LLVMManagedPointer arg0Value, long arg1Value) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 2) != 0 && arg1Value == 0L) {
                return this.doZero(arg0Value, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(arg0Value, arg1Value));
        }

        private Object executeAndSpecialize(LLVMManagedPointer arg0Value, long arg1Value) {
            int state = this.state_;
            if (arg1Value == 1L) {
                this.state_ = state |= 1;
                return this.doIdentity(arg0Value, arg1Value);
            }
            if (arg1Value == 0L) {
                this.state_ = state |= 2;
                return this.doZero(arg0Value, arg1Value);
            }
            if (LLVMArithmeticNode.ManagedMulNode.isMinusOne(arg1Value)) {
                this.state_ = state |= 4;
                return this.doNegate(arg0Value, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticNode.ManagedMulNode create() {
            return new ManagedMulNodeGen();
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMFP80ArithmeticNode.class)
    public static final class LLVMFP80ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMFP80ArithmeticNode {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private LLVMArithmetic.LLVMArithmeticOpNode node_;

        private LLVMFP80ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (state != 0 && leftNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat leftNodeValue_ = (LLVM80BitFloat)leftNodeValue;
                if (rightNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat rightNodeValue_ = (LLVM80BitFloat)rightNodeValue;
                    return this.do80BitFloat(leftNodeValue_, rightNodeValue_, this.node_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if (state != 0 && leftNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat leftNodeValue__ = (LLVM80BitFloat)leftNodeValue_;
                if (rightNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat rightNodeValue__ = (LLVM80BitFloat)rightNodeValue_;
                    return this.do80BitFloat(leftNodeValue__, rightNodeValue__, this.node_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private LLVM80BitFloat executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (leftNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat leftNodeValue_ = (LLVM80BitFloat)leftNodeValue;
                    if (rightNodeValue instanceof LLVM80BitFloat) {
                        LLVM80BitFloat rightNodeValue_ = (LLVM80BitFloat)rightNodeValue;
                        this.node_ = (LLVMArithmetic.LLVMArithmeticOpNode)super.insert((Node)this.createFP80Node());
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVM80BitFloat lLVM80BitFloat = this.do80BitFloat(leftNodeValue_, rightNodeValue_, this.node_);
                        return lLVM80BitFloat;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMArithmeticNode.LLVMFP80ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMFP80ArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMDoubleArithmeticNode.class)
    public static final class LLVMDoubleArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMDoubleArithmeticNode {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMDoubleArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (state != 0 && leftNodeValue instanceof Double) {
                double leftNodeValue_ = (Double)leftNodeValue;
                if (rightNodeValue instanceof Double) {
                    double rightNodeValue_ = (Double)rightNodeValue;
                    return this.doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            double rightNodeValue_;
            double leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doDouble(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            double rightNodeValue_;
            double leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doDouble(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private double executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (leftNodeValue instanceof Double) {
                double leftNodeValue_ = (Double)leftNodeValue;
                if (rightNodeValue instanceof Double) {
                    double rightNodeValue_ = (Double)rightNodeValue;
                    this.state_ = state |= 1;
                    return this.doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMArithmeticNode.LLVMDoubleArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMDoubleArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMFloatArithmeticNode.class)
    public static final class LLVMFloatArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMFloatArithmeticNode {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFloatArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (state != 0 && leftNodeValue instanceof Float) {
                float leftNodeValue_ = ((Float)leftNodeValue).floatValue();
                if (rightNodeValue instanceof Float) {
                    float rightNodeValue_ = ((Float)rightNodeValue).floatValue();
                    return Float.valueOf(this.doFloat(leftNodeValue_, rightNodeValue_));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(leftNodeValue, rightNodeValue));
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            float rightNodeValue_;
            float leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return Float.valueOf(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            try {
                rightNodeValue_ = this.rightNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(Float.valueOf(leftNodeValue_), ex.getResult()));
            }
            if (state != 0) {
                return Float.valueOf(this.doFloat(leftNodeValue_, rightNodeValue_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(Float.valueOf(leftNodeValue_), Float.valueOf(rightNodeValue_)));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            float rightNodeValue_;
            float leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(Float.valueOf(leftNodeValue_), ex.getResult());
            }
            if (state != 0) {
                return this.doFloat(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(Float.valueOf(leftNodeValue_), Float.valueOf(rightNodeValue_));
        }

        private float executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (leftNodeValue instanceof Float) {
                float leftNodeValue_ = ((Float)leftNodeValue).floatValue();
                if (rightNodeValue instanceof Float) {
                    float rightNodeValue_ = ((Float)rightNodeValue).floatValue();
                    this.state_ = state |= 1;
                    return this.doFloat(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMArithmeticNode.LLVMFloatArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMFloatArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMIVarBitArithmeticNode.class)
    public static final class LLVMIVarBitArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMIVarBitArithmeticNode {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMIVarBitArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if ((state & 1) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state & 0xE) >>> 1, leftNodeValue)) {
                LLVMIVarBit leftNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state & 0xE) >>> 1, leftNodeValue);
                if (LLVMTypesGen.isImplicitLLVMIVarBit((state & 0x70) >>> 4, rightNodeValue)) {
                    LLVMIVarBit rightNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state & 0x70) >>> 4, rightNodeValue);
                    return this.doVarBit(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state & 0xE) >>> 1, leftNodeValue_)) {
                LLVMIVarBit leftNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state & 0xE) >>> 1, leftNodeValue_);
                if (LLVMTypesGen.isImplicitLLVMIVarBit((state & 0x70) >>> 4, rightNodeValue_)) {
                    LLVMIVarBit rightNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state & 0x70) >>> 4, rightNodeValue_);
                    return this.doVarBit(leftNodeValue__, rightNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(leftNodeValue);
            if (lLVMIVarBitCast0 != 0) {
                LLVMIVarBit leftNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, leftNodeValue);
                int lLVMIVarBitCast1 = LLVMTypesGen.specializeImplicitLLVMIVarBit(rightNodeValue);
                if (lLVMIVarBitCast1 != 0) {
                    LLVMIVarBit rightNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast1, rightNodeValue);
                    state |= lLVMIVarBitCast0 << 1;
                    state |= lLVMIVarBitCast1 << 4;
                    this.state_ = state |= 1;
                    return this.doVarBit(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 1) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMArithmeticNode.LLVMIVarBitArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMIVarBitArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
    static final class LLVMI64SubNodeGen
    extends LLVMArithmeticNode.LLVMI64SubNode {
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node leftNode_;
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedLeftLong_node_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedLeft_node_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedRightLong_node_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedRight_node_;
        @Node.Child
        private PointerRight0Data pointerRight0_cache;
        @Node.Child
        private PointerLeft0Data pointerLeft0_cache;
        @Node.Child
        private SameObjectLong0Data sameObjectLong0_cache;
        @Node.Child
        private NotSameObject0Data notSameObject0_cache;

        private LLVMI64SubNodeGen(LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            this.leftNode_ = this.createCast(leftNode);
            this.rightNode_ = this.createCast(rightNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if ((state & 7) != 0 && rightNodeValue instanceof Long) {
                long rightNodeValue_ = (Long)rightNodeValue;
                if ((state & 1) != 0 && leftNodeValue instanceof Long) {
                    long leftNodeValue_ = (Long)leftNodeValue;
                    return this.doLong(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 6) != 0 && LLVMTypes.isManagedPointer(leftNodeValue)) {
                    LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                    if ((state & 2) != 0 && this.canDoManaged(rightNodeValue_)) {
                        try {
                            return this.doManagedLeftLong(leftNodeValue_, rightNodeValue_, this.managedLeftLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 1;
                                this.state_ &= 0xFFFFFFFD;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 4) != 0 && this.canDoManaged(rightNodeValue_)) {
                        return this.doManagedLeft(leftNodeValue_, rightNodeValue_, this.managedLeft_node_);
                    }
                }
            }
            if ((state & 0x78) != 0 && leftNodeValue instanceof Long) {
                LLVMPointer rightNodeValue_;
                long leftNodeValue_ = (Long)leftNodeValue;
                if ((state & 0x18) != 0 && LLVMTypes.isManagedPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                    if ((state & 8) != 0 && this.canDoManaged(leftNodeValue_)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, this.managedRightLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 2;
                                this.state_ &= 0xFFFFFFF7;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 0x10) != 0 && this.canDoManaged(leftNodeValue_)) {
                        return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, this.managedRight_node_);
                    }
                }
                if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asPointer(rightNodeValue);
                    if ((state & 0x20) != 0) {
                        PointerRight0Data s6_ = this.pointerRight0_cache;
                        while (s6_ != null) {
                            if (s6_.rightLib_.accepts(rightNodeValue_) && !this.canDoManaged(leftNodeValue_)) {
                                return this.doPointerRight(leftNodeValue_, rightNodeValue_, s6_.rightLib_);
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue_)) {
                        return this.pointerRight1Boundary(state, leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue)) {
                LLVMPointer leftNodeValue_ = LLVMTypes.asPointer(leftNodeValue);
                if (rightNodeValue instanceof Long) {
                    long rightNodeValue_ = (Long)rightNodeValue;
                    if ((state & 0x80) != 0) {
                        PointerLeft0Data s8_ = this.pointerLeft0_cache;
                        while (s8_ != null) {
                            if (s8_.leftLib_.accepts(leftNodeValue_) && !this.canDoManaged(rightNodeValue_)) {
                                return this.doPointerLeft(leftNodeValue_, rightNodeValue_, s8_.leftLib_);
                            }
                            s8_ = s8_.next_;
                        }
                    }
                    if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue_)) {
                        return this.pointerLeft1Boundary(state, leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if ((state & 0x1E00) != 0 && LLVMTypes.isManagedPointer(leftNodeValue)) {
                LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                if (LLVMTypes.isManagedPointer(rightNodeValue)) {
                    Long l;
                    Node prev_;
                    LLVMManagedPointer rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                    if ((state & 0x200) != 0) {
                        SameObjectLong0Data s10_ = this.sameObjectLong0_cache;
                        while (s10_ != null) {
                            if (s10_.sameObject_.accepts(leftNodeValue_.getObject()) && s10_.sameObject_.isSame(leftNodeValue_.getObject(), rightNodeValue_.getObject())) {
                                return this.doSameObjectLong(leftNodeValue_, rightNodeValue_, s10_.sameObject_);
                            }
                            s10_ = s10_.next_;
                        }
                    }
                    if ((state & 0x400) != 0) {
                        prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                        try {
                            if (((ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue_.getObject())).isSame(leftNodeValue_.getObject(), rightNodeValue_.getObject())) {
                                l = this.doSameObjectLong(leftNodeValue_, rightNodeValue_, (ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue_.getObject()));
                                return l;
                            }
                        }
                        finally {
                            NodeUtil.popEncapsulatingNode((Node)prev_);
                        }
                    }
                    if ((state & 0x800) != 0) {
                        NotSameObject0Data s12_ = this.notSameObject0_cache;
                        while (s12_ != null) {
                            if (s12_.sameObject_.accepts(leftNodeValue_.getObject()) && s12_.leftLib_.accepts(leftNodeValue_) && s12_.rightLib_.accepts(rightNodeValue_) && !s12_.sameObject_.isSame(leftNodeValue_.getObject(), rightNodeValue_.getObject())) {
                                return this.doNotSameObject(leftNodeValue_, rightNodeValue_, s12_.sameObject_, s12_.leftLib_, s12_.rightLib_);
                            }
                            s12_ = s12_.next_;
                        }
                    }
                    if ((state & 0x1000) != 0) {
                        prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                        try {
                            if (!((ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue_.getObject())).isSame(leftNodeValue_.getObject(), rightNodeValue_.getObject())) {
                                l = this.doNotSameObject(leftNodeValue_, rightNodeValue_, (ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue_.getObject()), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue_), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue_));
                                return l;
                            }
                        }
                        finally {
                            NodeUtil.popEncapsulatingNode((Node)prev_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerRight1Boundary(int state, long leftNodeValue_, LLVMPointer rightNodeValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerRight(leftNodeValue_, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue_));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerLeft1Boundary(int state, LLVMPointer leftNodeValue_, long rightNodeValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerLeft(leftNodeValue_, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue_));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x1FFE) == 0 && state != 0) {
                return this.executeGeneric_long_long0(frameValue, state);
            }
            if ((state & 0x1E79) == 0 && state != 0) {
                return this.executeGeneric_long1(frameValue, state);
            }
            if ((state & 0x1F87) == 0 && state != 0) {
                return this.executeGeneric_long2(frameValue, state);
            }
            return this.executeGeneric_generic3(frameValue, state);
        }

        private Object executeGeneric_long_long0(VirtualFrame frameValue, int state) {
            long rightNodeValue_;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerLeft1Boundary0(int state, LLVMPointer leftNodeValue__, long rightNodeValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerLeft(leftNodeValue__, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_long1(VirtualFrame frameValue, int state) {
            LLVMPointer leftNodeValue__;
            long rightNodeValue_;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if ((state & 6) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                if ((state & 2) != 0 && this.canDoManaged(rightNodeValue_)) {
                    try {
                        return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, this.managedLeftLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 1;
                            this.state_ &= 0xFFFFFFFD;
                        }
                        finally {
                            lock.unlock();
                        }
                        return ex.getResult();
                    }
                }
                if ((state & 4) != 0 && this.canDoManaged(rightNodeValue_)) {
                    return this.doManagedLeft((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, this.managedLeft_node_);
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if ((state & 0x80) != 0) {
                    PointerLeft0Data s8_ = this.pointerLeft0_cache;
                    while (s8_ != null) {
                        if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue_)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue_, s8_.leftLib_);
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue_)) {
                    return this.pointerLeft1Boundary0(state, leftNodeValue__, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerRight1Boundary1(int state, long leftNodeValue_, LLVMPointer rightNodeValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerRight(leftNodeValue_, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_long2(VirtualFrame frameValue, int state) {
            LLVMPointer rightNodeValue__;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 0x18) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                if ((state & 8) != 0 && this.canDoManaged(leftNodeValue_)) {
                    try {
                        return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 2;
                            this.state_ &= 0xFFFFFFF7;
                        }
                        finally {
                            lock.unlock();
                        }
                        return ex.getResult();
                    }
                }
                if ((state & 0x10) != 0 && this.canDoManaged(leftNodeValue_)) {
                    return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, this.managedRight_node_);
                }
            }
            if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                if ((state & 0x20) != 0) {
                    PointerRight0Data s6_ = this.pointerRight0_cache;
                    while (s6_ != null) {
                        if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue_)) {
                            return this.doPointerRight(leftNodeValue_, rightNodeValue__, s6_.rightLib_);
                        }
                        s6_ = s6_.next_;
                    }
                }
                if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue_)) {
                    return this.pointerRight1Boundary1(state, leftNodeValue_, rightNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerRight1Boundary2(int state, long leftNodeValue__, LLVMPointer rightNodeValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerRight(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerLeft1Boundary3(int state, LLVMPointer leftNodeValue__, long rightNodeValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerLeft(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_generic3(VirtualFrame frameValue, int state) {
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 7) != 0 && rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                if ((state & 1) != 0 && leftNodeValue_ instanceof Long) {
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    return this.doLong(leftNodeValue__, rightNodeValue__);
                }
                if ((state & 6) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    if ((state & 2) != 0 && this.canDoManaged(rightNodeValue__)) {
                        try {
                            return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, this.managedLeftLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 1;
                                this.state_ &= 0xFFFFFFFD;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 4) != 0 && this.canDoManaged(rightNodeValue__)) {
                        return this.doManagedLeft(leftNodeValue__, rightNodeValue__, this.managedLeft_node_);
                    }
                }
            }
            if ((state & 0x78) != 0 && leftNodeValue_ instanceof Long) {
                LLVMPointer rightNodeValue__;
                long leftNodeValue__ = (Long)leftNodeValue_;
                if ((state & 0x18) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    if ((state & 8) != 0 && this.canDoManaged(leftNodeValue__)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 2;
                                this.state_ &= 0xFFFFFFF7;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 0x10) != 0 && this.canDoManaged(leftNodeValue__)) {
                        return this.doManagedRight(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, this.managedRight_node_);
                    }
                }
                if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    if ((state & 0x20) != 0) {
                        PointerRight0Data s6_ = this.pointerRight0_cache;
                        while (s6_ != null) {
                            if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue__)) {
                                return this.doPointerRight(leftNodeValue__, rightNodeValue__, s6_.rightLib_);
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue__)) {
                        return this.pointerRight1Boundary2(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if (rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state & 0x80) != 0) {
                        PointerLeft0Data s8_ = this.pointerLeft0_cache;
                        while (s8_ != null) {
                            if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue__)) {
                                return this.doPointerLeft(leftNodeValue__, rightNodeValue__, s8_.leftLib_);
                            }
                            s8_ = s8_.next_;
                        }
                    }
                    if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue__)) {
                        return this.pointerLeft1Boundary3(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            if ((state & 0x1E00) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                if (LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    Long l;
                    Node prev_;
                    LLVMManagedPointer rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    if ((state & 0x200) != 0) {
                        SameObjectLong0Data s10_ = this.sameObjectLong0_cache;
                        while (s10_ != null) {
                            if (s10_.sameObject_.accepts(leftNodeValue__.getObject()) && s10_.sameObject_.isSame(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                return this.doSameObjectLong(leftNodeValue__, rightNodeValue__, s10_.sameObject_);
                            }
                            s10_ = s10_.next_;
                        }
                    }
                    if ((state & 0x400) != 0) {
                        prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                        try {
                            if (((ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue__.getObject())).isSame(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                l = this.doSameObjectLong(leftNodeValue__, rightNodeValue__, (ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue__.getObject()));
                                return l;
                            }
                        }
                        finally {
                            NodeUtil.popEncapsulatingNode((Node)prev_);
                        }
                    }
                    if ((state & 0x800) != 0) {
                        NotSameObject0Data s12_ = this.notSameObject0_cache;
                        while (s12_ != null) {
                            if (s12_.sameObject_.accepts(leftNodeValue__.getObject()) && s12_.leftLib_.accepts(leftNodeValue__) && s12_.rightLib_.accepts(rightNodeValue__) && !s12_.sameObject_.isSame(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                return this.doNotSameObject(leftNodeValue__, rightNodeValue__, s12_.sameObject_, s12_.leftLib_, s12_.rightLib_);
                            }
                            s12_ = s12_.next_;
                        }
                    }
                    if ((state & 0x1000) != 0) {
                        prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                        try {
                            if (!((ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue__.getObject())).isSame(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                l = this.doNotSameObject(leftNodeValue__, rightNodeValue__, (ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue__.getObject()), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                                return l;
                            }
                        }
                        finally {
                            NodeUtil.popEncapsulatingNode((Node)prev_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 0x14) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state & 0x1FEA) == 0 && (state & 0x1FEB) != 0) {
                return this.executeI64_long_long4(frameValue, state);
            }
            if ((state & 0x1E69) == 0 && (state & 0x1FEB) != 0) {
                return this.executeI64_long5(frameValue, state);
            }
            if ((state & 0x1F83) == 0 && (state & 0x1FEB) != 0) {
                return this.executeI64_long6(frameValue, state);
            }
            return this.executeI64_generic7(frameValue, state);
        }

        private long executeI64_long_long4(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            long rightNodeValue_;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            assert ((state & 1) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerLeft1Boundary4(int state, LLVMPointer leftNodeValue__, long rightNodeValue_) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerLeft(leftNodeValue__, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private long executeI64_long5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            LLVMPointer leftNodeValue__;
            long rightNodeValue_;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            if ((state & 2) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                if (this.canDoManaged(rightNodeValue_)) {
                    try {
                        return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, this.managedLeftLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 1;
                            this.state_ &= 0xFFFFFFFD;
                        }
                        finally {
                            lock.unlock();
                        }
                        return LLVMTypesGen.expectLong(ex.getResult());
                    }
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if ((state & 0x80) != 0) {
                    PointerLeft0Data s8_ = this.pointerLeft0_cache;
                    while (s8_ != null) {
                        if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue_)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue_, s8_.leftLib_);
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue_)) {
                    return this.pointerLeft1Boundary4(state, leftNodeValue__, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerRight1Boundary5(int state, long leftNodeValue_, LLVMPointer rightNodeValue__) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerRight(leftNodeValue_, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private long executeI64_long6(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            LLVMPointer rightNodeValue__;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 8) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                if (this.canDoManaged(leftNodeValue_)) {
                    try {
                        return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 2;
                            this.state_ &= 0xFFFFFFF7;
                        }
                        finally {
                            lock.unlock();
                        }
                        return LLVMTypesGen.expectLong(ex.getResult());
                    }
                }
            }
            if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                if ((state & 0x20) != 0) {
                    PointerRight0Data s6_ = this.pointerRight0_cache;
                    while (s6_ != null) {
                        if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue_)) {
                            return this.doPointerRight(leftNodeValue_, rightNodeValue__, s6_.rightLib_);
                        }
                        s6_ = s6_.next_;
                    }
                }
                if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue_)) {
                    return this.pointerRight1Boundary5(state, leftNodeValue_, rightNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerRight1Boundary6(int state, long leftNodeValue__, LLVMPointer rightNodeValue__) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerRight(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerLeft1Boundary7(int state, LLVMPointer leftNodeValue__, long rightNodeValue__) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerLeft(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private long executeI64_generic7(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 3) != 0 && rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                if ((state & 1) != 0 && leftNodeValue_ instanceof Long) {
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    return this.doLong(leftNodeValue__, rightNodeValue__);
                }
                if ((state & 2) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    if (this.canDoManaged(rightNodeValue__)) {
                        try {
                            return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, this.managedLeftLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 1;
                                this.state_ &= 0xFFFFFFFD;
                            }
                            finally {
                                lock.unlock();
                            }
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
            }
            if ((state & 0x68) != 0 && leftNodeValue_ instanceof Long) {
                LLVMPointer rightNodeValue__;
                long leftNodeValue__ = (Long)leftNodeValue_;
                if ((state & 8) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    if (this.canDoManaged(leftNodeValue__)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 2;
                                this.state_ &= 0xFFFFFFF7;
                            }
                            finally {
                                lock.unlock();
                            }
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
                if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    if ((state & 0x20) != 0) {
                        PointerRight0Data s6_ = this.pointerRight0_cache;
                        while (s6_ != null) {
                            if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue__)) {
                                return this.doPointerRight(leftNodeValue__, rightNodeValue__, s6_.rightLib_);
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue__)) {
                        return this.pointerRight1Boundary6(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if (rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state & 0x80) != 0) {
                        PointerLeft0Data s8_ = this.pointerLeft0_cache;
                        while (s8_ != null) {
                            if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue__)) {
                                return this.doPointerLeft(leftNodeValue__, rightNodeValue__, s8_.leftLib_);
                            }
                            s8_ = s8_.next_;
                        }
                    }
                    if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue__)) {
                        return this.pointerLeft1Boundary7(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            if ((state & 0x1E00) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                if (LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    Node prev_;
                    LLVMManagedPointer rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    if ((state & 0x200) != 0) {
                        SameObjectLong0Data s10_ = this.sameObjectLong0_cache;
                        while (s10_ != null) {
                            if (s10_.sameObject_.accepts(leftNodeValue__.getObject()) && s10_.sameObject_.isSame(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                return this.doSameObjectLong(leftNodeValue__, rightNodeValue__, s10_.sameObject_);
                            }
                            s10_ = s10_.next_;
                        }
                    }
                    if ((state & 0x400) != 0) {
                        prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                        try {
                            if (((ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue__.getObject())).isSame(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                long l = this.doSameObjectLong(leftNodeValue__, rightNodeValue__, (ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue__.getObject()));
                                return l;
                            }
                        }
                        finally {
                            NodeUtil.popEncapsulatingNode((Node)prev_);
                        }
                    }
                    if ((state & 0x800) != 0) {
                        NotSameObject0Data s12_ = this.notSameObject0_cache;
                        while (s12_ != null) {
                            if (s12_.sameObject_.accepts(leftNodeValue__.getObject()) && s12_.leftLib_.accepts(leftNodeValue__) && s12_.rightLib_.accepts(rightNodeValue__) && !s12_.sameObject_.isSame(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                return this.doNotSameObject(leftNodeValue__, rightNodeValue__, s12_.sameObject_, s12_.leftLib_, s12_.rightLib_);
                            }
                            s12_ = s12_.next_;
                        }
                    }
                    if ((state & 0x1000) != 0) {
                        prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                        try {
                            if (!((ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue__.getObject())).isSame(leftNodeValue__.getObject(), rightNodeValue__.getObject())) {
                                long l = this.doNotSameObject(leftNodeValue__, rightNodeValue__, (ReferenceLibrary)REFERENCE_LIBRARY_.getUncached(leftNodeValue__.getObject()), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                                return l;
                            }
                        }
                        finally {
                            NodeUtil.popEncapsulatingNode((Node)prev_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        @Override
        public long executeLongWithTarget(long leftNodeValue, long rightNodeValue) {
            int state = this.state_;
            if ((state & 1) != 0) {
                return this.doLong(leftNodeValue, rightNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return (Long)this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        /*
         * Exception decompiling
         */
        private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                PointerRight0Data s6_ = this.pointerRight0_cache;
                PointerLeft0Data s8_ = this.pointerLeft0_cache;
                SameObjectLong0Data s10_ = this.sameObjectLong0_cache;
                NotSameObject0Data s12_ = this.notSameObject0_cache;
                if (!(s6_ != null && s6_.next_ != null || s8_ != null && s8_.next_ != null || s10_ != null && s10_.next_ != null || s12_ != null && s12_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticNode.LLVMI64SubNode create(LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI64SubNodeGen(leftNode, rightNode);
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
        private static final class NotSameObject0Data
        extends Node {
            @Node.Child
            NotSameObject0Data next_;
            @Node.Child
            ReferenceLibrary sameObject_;
            @Node.Child
            LLVMNativeLibrary leftLib_;
            @Node.Child
            LLVMNativeLibrary rightLib_;

            NotSameObject0Data(NotSameObject0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
        private static final class SameObjectLong0Data
        extends Node {
            @Node.Child
            SameObjectLong0Data next_;
            @Node.Child
            ReferenceLibrary sameObject_;

            SameObjectLong0Data(SameObjectLong0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
        private static final class PointerLeft0Data
        extends Node {
            @Node.Child
            PointerLeft0Data next_;
            @Node.Child
            LLVMNativeLibrary leftLib_;

            PointerLeft0Data(PointerLeft0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64SubNode.class)
        private static final class PointerRight0Data
        extends Node {
            @Node.Child
            PointerRight0Data next_;
            @Node.Child
            LLVMNativeLibrary rightLib_;

            PointerRight0Data(PointerRight0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI64ArithmeticNode.class)
    static final class LLVMI64ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMI64ArithmeticNode {
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node leftNode_;
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedLeftLong_node_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedLeft_node_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedRightLong_node_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedRight_node_;
        @Node.Child
        private PointerRight0Data pointerRight0_cache;
        @Node.Child
        private PointerLeft0Data pointerLeft0_cache;
        @Node.Child
        private Pointer0Data pointer0_cache;

        private LLVMI64ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = this.createCast(leftNode);
            this.rightNode_ = this.createCast(rightNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if ((state & 7) != 0 && rightNodeValue instanceof Long) {
                long rightNodeValue_ = (Long)rightNodeValue;
                if ((state & 1) != 0 && leftNodeValue instanceof Long) {
                    long leftNodeValue_ = (Long)leftNodeValue;
                    return this.doLong(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 6) != 0 && LLVMTypes.isManagedPointer(leftNodeValue)) {
                    LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                    if ((state & 2) != 0 && this.canDoManaged(rightNodeValue_)) {
                        try {
                            return this.doManagedLeftLong(leftNodeValue_, rightNodeValue_, this.managedLeftLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 1;
                                this.state_ &= 0xFFFFFFFD;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 4) != 0 && this.canDoManaged(rightNodeValue_)) {
                        return this.doManagedLeft(leftNodeValue_, rightNodeValue_, this.managedLeft_node_);
                    }
                }
            }
            if ((state & 0x78) != 0 && leftNodeValue instanceof Long) {
                LLVMPointer rightNodeValue_;
                long leftNodeValue_ = (Long)leftNodeValue;
                if ((state & 0x18) != 0 && LLVMTypes.isManagedPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                    if ((state & 8) != 0 && this.canDoManaged(leftNodeValue_)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, this.managedRightLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 2;
                                this.state_ &= 0xFFFFFFF7;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 0x10) != 0 && this.canDoManaged(leftNodeValue_)) {
                        return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, this.managedRight_node_);
                    }
                }
                if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asPointer(rightNodeValue);
                    if ((state & 0x20) != 0) {
                        PointerRight0Data s6_ = this.pointerRight0_cache;
                        while (s6_ != null) {
                            if (s6_.rightLib_.accepts(rightNodeValue_) && !this.canDoManaged(leftNodeValue_)) {
                                return this.doPointerRight(leftNodeValue_, rightNodeValue_, s6_.rightLib_);
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue_)) {
                        return this.pointerRight1Boundary(state, leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if ((state & 0x780) != 0 && LLVMTypes.isPointer(leftNodeValue)) {
                LLVMPointer leftNodeValue_ = LLVMTypes.asPointer(leftNodeValue);
                if ((state & 0x180) != 0 && rightNodeValue instanceof Long) {
                    long rightNodeValue_ = (Long)rightNodeValue;
                    if ((state & 0x80) != 0) {
                        PointerLeft0Data s8_ = this.pointerLeft0_cache;
                        while (s8_ != null) {
                            if (s8_.leftLib_.accepts(leftNodeValue_) && !this.canDoManaged(rightNodeValue_)) {
                                return this.doPointerLeft(leftNodeValue_, rightNodeValue_, s8_.leftLib_);
                            }
                            s8_ = s8_.next_;
                        }
                    }
                    if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue_)) {
                        return this.pointerLeft1Boundary(state, leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state & 0x600) != 0 && LLVMTypes.isPointer(rightNodeValue)) {
                    LLVMPointer rightNodeValue_ = LLVMTypes.asPointer(rightNodeValue);
                    if ((state & 0x200) != 0) {
                        Pointer0Data s10_ = this.pointer0_cache;
                        while (s10_ != null) {
                            if (s10_.leftLib_.accepts(leftNodeValue_) && s10_.rightLib_.accepts(rightNodeValue_)) {
                                return this.doPointer(leftNodeValue_, rightNodeValue_, s10_.leftLib_, s10_.rightLib_);
                            }
                            s10_ = s10_.next_;
                        }
                    }
                    if ((state & 0x400) != 0) {
                        return this.pointer1Boundary(state, leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerRight1Boundary(int state, long leftNodeValue_, LLVMPointer rightNodeValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerRight(leftNodeValue_, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue_));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerLeft1Boundary(int state, LLVMPointer leftNodeValue_, long rightNodeValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerLeft(leftNodeValue_, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue_));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointer1Boundary(int state, LLVMPointer leftNodeValue_, LLVMPointer rightNodeValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointer(leftNodeValue_, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue_), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue_));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x7FE) == 0 && state != 0) {
                return this.executeGeneric_long_long0(frameValue, state);
            }
            if ((state & 0x679) == 0 && state != 0) {
                return this.executeGeneric_long1(frameValue, state);
            }
            if ((state & 0x787) == 0 && state != 0) {
                return this.executeGeneric_long2(frameValue, state);
            }
            return this.executeGeneric_generic3(frameValue, state);
        }

        private Object executeGeneric_long_long0(VirtualFrame frameValue, int state) {
            long rightNodeValue_;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerLeft1Boundary0(int state, LLVMPointer leftNodeValue__, long rightNodeValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerLeft(leftNodeValue__, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_long1(VirtualFrame frameValue, int state) {
            LLVMPointer leftNodeValue__;
            long rightNodeValue_;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if ((state & 6) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                if ((state & 2) != 0 && this.canDoManaged(rightNodeValue_)) {
                    try {
                        return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, this.managedLeftLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 1;
                            this.state_ &= 0xFFFFFFFD;
                        }
                        finally {
                            lock.unlock();
                        }
                        return ex.getResult();
                    }
                }
                if ((state & 4) != 0 && this.canDoManaged(rightNodeValue_)) {
                    return this.doManagedLeft((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, this.managedLeft_node_);
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if ((state & 0x80) != 0) {
                    PointerLeft0Data s8_ = this.pointerLeft0_cache;
                    while (s8_ != null) {
                        if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue_)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue_, s8_.leftLib_);
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue_)) {
                    return this.pointerLeft1Boundary0(state, leftNodeValue__, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerRight1Boundary1(int state, long leftNodeValue_, LLVMPointer rightNodeValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerRight(leftNodeValue_, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_long2(VirtualFrame frameValue, int state) {
            LLVMPointer rightNodeValue__;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 0x18) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                if ((state & 8) != 0 && this.canDoManaged(leftNodeValue_)) {
                    try {
                        return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 2;
                            this.state_ &= 0xFFFFFFF7;
                        }
                        finally {
                            lock.unlock();
                        }
                        return ex.getResult();
                    }
                }
                if ((state & 0x10) != 0 && this.canDoManaged(leftNodeValue_)) {
                    return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, this.managedRight_node_);
                }
            }
            if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                if ((state & 0x20) != 0) {
                    PointerRight0Data s6_ = this.pointerRight0_cache;
                    while (s6_ != null) {
                        if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue_)) {
                            return this.doPointerRight(leftNodeValue_, rightNodeValue__, s6_.rightLib_);
                        }
                        s6_ = s6_.next_;
                    }
                }
                if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue_)) {
                    return this.pointerRight1Boundary1(state, leftNodeValue_, rightNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerRight1Boundary2(int state, long leftNodeValue__, LLVMPointer rightNodeValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerRight(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerLeft1Boundary3(int state, LLVMPointer leftNodeValue__, long rightNodeValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerLeft(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointer1Boundary4(int state, LLVMPointer leftNodeValue__, LLVMPointer rightNodeValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointer(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_generic3(VirtualFrame frameValue, int state) {
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 7) != 0 && rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                if ((state & 1) != 0 && leftNodeValue_ instanceof Long) {
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    return this.doLong(leftNodeValue__, rightNodeValue__);
                }
                if ((state & 6) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    if ((state & 2) != 0 && this.canDoManaged(rightNodeValue__)) {
                        try {
                            return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, this.managedLeftLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 1;
                                this.state_ &= 0xFFFFFFFD;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 4) != 0 && this.canDoManaged(rightNodeValue__)) {
                        return this.doManagedLeft(leftNodeValue__, rightNodeValue__, this.managedLeft_node_);
                    }
                }
            }
            if ((state & 0x78) != 0 && leftNodeValue_ instanceof Long) {
                LLVMPointer rightNodeValue__;
                long leftNodeValue__ = (Long)leftNodeValue_;
                if ((state & 0x18) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    if ((state & 8) != 0 && this.canDoManaged(leftNodeValue__)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 2;
                                this.state_ &= 0xFFFFFFF7;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 0x10) != 0 && this.canDoManaged(leftNodeValue__)) {
                        return this.doManagedRight(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, this.managedRight_node_);
                    }
                }
                if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    if ((state & 0x20) != 0) {
                        PointerRight0Data s6_ = this.pointerRight0_cache;
                        while (s6_ != null) {
                            if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue__)) {
                                return this.doPointerRight(leftNodeValue__, rightNodeValue__, s6_.rightLib_);
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue__)) {
                        return this.pointerRight1Boundary2(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            if ((state & 0x780) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if ((state & 0x180) != 0 && rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state & 0x80) != 0) {
                        PointerLeft0Data s8_ = this.pointerLeft0_cache;
                        while (s8_ != null) {
                            if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue__)) {
                                return this.doPointerLeft(leftNodeValue__, rightNodeValue__, s8_.leftLib_);
                            }
                            s8_ = s8_.next_;
                        }
                    }
                    if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue__)) {
                        return this.pointerLeft1Boundary3(state, leftNodeValue__, rightNodeValue__);
                    }
                }
                if ((state & 0x600) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    LLVMPointer rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    if ((state & 0x200) != 0) {
                        Pointer0Data s10_ = this.pointer0_cache;
                        while (s10_ != null) {
                            if (s10_.leftLib_.accepts(leftNodeValue__) && s10_.rightLib_.accepts(rightNodeValue__)) {
                                return this.doPointer(leftNodeValue__, rightNodeValue__, s10_.leftLib_, s10_.rightLib_);
                            }
                            s10_ = s10_.next_;
                        }
                    }
                    if ((state & 0x400) != 0) {
                        return this.pointer1Boundary4(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 0x14) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state & 0x7EA) == 0 && (state & 0x7EB) != 0) {
                return this.executeI64_long_long4(frameValue, state);
            }
            if ((state & 0x669) == 0 && (state & 0x7EB) != 0) {
                return this.executeI64_long5(frameValue, state);
            }
            if ((state & 0x783) == 0 && (state & 0x7EB) != 0) {
                return this.executeI64_long6(frameValue, state);
            }
            return this.executeI64_generic7(frameValue, state);
        }

        private long executeI64_long_long4(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            long rightNodeValue_;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            assert ((state & 1) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerLeft1Boundary5(int state, LLVMPointer leftNodeValue__, long rightNodeValue_) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerLeft(leftNodeValue__, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private long executeI64_long5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            LLVMPointer leftNodeValue__;
            long rightNodeValue_;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            if ((state & 2) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                if (this.canDoManaged(rightNodeValue_)) {
                    try {
                        return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, this.managedLeftLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 1;
                            this.state_ &= 0xFFFFFFFD;
                        }
                        finally {
                            lock.unlock();
                        }
                        return LLVMTypesGen.expectLong(ex.getResult());
                    }
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if ((state & 0x80) != 0) {
                    PointerLeft0Data s8_ = this.pointerLeft0_cache;
                    while (s8_ != null) {
                        if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue_)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue_, s8_.leftLib_);
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue_)) {
                    return this.pointerLeft1Boundary5(state, leftNodeValue__, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerRight1Boundary6(int state, long leftNodeValue_, LLVMPointer rightNodeValue__) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerRight(leftNodeValue_, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private long executeI64_long6(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            LLVMPointer rightNodeValue__;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 8) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                if (this.canDoManaged(leftNodeValue_)) {
                    try {
                        return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 2;
                            this.state_ &= 0xFFFFFFF7;
                        }
                        finally {
                            lock.unlock();
                        }
                        return LLVMTypesGen.expectLong(ex.getResult());
                    }
                }
            }
            if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                if ((state & 0x20) != 0) {
                    PointerRight0Data s6_ = this.pointerRight0_cache;
                    while (s6_ != null) {
                        if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue_)) {
                            return this.doPointerRight(leftNodeValue_, rightNodeValue__, s6_.rightLib_);
                        }
                        s6_ = s6_.next_;
                    }
                }
                if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue_)) {
                    return this.pointerRight1Boundary6(state, leftNodeValue_, rightNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerRight1Boundary7(int state, long leftNodeValue__, LLVMPointer rightNodeValue__) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerRight(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerLeft1Boundary8(int state, LLVMPointer leftNodeValue__, long rightNodeValue__) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerLeft(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointer1Boundary9(int state, LLVMPointer leftNodeValue__, LLVMPointer rightNodeValue__) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointer(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private long executeI64_generic7(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 3) != 0 && rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                if ((state & 1) != 0 && leftNodeValue_ instanceof Long) {
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    return this.doLong(leftNodeValue__, rightNodeValue__);
                }
                if ((state & 2) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    if (this.canDoManaged(rightNodeValue__)) {
                        try {
                            return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, this.managedLeftLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 1;
                                this.state_ &= 0xFFFFFFFD;
                            }
                            finally {
                                lock.unlock();
                            }
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
            }
            if ((state & 0x68) != 0 && leftNodeValue_ instanceof Long) {
                LLVMPointer rightNodeValue__;
                long leftNodeValue__ = (Long)leftNodeValue_;
                if ((state & 8) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    if (this.canDoManaged(leftNodeValue__)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 2;
                                this.state_ &= 0xFFFFFFF7;
                            }
                            finally {
                                lock.unlock();
                            }
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
                if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    if ((state & 0x20) != 0) {
                        PointerRight0Data s6_ = this.pointerRight0_cache;
                        while (s6_ != null) {
                            if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue__)) {
                                return this.doPointerRight(leftNodeValue__, rightNodeValue__, s6_.rightLib_);
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue__)) {
                        return this.pointerRight1Boundary7(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            if ((state & 0x780) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if ((state & 0x180) != 0 && rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state & 0x80) != 0) {
                        PointerLeft0Data s8_ = this.pointerLeft0_cache;
                        while (s8_ != null) {
                            if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue__)) {
                                return this.doPointerLeft(leftNodeValue__, rightNodeValue__, s8_.leftLib_);
                            }
                            s8_ = s8_.next_;
                        }
                    }
                    if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue__)) {
                        return this.pointerLeft1Boundary8(state, leftNodeValue__, rightNodeValue__);
                    }
                }
                if ((state & 0x600) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    LLVMPointer rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    if ((state & 0x200) != 0) {
                        Pointer0Data s10_ = this.pointer0_cache;
                        while (s10_ != null) {
                            if (s10_.leftLib_.accepts(leftNodeValue__) && s10_.rightLib_.accepts(rightNodeValue__)) {
                                return this.doPointer(leftNodeValue__, rightNodeValue__, s10_.leftLib_, s10_.rightLib_);
                            }
                            s10_ = s10_.next_;
                        }
                    }
                    if ((state & 0x400) != 0) {
                        return this.pointer1Boundary9(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        @Override
        public long executeLongWithTarget(long leftNodeValue, long rightNodeValue) {
            int state = this.state_;
            if ((state & 1) != 0) {
                return this.doLong(leftNodeValue, rightNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return (Long)this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        /*
         * Exception decompiling
         */
        private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                PointerRight0Data s6_ = this.pointerRight0_cache;
                PointerLeft0Data s8_ = this.pointerLeft0_cache;
                Pointer0Data s10_ = this.pointer0_cache;
                if (!(s6_ != null && s6_.next_ != null || s8_ != null && s8_.next_ != null || s10_ != null && s10_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticNode.LLVMI64ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI64ArithmeticNodeGen(op, leftNode, rightNode);
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64ArithmeticNode.class)
        private static final class Pointer0Data
        extends Node {
            @Node.Child
            Pointer0Data next_;
            @Node.Child
            LLVMNativeLibrary leftLib_;
            @Node.Child
            LLVMNativeLibrary rightLib_;

            Pointer0Data(Pointer0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64ArithmeticNode.class)
        private static final class PointerLeft0Data
        extends Node {
            @Node.Child
            PointerLeft0Data next_;
            @Node.Child
            LLVMNativeLibrary leftLib_;

            PointerLeft0Data(PointerLeft0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMI64ArithmeticNode.class)
        private static final class PointerRight0Data
        extends Node {
            @Node.Child
            PointerRight0Data next_;
            @Node.Child
            LLVMNativeLibrary rightLib_;

            PointerRight0Data(PointerRight0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode.class)
    public static final class LLVMAbstractI64ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode {
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node leftNode_;
        @Node.Child
        private LLVMArithmeticNode.PointerToI64Node rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedLeftLong_node_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedLeft_node_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedRightLong_node_;
        @Node.Child
        private LLVMArithmeticNode.ManagedArithmeticNode managedRight_node_;
        @Node.Child
        private PointerRight0Data pointerRight0_cache;
        @Node.Child
        private PointerLeft0Data pointerLeft0_cache;

        private LLVMAbstractI64ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = this.createCast(leftNode);
            this.rightNode_ = this.createCast(rightNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if ((state & 7) != 0 && rightNodeValue instanceof Long) {
                long rightNodeValue_ = (Long)rightNodeValue;
                if ((state & 1) != 0 && leftNodeValue instanceof Long) {
                    long leftNodeValue_ = (Long)leftNodeValue;
                    return this.doLong(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 6) != 0 && LLVMTypes.isManagedPointer(leftNodeValue)) {
                    LLVMManagedPointer leftNodeValue_ = LLVMTypes.asManagedPointer(leftNodeValue);
                    if ((state & 2) != 0 && this.canDoManaged(rightNodeValue_)) {
                        try {
                            return this.doManagedLeftLong(leftNodeValue_, rightNodeValue_, this.managedLeftLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 1;
                                this.state_ &= 0xFFFFFFFD;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 4) != 0 && this.canDoManaged(rightNodeValue_)) {
                        return this.doManagedLeft(leftNodeValue_, rightNodeValue_, this.managedLeft_node_);
                    }
                }
            }
            if ((state & 0x78) != 0 && leftNodeValue instanceof Long) {
                LLVMPointer rightNodeValue_;
                long leftNodeValue_ = (Long)leftNodeValue;
                if ((state & 0x18) != 0 && LLVMTypes.isManagedPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asManagedPointer(rightNodeValue);
                    if ((state & 8) != 0 && this.canDoManaged(leftNodeValue_)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, this.managedRightLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 2;
                                this.state_ &= 0xFFFFFFF7;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 0x10) != 0 && this.canDoManaged(leftNodeValue_)) {
                        return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue_, this.managedRight_node_);
                    }
                }
                if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue)) {
                    rightNodeValue_ = LLVMTypes.asPointer(rightNodeValue);
                    if ((state & 0x20) != 0) {
                        PointerRight0Data s6_ = this.pointerRight0_cache;
                        while (s6_ != null) {
                            if (s6_.rightLib_.accepts(rightNodeValue_) && !this.canDoManaged(leftNodeValue_)) {
                                return this.doPointerRight(leftNodeValue_, rightNodeValue_, s6_.rightLib_);
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue_)) {
                        return this.pointerRight1Boundary(state, leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue)) {
                LLVMPointer leftNodeValue_ = LLVMTypes.asPointer(leftNodeValue);
                if (rightNodeValue instanceof Long) {
                    long rightNodeValue_ = (Long)rightNodeValue;
                    if ((state & 0x80) != 0) {
                        PointerLeft0Data s8_ = this.pointerLeft0_cache;
                        while (s8_ != null) {
                            if (s8_.leftLib_.accepts(leftNodeValue_) && !this.canDoManaged(rightNodeValue_)) {
                                return this.doPointerLeft(leftNodeValue_, rightNodeValue_, s8_.leftLib_);
                            }
                            s8_ = s8_.next_;
                        }
                    }
                    if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue_)) {
                        return this.pointerLeft1Boundary(state, leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerRight1Boundary(int state, long leftNodeValue_, LLVMPointer rightNodeValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerRight(leftNodeValue_, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue_));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerLeft1Boundary(int state, LLVMPointer leftNodeValue_, long rightNodeValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerLeft(leftNodeValue_, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue_));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x1FE) == 0 && state != 0) {
                return this.executeGeneric_long_long0(frameValue, state);
            }
            if ((state & 0x79) == 0 && state != 0) {
                return this.executeGeneric_long1(frameValue, state);
            }
            if ((state & 0x187) == 0 && state != 0) {
                return this.executeGeneric_long2(frameValue, state);
            }
            return this.executeGeneric_generic3(frameValue, state);
        }

        private Object executeGeneric_long_long0(VirtualFrame frameValue, int state) {
            long rightNodeValue_;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerLeft1Boundary0(int state, LLVMPointer leftNodeValue__, long rightNodeValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerLeft(leftNodeValue__, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_long1(VirtualFrame frameValue, int state) {
            LLVMPointer leftNodeValue__;
            long rightNodeValue_;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if ((state & 6) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                if ((state & 2) != 0 && this.canDoManaged(rightNodeValue_)) {
                    try {
                        return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, this.managedLeftLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 1;
                            this.state_ &= 0xFFFFFFFD;
                        }
                        finally {
                            lock.unlock();
                        }
                        return ex.getResult();
                    }
                }
                if ((state & 4) != 0 && this.canDoManaged(rightNodeValue_)) {
                    return this.doManagedLeft((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, this.managedLeft_node_);
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if ((state & 0x80) != 0) {
                    PointerLeft0Data s8_ = this.pointerLeft0_cache;
                    while (s8_ != null) {
                        if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue_)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue_, s8_.leftLib_);
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue_)) {
                    return this.pointerLeft1Boundary0(state, leftNodeValue__, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerRight1Boundary1(int state, long leftNodeValue_, LLVMPointer rightNodeValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerRight(leftNodeValue_, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_long2(VirtualFrame frameValue, int state) {
            LLVMPointer rightNodeValue__;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 0x18) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                if ((state & 8) != 0 && this.canDoManaged(leftNodeValue_)) {
                    try {
                        return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 2;
                            this.state_ &= 0xFFFFFFF7;
                        }
                        finally {
                            lock.unlock();
                        }
                        return ex.getResult();
                    }
                }
                if ((state & 0x10) != 0 && this.canDoManaged(leftNodeValue_)) {
                    return this.doManagedRight(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, this.managedRight_node_);
                }
            }
            if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                if ((state & 0x20) != 0) {
                    PointerRight0Data s6_ = this.pointerRight0_cache;
                    while (s6_ != null) {
                        if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue_)) {
                            return this.doPointerRight(leftNodeValue_, rightNodeValue__, s6_.rightLib_);
                        }
                        s6_ = s6_.next_;
                    }
                }
                if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue_)) {
                    return this.pointerRight1Boundary1(state, leftNodeValue_, rightNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerRight1Boundary2(int state, long leftNodeValue__, LLVMPointer rightNodeValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerRight(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object pointerLeft1Boundary3(int state, LLVMPointer leftNodeValue__, long rightNodeValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.doPointerLeft(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_generic3(VirtualFrame frameValue, int state) {
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 7) != 0 && rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                if ((state & 1) != 0 && leftNodeValue_ instanceof Long) {
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    return this.doLong(leftNodeValue__, rightNodeValue__);
                }
                if ((state & 6) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    if ((state & 2) != 0 && this.canDoManaged(rightNodeValue__)) {
                        try {
                            return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, this.managedLeftLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 1;
                                this.state_ &= 0xFFFFFFFD;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 4) != 0 && this.canDoManaged(rightNodeValue__)) {
                        return this.doManagedLeft(leftNodeValue__, rightNodeValue__, this.managedLeft_node_);
                    }
                }
            }
            if ((state & 0x78) != 0 && leftNodeValue_ instanceof Long) {
                LLVMPointer rightNodeValue__;
                long leftNodeValue__ = (Long)leftNodeValue_;
                if ((state & 0x18) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    if ((state & 8) != 0 && this.canDoManaged(leftNodeValue__)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 2;
                                this.state_ &= 0xFFFFFFF7;
                            }
                            finally {
                                lock.unlock();
                            }
                            return ex.getResult();
                        }
                    }
                    if ((state & 0x10) != 0 && this.canDoManaged(leftNodeValue__)) {
                        return this.doManagedRight(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, this.managedRight_node_);
                    }
                }
                if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    if ((state & 0x20) != 0) {
                        PointerRight0Data s6_ = this.pointerRight0_cache;
                        while (s6_ != null) {
                            if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue__)) {
                                return this.doPointerRight(leftNodeValue__, rightNodeValue__, s6_.rightLib_);
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue__)) {
                        return this.pointerRight1Boundary2(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if (rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state & 0x80) != 0) {
                        PointerLeft0Data s8_ = this.pointerLeft0_cache;
                        while (s8_ != null) {
                            if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue__)) {
                                return this.doPointerLeft(leftNodeValue__, rightNodeValue__, s8_.leftLib_);
                            }
                            s8_ = s8_.next_;
                        }
                    }
                    if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue__)) {
                        return this.pointerLeft1Boundary3(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 0x14) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state & 0x1EA) == 0 && (state & 0x1EB) != 0) {
                return this.executeI64_long_long4(frameValue, state);
            }
            if ((state & 0x69) == 0 && (state & 0x1EB) != 0) {
                return this.executeI64_long5(frameValue, state);
            }
            if ((state & 0x183) == 0 && (state & 0x1EB) != 0) {
                return this.executeI64_long6(frameValue, state);
            }
            return this.executeI64_generic7(frameValue, state);
        }

        private long executeI64_long_long4(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            long rightNodeValue_;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            assert ((state & 1) != 0);
            return this.doLong(leftNodeValue_, rightNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerLeft1Boundary4(int state, LLVMPointer leftNodeValue__, long rightNodeValue_) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerLeft(leftNodeValue__, rightNodeValue_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private long executeI64_long5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            LLVMPointer leftNodeValue__;
            long rightNodeValue_;
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            try {
                rightNodeValue_ = this.rightNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
            }
            if ((state & 2) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                if (this.canDoManaged(rightNodeValue_)) {
                    try {
                        return this.doManagedLeftLong((LLVMManagedPointer)leftNodeValue__, rightNodeValue_, this.managedLeftLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 1;
                            this.state_ &= 0xFFFFFFFD;
                        }
                        finally {
                            lock.unlock();
                        }
                        return LLVMTypesGen.expectLong(ex.getResult());
                    }
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if ((state & 0x80) != 0) {
                    PointerLeft0Data s8_ = this.pointerLeft0_cache;
                    while (s8_ != null) {
                        if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue_)) {
                            return this.doPointerLeft(leftNodeValue__, rightNodeValue_, s8_.leftLib_);
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue_)) {
                    return this.pointerLeft1Boundary4(state, leftNodeValue__, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerRight1Boundary5(int state, long leftNodeValue_, LLVMPointer rightNodeValue__) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerRight(leftNodeValue_, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private long executeI64_long6(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            LLVMPointer rightNodeValue__;
            long leftNodeValue_;
            try {
                leftNodeValue_ = this.leftNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
            }
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 8) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                if (this.canDoManaged(leftNodeValue_)) {
                    try {
                        return this.doManagedRightLong(leftNodeValue_, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 2;
                            this.state_ &= 0xFFFFFFF7;
                        }
                        finally {
                            lock.unlock();
                        }
                        return LLVMTypesGen.expectLong(ex.getResult());
                    }
                }
            }
            if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                if ((state & 0x20) != 0) {
                    PointerRight0Data s6_ = this.pointerRight0_cache;
                    while (s6_ != null) {
                        if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue_)) {
                            return this.doPointerRight(leftNodeValue_, rightNodeValue__, s6_.rightLib_);
                        }
                        s6_ = s6_.next_;
                    }
                }
                if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue_)) {
                    return this.pointerRight1Boundary5(state, leftNodeValue_, rightNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerRight1Boundary6(int state, long leftNodeValue__, LLVMPointer rightNodeValue__) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerRight(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)rightNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long pointerLeft1Boundary7(int state, LLVMPointer leftNodeValue__, long rightNodeValue__) throws UnexpectedResultException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.doPointerLeft(leftNodeValue__, rightNodeValue__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)leftNodeValue__));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private long executeI64_generic7(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
            Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
            if ((state & 3) != 0 && rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                if ((state & 1) != 0 && leftNodeValue_ instanceof Long) {
                    long leftNodeValue__ = (Long)leftNodeValue_;
                    return this.doLong(leftNodeValue__, rightNodeValue__);
                }
                if ((state & 2) != 0 && LLVMTypes.isManagedPointer(leftNodeValue_)) {
                    LLVMManagedPointer leftNodeValue__ = LLVMTypes.asManagedPointer(leftNodeValue_);
                    if (this.canDoManaged(rightNodeValue__)) {
                        try {
                            return this.doManagedLeftLong(leftNodeValue__, rightNodeValue__, this.managedLeftLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 1;
                                this.state_ &= 0xFFFFFFFD;
                            }
                            finally {
                                lock.unlock();
                            }
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
            }
            if ((state & 0x68) != 0 && leftNodeValue_ instanceof Long) {
                LLVMPointer rightNodeValue__;
                long leftNodeValue__ = (Long)leftNodeValue_;
                if ((state & 8) != 0 && LLVMTypes.isManagedPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asManagedPointer(rightNodeValue_);
                    if (this.canDoManaged(leftNodeValue__)) {
                        try {
                            return this.doManagedRightLong(leftNodeValue__, (LLVMManagedPointer)rightNodeValue__, this.managedRightLong_node_);
                        }
                        catch (UnexpectedResultException ex) {
                            Lock lock = this.getLock();
                            lock.lock();
                            try {
                                this.exclude_ |= 2;
                                this.state_ &= 0xFFFFFFF7;
                            }
                            finally {
                                lock.unlock();
                            }
                            return LLVMTypesGen.expectLong(ex.getResult());
                        }
                    }
                }
                if ((state & 0x60) != 0 && LLVMTypes.isPointer(rightNodeValue_)) {
                    rightNodeValue__ = LLVMTypes.asPointer(rightNodeValue_);
                    if ((state & 0x20) != 0) {
                        PointerRight0Data s6_ = this.pointerRight0_cache;
                        while (s6_ != null) {
                            if (s6_.rightLib_.accepts(rightNodeValue__) && !this.canDoManaged(leftNodeValue__)) {
                                return this.doPointerRight(leftNodeValue__, rightNodeValue__, s6_.rightLib_);
                            }
                            s6_ = s6_.next_;
                        }
                    }
                    if ((state & 0x40) != 0 && !this.canDoManaged(leftNodeValue__)) {
                        return this.pointerRight1Boundary6(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            if ((state & 0x180) != 0 && LLVMTypes.isPointer(leftNodeValue_)) {
                LLVMPointer leftNodeValue__ = LLVMTypes.asPointer(leftNodeValue_);
                if (rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (Long)rightNodeValue_;
                    if ((state & 0x80) != 0) {
                        PointerLeft0Data s8_ = this.pointerLeft0_cache;
                        while (s8_ != null) {
                            if (s8_.leftLib_.accepts(leftNodeValue__) && !this.canDoManaged(rightNodeValue__)) {
                                return this.doPointerLeft(leftNodeValue__, rightNodeValue__, s8_.leftLib_);
                            }
                            s8_ = s8_.next_;
                        }
                    }
                    if ((state & 0x100) != 0 && !this.canDoManaged(rightNodeValue__)) {
                        return this.pointerLeft1Boundary7(state, leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
        }

        @Override
        public long executeLongWithTarget(long leftNodeValue, long rightNodeValue) {
            int state = this.state_;
            if ((state & 1) != 0) {
                return this.doLong(leftNodeValue, rightNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return (Long)this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        /*
         * Exception decompiling
         */
        private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                PointerRight0Data s6_ = this.pointerRight0_cache;
                PointerLeft0Data s8_ = this.pointerLeft0_cache;
                if (!(s6_ != null && s6_.next_ != null || s8_ != null && s8_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMAbstractI64ArithmeticNodeGen(op, leftNode, rightNode);
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode.class)
        private static final class PointerLeft0Data
        extends Node {
            @Node.Child
            PointerLeft0Data next_;
            @Node.Child
            LLVMNativeLibrary leftLib_;

            PointerLeft0Data(PointerLeft0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode.class)
        private static final class PointerRight0Data
        extends Node {
            @Node.Child
            PointerRight0Data next_;
            @Node.Child
            LLVMNativeLibrary rightLib_;

            PointerRight0Data(PointerRight0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.PointerToI64Node.class)
    public static final class PointerToI64NodeGen
    extends LLVMArithmeticNode.PointerToI64Node {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private Pointer0Data pointer0_cache;
        @Node.Child
        private Managed0Data managed0_cache;
        @Node.Child
        private Generic0Data generic0_cache;

        private PointerToI64NodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x7E) == 0 && state != 0) {
                return this.executeGeneric_long0(frameValue, state);
            }
            return this.executeGeneric_generic1(frameValue, state);
        }

        private Object executeGeneric_long0(VirtualFrame frameValue, int state) {
            long child0Value_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doLong(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object generic1Boundary(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Object object = this.doGeneric(child0Value_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(child0Value_));
                return object;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_generic1(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Long) {
                long child0Value__ = (Long)child0Value_;
                return this.doLong(child0Value__);
            }
            if ((state & 0x7E) != 0) {
                Node prev_;
                block33: {
                    if ((state & 2) != 0) {
                        Pointer0Data s2_ = this.pointer0_cache;
                        while (s2_ != null) {
                            if (s2_.lib_.accepts(child0Value_) && s2_.lib_.isPointer(child0Value_)) {
                                try {
                                    return this.doPointer(child0Value_, s2_.lib_);
                                }
                                catch (UnsupportedMessageException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    Lock lock = this.getLock();
                                    lock.lock();
                                    try {
                                        this.exclude_ |= 6;
                                        this.state_ &= 0xFFFFFFF9;
                                        this.pointer0_cache = null;
                                    }
                                    finally {
                                        lock.unlock();
                                    }
                                    return this.executeAndSpecialize(child0Value_);
                                }
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 4) != 0) {
                        prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                        try {
                            if (!((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(child0Value_)).isPointer(child0Value_)) break block33;
                            try {
                                Long ex = this.doPointer(child0Value_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(child0Value_));
                                return ex;
                            }
                            catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                Lock lock = this.getLock();
                                lock.lock();
                                try {
                                    this.exclude_ |= 4;
                                    this.state_ &= 0xFFFFFFFB;
                                }
                                finally {
                                    lock.unlock();
                                }
                                Object object = this.executeAndSpecialize(child0Value_);
                                NodeUtil.popEncapsulatingNode((Node)prev_);
                                return object;
                            }
                        }
                        finally {
                            NodeUtil.popEncapsulatingNode((Node)prev_);
                        }
                    }
                }
                if ((state & 8) != 0) {
                    Managed0Data s4_ = this.managed0_cache;
                    while (s4_ != null) {
                        if (s4_.lib_.accepts(child0Value_) && !s4_.lib_.isPointer(child0Value_)) {
                            return this.doManaged(child0Value_, s4_.lib_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state & 0x10) != 0) {
                    prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        if (!((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(child0Value_)).isPointer(child0Value_)) {
                            Object object = this.doManaged(child0Value_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(child0Value_));
                            return object;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                if ((state & 0x20) != 0) {
                    Generic0Data s6_ = this.generic0_cache;
                    while (s6_ != null) {
                        if (s6_.lib_.accepts(child0Value_)) {
                            return this.doGeneric(child0Value_, s6_.lib_);
                        }
                        s6_ = s6_.next_;
                    }
                }
                if ((state & 0x40) != 0) {
                    return this.generic1Boundary(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 0x78) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state & 6) == 0 && (state & 7) != 0) {
                return this.executeI64_long2(frameValue, state);
            }
            return this.executeI64_generic3(frameValue, state);
        }

        private long executeI64_long2(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            long child0Value_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state & 1) != 0);
            return this.doLong(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private long executeI64_generic3(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            Object child0Value_;
            block21: {
                child0Value_ = this.child0_.executeGeneric(frameValue);
                if ((state & 1) != 0 && child0Value_ instanceof Long) {
                    long child0Value__ = (Long)child0Value_;
                    return this.doLong(child0Value__);
                }
                if ((state & 6) != 0) {
                    if ((state & 2) != 0) {
                        Pointer0Data s2_ = this.pointer0_cache;
                        while (s2_ != null) {
                            if (s2_.lib_.accepts(child0Value_) && s2_.lib_.isPointer(child0Value_)) {
                                try {
                                    return this.doPointer(child0Value_, s2_.lib_);
                                }
                                catch (UnsupportedMessageException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    Lock lock = this.getLock();
                                    lock.lock();
                                    try {
                                        this.exclude_ |= 6;
                                        this.state_ &= 0xFFFFFFF9;
                                        this.pointer0_cache = null;
                                    }
                                    finally {
                                        lock.unlock();
                                    }
                                    return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_));
                                }
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 4) != 0) {
                        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                        try {
                            if (!((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(child0Value_)).isPointer(child0Value_)) break block21;
                            try {
                                long ex = this.doPointer(child0Value_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(child0Value_));
                                return ex;
                            }
                            catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                Lock lock = this.getLock();
                                lock.lock();
                                try {
                                    this.exclude_ |= 4;
                                    this.state_ &= 0xFFFFFFFB;
                                }
                                finally {
                                    lock.unlock();
                                }
                                long l = LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_));
                                NodeUtil.popEncapsulatingNode((Node)prev_);
                                return l;
                            }
                        }
                        finally {
                            NodeUtil.popEncapsulatingNode((Node)prev_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_));
        }

        /*
         * Exception decompiling
         */
        private Object executeAndSpecialize(Object child0Value) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                Pointer0Data s2_ = this.pointer0_cache;
                Managed0Data s4_ = this.managed0_cache;
                Generic0Data s6_ = this.generic0_cache;
                if (!(s2_ != null && s2_.next_ != null || s4_ != null && s4_.next_ != null || s6_ != null && s6_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticNode.PointerToI64Node create(LLVMExpressionNode child0) {
            return new PointerToI64NodeGen(child0);
        }

        @GeneratedBy(value=LLVMArithmeticNode.PointerToI64Node.class)
        private static final class Generic0Data
        extends Node {
            @Node.Child
            Generic0Data next_;
            @Node.Child
            LLVMNativeLibrary lib_;

            Generic0Data(Generic0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.PointerToI64Node.class)
        private static final class Managed0Data
        extends Node {
            @Node.Child
            Managed0Data next_;
            @Node.Child
            LLVMNativeLibrary lib_;

            Managed0Data(Managed0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMArithmeticNode.PointerToI64Node.class)
        private static final class Pointer0Data
        extends Node {
            @Node.Child
            Pointer0Data next_;
            @Node.Child
            LLVMNativeLibrary lib_;

            Pointer0Data(Pointer0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI32ArithmeticNode.class)
    public static final class LLVMI32ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMI32ArithmeticNode {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI32ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (state != 0 && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (Integer)rightNodeValue;
                    return this.doInt(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int rightNodeValue_;
            int leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doInt(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int rightNodeValue_;
            int leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doInt(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private int executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (Integer)rightNodeValue;
                    this.state_ = state |= 1;
                    return this.doInt(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMArithmeticNode.LLVMI32ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI32ArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI16ArithmeticNode.class)
    public static final class LLVMI16ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMI16ArithmeticNode {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI16ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (state != 0 && leftNodeValue instanceof Short) {
                short leftNodeValue_ = (Short)leftNodeValue;
                if (rightNodeValue instanceof Short) {
                    short rightNodeValue_ = (Short)rightNodeValue;
                    return this.doShort(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            short rightNodeValue_;
            short leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doShort(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            short rightNodeValue_;
            short leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doShort(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private short executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (leftNodeValue instanceof Short) {
                short leftNodeValue_ = (Short)leftNodeValue;
                if (rightNodeValue instanceof Short) {
                    short rightNodeValue_ = (Short)rightNodeValue;
                    this.state_ = state |= 1;
                    return this.doShort(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMArithmeticNode.LLVMI16ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI16ArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI8ArithmeticNode.class)
    public static final class LLVMI8ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMI8ArithmeticNode {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI8ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (state != 0 && leftNodeValue instanceof Byte) {
                byte leftNodeValue_ = (Byte)leftNodeValue;
                if (rightNodeValue instanceof Byte) {
                    byte rightNodeValue_ = (Byte)rightNodeValue;
                    return this.doByte(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte rightNodeValue_;
            byte leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doByte(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            byte rightNodeValue_;
            byte leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doByte(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private byte executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (leftNodeValue instanceof Byte) {
                byte leftNodeValue_ = (Byte)leftNodeValue;
                if (rightNodeValue instanceof Byte) {
                    byte rightNodeValue_ = (Byte)rightNodeValue;
                    this.state_ = state |= 1;
                    return this.doByte(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMArithmeticNode.LLVMI8ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI8ArithmeticNodeGen(op, leftNode, rightNode);
        }
    }

    @GeneratedBy(value=LLVMArithmeticNode.LLVMI1ArithmeticNode.class)
    public static final class LLVMI1ArithmeticNodeGen
    extends LLVMArithmeticNode.LLVMI1ArithmeticNode {
        @Node.Child
        private LLVMExpressionNode leftNode_;
        @Node.Child
        private LLVMExpressionNode rightNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI1ArithmeticNodeGen(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            super(op);
            this.leftNode_ = leftNode;
            this.rightNode_ = rightNode;
        }

        @Override
        public Object executeWithTarget(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (state != 0 && leftNodeValue instanceof Boolean) {
                boolean leftNodeValue_ = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_ = (Boolean)rightNodeValue;
                    return this.doBoolean(leftNodeValue_, rightNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            boolean rightNodeValue_;
            boolean leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doBoolean(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            boolean rightNodeValue_;
            boolean leftNodeValue_;
            int state = this.state_;
            try {
                leftNodeValue_ = this.leftNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
            }
            try {
                rightNodeValue_ = this.rightNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doBoolean(leftNodeValue_, rightNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
        }

        private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
            int state = this.state_;
            if (leftNodeValue instanceof Boolean) {
                boolean leftNodeValue_ = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_ = (Boolean)rightNodeValue;
                    this.state_ = state |= 1;
                    return this.doBoolean(leftNodeValue_, rightNodeValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode_, this.rightNode_}, new Object[]{leftNodeValue, rightNodeValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMArithmeticNode.LLVMI1ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode leftNode, LLVMExpressionNode rightNode) {
            return new LLVMI1ArithmeticNodeGen(op, leftNode, rightNode);
        }
    }
}

