/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreNodeCommon;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreVectorNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@NodeField(name="vectorLength", type=int.class)
public abstract class LLVMStoreVectorNode
extends LLVMStoreNodeCommon {
    public abstract int getVectorLength();

    protected abstract void executeManaged(LLVMManagedPointer var1, Object var2);

    @ExplodeLoop
    @Specialization(guards={"!isAutoDerefHandle(address)"})
    protected void writeVector(LLVMNativePointer address, LLVMDoubleVector vector) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = this.getLLVMMemoryCached();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putDouble(currentPtr, vector.getValue(i));
            currentPtr += 8L;
        }
    }

    LLVMStoreVectorNode createRecursive() {
        return LLVMStoreVectorNodeGen.create(null, null, this.getVectorLength());
    }

    @Specialization(guards={"isAutoDerefHandle(address)"})
    protected void writeVectorDerefHandle(LLVMNativePointer address, Object value, @Cached(value="createRecursive()") LLVMStoreVectorNode store) {
        store.executeManaged(this.getDerefHandleGetReceiverNode().execute(address), value);
    }

    @ExplodeLoop
    @Specialization(guards={"!isAutoDerefHandle(address)"})
    protected void writeVector(LLVMNativePointer address, LLVMFloatVector vector) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = this.getLLVMMemoryCached();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putFloat(currentPtr, vector.getValue(i));
            currentPtr += 4L;
        }
    }

    @ExplodeLoop
    @Specialization(guards={"!isAutoDerefHandle(address)"})
    protected void writeVector(LLVMNativePointer address, LLVMI16Vector vector) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = this.getLLVMMemoryCached();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putI16(currentPtr, vector.getValue(i));
            currentPtr += 2L;
        }
    }

    @ExplodeLoop
    @Specialization(guards={"!isAutoDerefHandle(address)"})
    protected void writeVector(LLVMNativePointer address, LLVMI1Vector vector) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = this.getLLVMMemoryCached();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putI1(currentPtr, vector.getValue(i));
            ++currentPtr;
        }
    }

    @ExplodeLoop
    @Specialization(guards={"!isAutoDerefHandle(address)"})
    protected void writeVector(LLVMNativePointer address, LLVMI32Vector vector) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = this.getLLVMMemoryCached();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putI32(currentPtr, vector.getValue(i));
            currentPtr += 4L;
        }
    }

    @ExplodeLoop
    @Specialization(guards={"!isAutoDerefHandle(address)"})
    protected void writeVector(LLVMNativePointer address, LLVMI64Vector vector) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = this.getLLVMMemoryCached();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putI64(currentPtr, vector.getValue(i));
            currentPtr += 8L;
        }
    }

    @ExplodeLoop
    @Specialization(guards={"!isAutoDerefHandle(address)"})
    protected void writeVector(LLVMNativePointer address, LLVMI8Vector vector) {
        assert (vector.getLength() == this.getVectorLength());
        LLVMMemory memory = this.getLLVMMemoryCached();
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            memory.putI8(currentPtr, vector.getValue(i));
            ++currentPtr;
        }
    }

    @ExplodeLoop
    @Specialization(guards={"!isAutoDerefHandle(address)"})
    protected void writeVector(LLVMNativePointer address, LLVMPointerVector value, @Cached(value="createPointerStore()") LLVMPointerStoreNode write) {
        assert (value.getLength() == this.getVectorLength());
        long currentPtr = address.asNative();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            write.executeWithTarget(currentPtr, value.getValue(i));
            currentPtr += 8L;
        }
    }

    @ExplodeLoop
    @Specialization(limit="3")
    protected void writeVector(LLVMManagedPointer address, LLVMI1Vector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeI8(address.getObject(), curOffset, value.getValue(i) ? (byte)1 : 0);
            ++curOffset;
        }
    }

    @ExplodeLoop
    @Specialization(limit="3")
    protected void writeVector(LLVMManagedPointer address, LLVMI8Vector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeI8(address.getObject(), curOffset, value.getValue(i));
            ++curOffset;
        }
    }

    @ExplodeLoop
    @Specialization(limit="3")
    protected void writeVector(LLVMManagedPointer address, LLVMI16Vector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeI16(address.getObject(), curOffset, value.getValue(i));
            curOffset += 2L;
        }
    }

    @ExplodeLoop
    @Specialization(limit="3")
    protected void writeVector(LLVMManagedPointer address, LLVMI32Vector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeI32(address.getObject(), curOffset, value.getValue(i));
            curOffset += 4L;
        }
    }

    @ExplodeLoop
    @Specialization(limit="3")
    protected void writeVector(LLVMManagedPointer address, LLVMFloatVector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeFloat(address.getObject(), curOffset, value.getValue(i));
            curOffset += 4L;
        }
    }

    @ExplodeLoop
    @Specialization(limit="3")
    protected void writeVector(LLVMManagedPointer address, LLVMDoubleVector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeDouble(address.getObject(), curOffset, value.getValue(i));
            curOffset += 8L;
        }
    }

    @ExplodeLoop
    @Specialization(limit="3")
    protected void writeVector(LLVMManagedPointer address, LLVMI64Vector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writeI64(address.getObject(), curOffset, value.getValue(i));
            curOffset += 8L;
        }
    }

    @ExplodeLoop
    @Specialization(limit="3")
    protected void writeVector(LLVMManagedPointer address, LLVMPointerVector value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        assert (value.getLength() == this.getVectorLength());
        long curOffset = address.getOffset();
        for (int i = 0; i < this.getVectorLength(); ++i) {
            nativeWrite.writePointer(address.getObject(), curOffset, value.getValue(i));
            curOffset += 8L;
        }
    }

    protected static LLVMPointerStoreNode createPointerStore() {
        return LLVMPointerStoreNodeGen.create(null, null);
    }
}

