/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMObjectAccess;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.factories.LLVMObjectAccessFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMStoreNodeCommon
extends LLVMStoreNode {
    @CompilerDirectives.CompilationFinal
    private LLVMMemory llvmMemory;
    @Node.Child
    private LLVMDerefHandleGetReceiverNode derefHandleGetReceiverNode;

    protected LLVMDerefHandleGetReceiverNode getDerefHandleGetReceiverNode() {
        if (this.derefHandleGetReceiverNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.derefHandleGetReceiverNode = (LLVMDerefHandleGetReceiverNode)this.insert(LLVMDerefHandleGetReceiverNode.create());
        }
        return this.derefHandleGetReceiverNode;
    }

    protected static LLVMObjectAccess.LLVMObjectWriteNode createForeignWrite() {
        return LLVMObjectAccessFactory.createWrite();
    }

    protected boolean isAutoDerefHandle(LLVMNativePointer addr) {
        return this.getLLVMMemoryCached().isDerefHandleMemory(addr.asNative());
    }

    protected boolean isAutoDerefHandle(long addr) {
        return this.getLLVMMemoryCached().isDerefHandleMemory(addr);
    }

    protected final LLVMMemory getLLVMMemoryCached() {
        if (this.llvmMemory == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.llvmMemory = LLVMStoreNodeCommon.getLLVMMemory();
        }
        return this.llvmMemory;
    }
}

