/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreNodeCommon;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMI8StoreNode
extends LLVMStoreNodeCommon {
    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected void doOp(LLVMNativePointer addr, byte value) {
        this.getLLVMMemoryCached().putI8(addr, value);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected void doOpDerefHandle(LLVMNativePointer addr, byte value, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        this.doOpManaged(this.getDerefHandleGetReceiverNode().execute(addr), value, nativeWrite);
    }

    @Specialization(limit="3")
    protected void doOpManaged(LLVMManagedPointer address, byte value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeI8(address.getObject(), address.getOffset(), value);
    }
}

