/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.rmw;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="pointerNode"), @NodeChild(type=LLVMExpressionNode.class, value="valueNode")})
public abstract class LLVMI64RMWNode
extends LLVMExpressionNode {
    protected static LLVMI64LoadNode createRead() {
        return LLVMI64LoadNodeGen.create(null);
    }

    protected static LLVMI64StoreNode createWrite() {
        return LLVMI64StoreNodeGen.create(null, null);
    }

    public static abstract class LLVMI64RMWXorNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI64(address, value, (a, b) -> a ^ b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createRead()") LLVMI64LoadNode read, @Cached(value="createWrite()") LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTarget(address)).asNative();
                write.executeWithTarget(address, result ^ value);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWOrNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI64(address, value, (a, b) -> a | b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createRead()") LLVMI64LoadNode read, @Cached(value="createWrite()") LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTarget(address)).asNative();
                write.executeWithTarget(address, result | value);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWNandNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI64(address, value, (a, b) -> a & b ^ 0xFFFFFFFFFFFFFFFFL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createRead()") LLVMI64LoadNode read, @Cached(value="createWrite()") LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTarget(address)).asNative();
                write.executeWithTarget(address, result & value ^ 0xFFFFFFFFFFFFFFFFL);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWAndNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI64(address, value, (a, b) -> a & b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createRead()") LLVMI64LoadNode read, @Cached(value="createWrite()") LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTarget(address)).asNative();
                write.executeWithTarget(address, result & value);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWSubNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndSubI64(address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createRead()") LLVMI64LoadNode read, @Cached(value="createWrite()") LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTarget(address)).asNative();
                write.executeWithTarget(address, result - value);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWAddNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndAddI64(address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected long doOp(LLVMManagedPointer address, long value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createRead()") LLVMI64LoadNode read, @Cached(value="createWrite()") LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                long result = toNative.executeWithTarget(read.executeWithTarget(address)).asNative();
                write.executeWithTarget(address, result + value);
                return result;
            }
        }
    }

    public static abstract class LLVMI64RMWXchgNode
    extends LLVMI64RMWNode {
        @Specialization
        protected long doOp(LLVMNativePointer address, long value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndSetI64(address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(LLVMManagedPointer address, long value, @Cached(value="createRead()") LLVMI64LoadNode read, @Cached(value="createWrite()") LLVMI64StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                Object result = read.executeWithTarget(address);
                write.executeWithTarget(address, value);
                return result;
            }
        }
    }
}

