/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.rmw;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="pointerNode"), @NodeChild(type=LLVMExpressionNode.class, value="valueNode")})
public abstract class LLVMI16RMWNode
extends LLVMExpressionNode {
    protected static LLVMI16LoadNode createRead() {
        return LLVMI16LoadNodeGen.create(null);
    }

    protected static LLVMI16StoreNode createWrite() {
        return LLVMI16StoreNodeGen.create(null, null);
    }

    public static abstract class LLVMI16RMWXorNode
    extends LLVMI16RMWNode {
        @Specialization
        protected short doOp(LLVMNativePointer address, short value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI16(address, value, (a, b) -> (short)(a ^ b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected short doOp(LLVMManagedPointer address, short value, @Cached(value="createRead()") LLVMI16LoadNode read, @Cached(value="createWrite()") LLVMI16StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                short result = (Short)read.executeWithTarget(address);
                write.executeWithTarget(address, (short)(result ^ value));
                return result;
            }
        }
    }

    public static abstract class LLVMI16RMWOrNode
    extends LLVMI16RMWNode {
        @Specialization
        protected short doOp(LLVMNativePointer address, short value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI16(address, value, (a, b) -> (short)(a | b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected short doOp(LLVMManagedPointer address, short value, @Cached(value="createRead()") LLVMI16LoadNode read, @Cached(value="createWrite()") LLVMI16StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                short result = (Short)read.executeWithTarget(address);
                write.executeWithTarget(address, (short)(result | value));
                return result;
            }
        }
    }

    public static abstract class LLVMI16RMWNandNode
    extends LLVMI16RMWNode {
        @Specialization
        protected short doOp(LLVMNativePointer address, short value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI16(address, value, (a, b) -> (short)(~(a & b)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected short doOp(LLVMManagedPointer address, short value, @Cached(value="createRead()") LLVMI16LoadNode read, @Cached(value="createWrite()") LLVMI16StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                short result = (Short)read.executeWithTarget(address);
                write.executeWithTarget(address, (short)(~(result & value)));
                return result;
            }
        }
    }

    public static abstract class LLVMI16RMWAndNode
    extends LLVMI16RMWNode {
        @Specialization
        protected short doOp(LLVMNativePointer address, short value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI16(address, value, (a, b) -> (short)(a & b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected short doOp(LLVMManagedPointer address, short value, @Cached(value="createRead()") LLVMI16LoadNode read, @Cached(value="createWrite()") LLVMI16StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                short result = (Short)read.executeWithTarget(address);
                write.executeWithTarget(address, (short)(result & value));
                return result;
            }
        }
    }

    public static abstract class LLVMI16RMWSubNode
    extends LLVMI16RMWNode {
        @Specialization
        protected short doOp(LLVMNativePointer address, short value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI16(address, value, (a, b) -> (short)(a - b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected short doOp(LLVMManagedPointer address, short value, @Cached(value="createRead()") LLVMI16LoadNode read, @Cached(value="createWrite()") LLVMI16StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                short result = (Short)read.executeWithTarget(address);
                write.executeWithTarget(address, (short)(result - value));
                return result;
            }
        }
    }

    public static abstract class LLVMI16RMWAddNode
    extends LLVMI16RMWNode {
        @Specialization
        protected short doOp(LLVMNativePointer address, short value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI16(address, value, (a, b) -> (short)(a + b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected short doOp(LLVMManagedPointer address, short value, @Cached(value="createRead()") LLVMI16LoadNode read, @Cached(value="createWrite()") LLVMI16StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                short result = (Short)read.executeWithTarget(address);
                write.executeWithTarget(address, (short)(result + value));
                return result;
            }
        }
    }

    public static abstract class LLVMI16RMWXchgNode
    extends LLVMI16RMWNode {
        @Specialization
        protected short doOp(LLVMNativePointer address, short value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI16(address, value, (a, b) -> b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected short doOp(LLVMManagedPointer address, short value, @Cached(value="createRead()") LLVMI16LoadNode read, @Cached(value="createWrite()") LLVMI16StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                short result = (Short)read.executeWithTarget(address);
                write.executeWithTarget(address, value);
                return result;
            }
        }
    }
}

