/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.FloatValueProfile;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMAbstractLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMFloatLoadNode
extends LLVMAbstractLoadNode {
    private final FloatValueProfile profile = FloatValueProfile.createRawIdentityProfile();

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected float doFloatNative(LLVMNativePointer addr) {
        return this.profile.profile(this.getLLVMMemoryCached().getFloat(addr));
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected float doFloatDerefHandle(LLVMNativePointer addr, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doFloatManaged(this.getDerefHandleGetReceiverNode().execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    protected float doFloatManaged(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readFloat(addr.getObject(), addr.getOffset());
    }
}

