/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMAbstractLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDirectLoadNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMDirectLoadNode {

    public static abstract class LLVMStructDirectLoadNode
    extends LLVMAbstractLoadNode {
        @Specialization
        protected LLVMPointer doPointer(LLVMPointer addr) {
            return addr;
        }
    }

    public static abstract class LLVMPointerDirectLoadNode
    extends LLVMAbstractLoadNode {
        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected LLVMNativePointer doNativePointer(LLVMNativePointer addr) {
            return this.getLLVMMemoryCached().getPointer(addr);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        protected LLVMPointer doDerefHandle(LLVMNativePointer addr, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
            return this.doIndirectedForeign(this.getDerefHandleGetReceiverNode().execute(addr), nativeRead);
        }

        @Specialization(limit="3")
        protected LLVMPointer doIndirectedForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            return nativeRead.readPointer(addr.getObject(), addr.getOffset());
        }
    }

    public static abstract class LLVM80BitFloatDirectLoadNode
    extends LLVMAbstractLoadNode {
        static LLVM80BitFloatDirectLoadNode create() {
            return LLVMDirectLoadNodeFactory.LLVM80BitFloatDirectLoadNodeGen.create(null);
        }

        protected abstract LLVM80BitFloat executeManaged(LLVMManagedPointer var1);

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected LLVM80BitFloat do80BitFloatNative(LLVMNativePointer addr) {
            return this.getLLVMMemoryCached().get80BitFloat(addr);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        protected LLVM80BitFloat do80BitFloatDerefHandle(LLVMNativePointer addr, @Cached LLVM80BitFloatDirectLoadNode load) {
            return load.executeManaged(this.getDerefHandleGetReceiverNode().execute(addr));
        }

        @ExplodeLoop
        @Specialization(limit="3")
        protected LLVM80BitFloat doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            byte[] result = new byte[10];
            long curOffset = addr.getOffset();
            for (int i = 0; i < result.length; ++i) {
                result[i] = nativeRead.readI8(addr.getObject(), curOffset);
                ++curOffset;
            }
            return LLVM80BitFloat.fromBytes(result);
        }
    }

    @NodeField(name="bitWidth", type=int.class)
    public static abstract class LLVMIVarBitDirectLoadNode
    extends LLVMAbstractLoadNode {
        protected abstract LLVMIVarBit executeManaged(LLVMManagedPointer var1);

        public abstract int getBitWidth();

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected LLVMIVarBit doIVarBitNative(LLVMNativePointer addr) {
            return this.getLLVMMemoryCached().getIVarBit(addr, this.getBitWidth());
        }

        LLVMIVarBitDirectLoadNode createRecursive() {
            return LLVMDirectLoadNodeFactory.LLVMIVarBitDirectLoadNodeGen.create(null, this.getBitWidth());
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        protected LLVMIVarBit doIVarBitDerefHandle(LLVMNativePointer addr, @Cached(value="createRecursive()") LLVMIVarBitDirectLoadNode load) {
            return load.executeManaged(this.getDerefHandleGetReceiverNode().execute(addr));
        }

        @Specialization(limit="3")
        protected LLVMIVarBit doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            byte[] result = new byte[this.getByteSize()];
            long curOffset = addr.getOffset();
            for (int i = result.length - 1; i >= 0; --i) {
                result[i] = nativeRead.readI8(addr.getObject(), curOffset);
                ++curOffset;
            }
            return LLVMIVarBit.create(this.getBitWidth(), result, this.getBitWidth(), false);
        }

        private int getByteSize() {
            assert (this.getBitWidth() % 8 == 0);
            return this.getBitWidth() / 8;
        }
    }
}

