/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.ManagedMemMoveHelperNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

final class ManagedMemMoveHelperNode
extends LLVMNode {
    @Node.Child
    MemReadHelperNode read;
    @Node.Child
    MemWriteHelperNode write;

    public static ManagedMemMoveHelperNode create(LLVMPointer target, LLVMPointer source) {
        MemReadHelperNode read = MemReadHelperNode.create(source);
        MemWriteHelperNode write = MemWriteHelperNode.create(target);
        return new ManagedMemMoveHelperNode(read, write);
    }

    public static ManagedMemMoveHelperNode createSlowPath(LLVMPointer target, LLVMPointer source) {
        MemReadHelperNode read = MemReadHelperNode.createSlowPath(source);
        MemWriteHelperNode write = MemWriteHelperNode.createSlowPath(target);
        return new ManagedMemMoveHelperNode(read, write);
    }

    public boolean supportsUnitSize(int unitSize) {
        if (!this.read.supportsUnitSize(unitSize)) {
            return false;
        }
        return this.write.supportsUnitSize(unitSize);
    }

    public boolean guard(LLVMPointer target, LLVMPointer source) {
        if (!this.read.guard(source)) {
            return false;
        }
        return this.write.guard(target);
    }

    public void moveUnit(LLVMPointer target, LLVMPointer source, int unitSize) {
        CompilerAsserts.partialEvaluationConstant((int)unitSize);
        long value = this.read.execute(source, unitSize);
        this.write.execute(target, value, unitSize);
    }

    private ManagedMemMoveHelperNode(MemReadHelperNode read, MemWriteHelperNode write) {
        this.read = read;
        this.write = write;
    }

    static abstract class MemWriteI64
    extends MemWriteManaged {
        MemWriteI64(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        int getAccessSize() {
            return 8;
        }

        @Specialization
        void doManaged(LLVMManagedPointer target, long value, int unitSize) {
            assert (unitSize == 8);
            this.managedWrite.writeI64(target.getObject(), target.getOffset(), value);
        }
    }

    static abstract class MemWriteI32
    extends MemWriteManaged {
        MemWriteI32(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        int getAccessSize() {
            return 4;
        }

        @ExplodeLoop
        @Specialization
        void doManaged(LLVMManagedPointer target, long value, int unitSize) {
            long v = value;
            for (int i = 0; i < unitSize; i += 4) {
                this.managedWrite.writeI32(target.getObject(), target.getOffset() + (long)i, (int)v);
                v >>= 32;
            }
        }
    }

    static abstract class MemWriteI16
    extends MemWriteManaged {
        MemWriteI16(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        int getAccessSize() {
            return 2;
        }

        @ExplodeLoop
        @Specialization
        void doManaged(LLVMManagedPointer target, long value, int unitSize) {
            long v = value;
            for (int i = 0; i < unitSize; i += 2) {
                this.managedWrite.writeI16(target.getObject(), target.getOffset() + (long)i, (short)v);
                v >>= 16;
            }
        }
    }

    static abstract class MemWriteI8
    extends MemWriteManaged {
        MemWriteI8(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        int getAccessSize() {
            return 1;
        }

        @ExplodeLoop
        @Specialization
        void doManaged(LLVMManagedPointer target, long value, int unitSize) {
            long v = value;
            for (int i = 0; i < unitSize; ++i) {
                this.managedWrite.writeI8(target.getObject(), target.getOffset() + (long)i, (byte)v);
                v >>= 8;
            }
        }
    }

    static abstract class MemWriteManaged
    extends MemWriteHelperNode {
        @Node.Child
        NativeTypeLibrary nativeTypes;
        @Node.Child
        LLVMManagedWriteLibrary managedWrite;

        abstract int getAccessSize();

        @Override
        boolean supportsUnitSize(int unitSize) {
            return unitSize % this.getAccessSize() == 0;
        }

        MemWriteManaged(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            this.nativeTypes = nativeTypes;
            this.managedWrite = managedWrite;
        }

        @Override
        boolean guard(LLVMPointer ptr) {
            LLVMManagedPointer managed;
            if (LLVMManagedPointer.isInstance(ptr) && this.nativeTypes.accepts((managed = LLVMManagedPointer.cast(ptr)).getObject()) && this.managedWrite.accepts(managed.getObject()) && this.managedWrite.isWritable(managed.getObject())) {
                Object type = this.nativeTypes.getNativeType(managed.getObject());
                if (type instanceof LLVMInteropType.Array) {
                    return ((LLVMInteropType.Array)type).getElementSize() == (long)this.getAccessSize();
                }
                return this.getAccessSize() == 1;
            }
            return false;
        }
    }

    @GenerateUncached
    static abstract class MemWriteNative
    extends MemWriteHelperNode {
        MemWriteNative() {
        }

        @Override
        boolean supportsUnitSize(int unitSize) {
            return true;
        }

        @Override
        boolean guard(LLVMPointer ptr) {
            return LLVMNativePointer.isInstance(ptr);
        }

        @Specialization(guards={"unitSize == 1"})
        void doNativeI8(LLVMNativePointer target, long value, int unitSize, @CachedLanguage LLVMLanguage language) {
            language.getCapability(LLVMMemory.class).putI8(target, (byte)value);
        }

        @Specialization(guards={"unitSize == 2"})
        void doNativeI16(LLVMNativePointer target, long value, int unitSize, @CachedLanguage LLVMLanguage language) {
            language.getCapability(LLVMMemory.class).putI16(target, (short)value);
        }

        @Specialization(guards={"unitSize == 4"})
        void doNativeI32(LLVMNativePointer target, long value, int unitSize, @CachedLanguage LLVMLanguage language) {
            language.getCapability(LLVMMemory.class).putI32(target, (int)value);
        }

        @Specialization(guards={"unitSize == 8"})
        void doNativeI64(LLVMNativePointer target, long value, int unitSize, @CachedLanguage LLVMLanguage language) {
            language.getCapability(LLVMMemory.class).putI64(target, value);
        }
    }

    static abstract class MemWriteHelperNode
    extends MemAccessHelperNode {
        MemWriteHelperNode() {
        }

        private static MemWriteHelperNode createManaged(Object type, NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            if (type instanceof LLVMInteropType.Array) {
                long elementSize = ((LLVMInteropType.Array)type).getElementSize();
                if (elementSize == 2L) {
                    return ManagedMemMoveHelperNodeFactory.MemWriteI16NodeGen.create(nativeTypes, managedWrite);
                }
                if (elementSize == 4L) {
                    return ManagedMemMoveHelperNodeFactory.MemWriteI32NodeGen.create(nativeTypes, managedWrite);
                }
                if (elementSize == 8L) {
                    return ManagedMemMoveHelperNodeFactory.MemWriteI64NodeGen.create(nativeTypes, managedWrite);
                }
            }
            return ManagedMemMoveHelperNodeFactory.MemWriteI8NodeGen.create(nativeTypes, managedWrite);
        }

        static MemWriteHelperNode create(LLVMPointer target) {
            if (LLVMNativePointer.isInstance(target)) {
                return ManagedMemMoveHelperNodeFactory.MemWriteNativeNodeGen.create();
            }
            assert (LLVMManagedPointer.isInstance(target));
            LLVMManagedPointer managed = LLVMManagedPointer.cast(target);
            NativeTypeLibrary nativeTypes = (NativeTypeLibrary)NativeTypeLibrary.getFactory().create(managed.getObject());
            LLVMManagedWriteLibrary managedWrite = (LLVMManagedWriteLibrary)LLVMManagedWriteLibrary.getFactory().create(managed.getObject());
            Object type = ((NativeTypeLibrary)NativeTypeLibrary.getFactory().getUncached()).getNativeType(managed.getObject());
            return MemWriteHelperNode.createManaged(type, nativeTypes, managedWrite);
        }

        static MemWriteHelperNode createSlowPath(LLVMPointer target) {
            if (LLVMNativePointer.isInstance(target)) {
                return ManagedMemMoveHelperNodeFactory.MemWriteNativeNodeGen.getUncached();
            }
            assert (LLVMManagedPointer.isInstance(target));
            LLVMManagedPointer managed = LLVMManagedPointer.cast(target);
            NativeTypeLibrary nativeTypes = (NativeTypeLibrary)NativeTypeLibrary.getFactory().getUncached();
            return MemWriteHelperNode.createManaged(nativeTypes.getNativeType(managed.getObject()), nativeTypes, (LLVMManagedWriteLibrary)LLVMManagedWriteLibrary.getFactory().getUncached());
        }

        abstract void execute(LLVMPointer var1, long var2, int var4);
    }

    static abstract class MemReadI64
    extends MemReadManaged {
        MemReadI64(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        int getAccessSize() {
            return 8;
        }

        @Specialization
        long doManaged(LLVMManagedPointer source, int unitSize) {
            try {
                assert (unitSize == 8);
                return this.managedRead.readI64(source.getObject(), source.getOffset());
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMPolyglotException(this, "Can not memmove from an object containing foreign pointers.");
            }
        }
    }

    static abstract class MemReadI32
    extends MemReadManaged {
        MemReadI32(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        int getAccessSize() {
            return 4;
        }

        @ExplodeLoop
        @Specialization
        long doManaged(LLVMManagedPointer source, int unitSize) {
            int shift = 0;
            long ret = 0L;
            for (int i = 0; i < unitSize; i += 4) {
                ret |= ((long)this.managedRead.readI32(source.getObject(), source.getOffset() + (long)i) & 0xFFFFFFFFL) << shift;
                shift += 32;
            }
            return ret;
        }
    }

    static abstract class MemReadI16
    extends MemReadManaged {
        MemReadI16(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        int getAccessSize() {
            return 2;
        }

        @ExplodeLoop
        @Specialization
        long doManaged(LLVMManagedPointer source, int unitSize) {
            int shift = 0;
            long ret = 0L;
            for (int i = 0; i < unitSize; i += 2) {
                ret |= ((long)this.managedRead.readI16(source.getObject(), source.getOffset() + (long)i) & 0xFFFFL) << shift;
                shift += 16;
            }
            return ret;
        }
    }

    static abstract class MemReadI8
    extends MemReadManaged {
        MemReadI8(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        int getAccessSize() {
            return 1;
        }

        @ExplodeLoop
        @Specialization
        long execute(LLVMManagedPointer source, int unitSize) {
            int shift = 0;
            long ret = 0L;
            for (int i = 0; i < unitSize; ++i) {
                ret |= ((long)this.managedRead.readI8(source.getObject(), source.getOffset() + (long)i) & 0xFFL) << shift;
                shift += 8;
            }
            return ret;
        }
    }

    static abstract class MemReadManaged
    extends MemReadHelperNode {
        @Node.Child
        NativeTypeLibrary nativeTypes;
        @Node.Child
        LLVMManagedReadLibrary managedRead;

        abstract int getAccessSize();

        @Override
        boolean supportsUnitSize(int unitSize) {
            return unitSize % this.getAccessSize() == 0;
        }

        MemReadManaged(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            this.nativeTypes = nativeTypes;
            this.managedRead = managedRead;
        }

        @Override
        boolean guard(LLVMPointer ptr) {
            LLVMManagedPointer managed;
            if (LLVMManagedPointer.isInstance(ptr) && this.nativeTypes.accepts((managed = LLVMManagedPointer.cast(ptr)).getObject()) && this.managedRead.accepts(managed.getObject()) && this.managedRead.isReadable(managed.getObject())) {
                Object type = this.nativeTypes.getNativeType(managed.getObject());
                if (type instanceof LLVMInteropType.Array) {
                    return ((LLVMInteropType.Array)type).getElementSize() == (long)this.getAccessSize();
                }
                return this.getAccessSize() == 1;
            }
            return false;
        }
    }

    @GenerateUncached
    static abstract class MemReadNative
    extends MemReadHelperNode {
        MemReadNative() {
        }

        @Override
        boolean supportsUnitSize(int unitSize) {
            return true;
        }

        @Override
        boolean guard(LLVMPointer ptr) {
            return LLVMNativePointer.isInstance(ptr);
        }

        @Specialization(guards={"unitSize == 1"})
        long doNativeI8(LLVMNativePointer source, int unitSize, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(LLVMMemory.class).getI8(source);
        }

        @Specialization(guards={"unitSize == 2"})
        long doNativeI16(LLVMNativePointer source, int unitSize, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(LLVMMemory.class).getI16(source);
        }

        @Specialization(guards={"unitSize == 4"})
        long doNativeI32(LLVMNativePointer source, int unitSize, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(LLVMMemory.class).getI32(source);
        }

        @Specialization(guards={"unitSize == 8"})
        long doNativeI64(LLVMNativePointer source, int unitSize, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(LLVMMemory.class).getI64(source);
        }
    }

    static abstract class MemReadHelperNode
    extends MemAccessHelperNode {
        MemReadHelperNode() {
        }

        private static MemReadHelperNode createManaged(Object type, NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            if (type instanceof LLVMInteropType.Array) {
                long elementSize = ((LLVMInteropType.Array)type).getElementSize();
                if (elementSize == 2L) {
                    return ManagedMemMoveHelperNodeFactory.MemReadI16NodeGen.create(nativeTypes, managedRead);
                }
                if (elementSize == 4L) {
                    return ManagedMemMoveHelperNodeFactory.MemReadI32NodeGen.create(nativeTypes, managedRead);
                }
                if (elementSize == 8L) {
                    return ManagedMemMoveHelperNodeFactory.MemReadI64NodeGen.create(nativeTypes, managedRead);
                }
            }
            return ManagedMemMoveHelperNodeFactory.MemReadI8NodeGen.create(nativeTypes, managedRead);
        }

        static MemReadHelperNode create(LLVMPointer target) {
            if (LLVMNativePointer.isInstance(target)) {
                return ManagedMemMoveHelperNodeFactory.MemReadNativeNodeGen.create();
            }
            assert (LLVMManagedPointer.isInstance(target));
            LLVMManagedPointer managed = LLVMManagedPointer.cast(target);
            NativeTypeLibrary nativeTypes = (NativeTypeLibrary)NativeTypeLibrary.getFactory().create(managed.getObject());
            LLVMManagedReadLibrary managedRead = (LLVMManagedReadLibrary)LLVMManagedReadLibrary.getFactory().create(managed.getObject());
            Object type = ((NativeTypeLibrary)NativeTypeLibrary.getFactory().getUncached()).getNativeType(managed.getObject());
            return MemReadHelperNode.createManaged(type, nativeTypes, managedRead);
        }

        static MemReadHelperNode createSlowPath(LLVMPointer target) {
            if (LLVMNativePointer.isInstance(target)) {
                return ManagedMemMoveHelperNodeFactory.MemReadNativeNodeGen.getUncached();
            }
            assert (LLVMManagedPointer.isInstance(target));
            LLVMManagedPointer managed = LLVMManagedPointer.cast(target);
            NativeTypeLibrary nativeTypes = (NativeTypeLibrary)NativeTypeLibrary.getFactory().getUncached();
            return MemReadHelperNode.createManaged(nativeTypes.getNativeType(managed.getObject()), nativeTypes, (LLVMManagedReadLibrary)LLVMManagedReadLibrary.getFactory().getUncached());
        }

        abstract long execute(LLVMPointer var1, int var2);
    }

    static abstract class MemAccessHelperNode
    extends LLVMNode {
        MemAccessHelperNode() {
        }

        abstract boolean supportsUnitSize(int var1);

        abstract boolean guard(LLVMPointer var1);
    }

    static abstract class UnitSizeNode
    extends LLVMNode {
        UnitSizeNode() {
        }

        abstract int execute(ManagedMemMoveHelperNode var1, long var2);

        boolean isDivisible(long length, int unitSize) {
            return length % (long)unitSize == 0L;
        }

        @Specialization(guards={"helper.supportsUnitSize(8)", "isDivisible(length, 8)"})
        int do8(ManagedMemMoveHelperNode helper, long length) {
            return 8;
        }

        @Specialization(guards={"helper.supportsUnitSize(4)", "isDivisible(length, 4)"}, replaces={"do8"})
        int do4(ManagedMemMoveHelperNode helper, long length) {
            return 4;
        }

        @Specialization(guards={"helper.supportsUnitSize(2)", "isDivisible(length, 2)"}, replaces={"do4"})
        int do2(ManagedMemMoveHelperNode helper, long length) {
            return 2;
        }

        @Specialization(guards={"helper.supportsUnitSize(1)", "isDivisible(length, 1)"}, replaces={"do2"})
        int do1(ManagedMemMoveHelperNode helper, long length) {
            return 1;
        }

        @Fallback
        int doError(ManagedMemMoveHelperNode helper, long length) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMPolyglotException(this, "Memmove length is not divisible by managed array element size.");
        }
    }
}

