/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMStructByValueNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMStructByValueNode.class)
public final class LLVMStructByValueNodeGen
extends LLVMStructByValueNode {
    private final long length;
    @Node.Child
    private LLVMExpressionNode source_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMStructByValueNodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode stackAllocationNode, LLVMExpressionNode source, long length) {
        super(memMove, stackAllocationNode);
        this.length = length;
        this.source_ = source;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object sourceValue_ = this.source_.executeGeneric(frameValue);
        if ((state & 1) != 0 && LLVMTypes.isPointer(sourceValue_)) {
            LLVMPointer sourceValue__ = LLVMTypes.asPointer(sourceValue_);
            return this.byValue(frameValue, sourceValue__);
        }
        if ((state & 2) != 0 && sourceValue_ instanceof LLVMVarArgCompoundValue) {
            LLVMVarArgCompoundValue sourceValue__ = (LLVMVarArgCompoundValue)sourceValue_;
            return this.byValue(frameValue, sourceValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, sourceValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object sourceValue) {
        int state = this.state_;
        if (LLVMTypes.isPointer(sourceValue)) {
            LLVMPointer sourceValue_ = LLVMTypes.asPointer(sourceValue);
            this.state_ = state |= 1;
            return this.byValue(frameValue, sourceValue_);
        }
        if (sourceValue instanceof LLVMVarArgCompoundValue) {
            LLVMVarArgCompoundValue sourceValue_ = (LLVMVarArgCompoundValue)sourceValue;
            this.state_ = state |= 2;
            return this.byValue(frameValue, sourceValue_);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.source_}, new Object[]{sourceValue});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMStructByValueNode create(LLVMMemMoveNode memMove, LLVMExpressionNode stackAllocationNode, LLVMExpressionNode source, long length) {
        return new LLVMStructByValueNodeGen(memMove, stackAllocationNode, source, length);
    }
}

