/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.VarargsAreaStackAllocationNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMNativeVarargsAreaStackAllocationNode
extends LLVMNode
implements VarargsAreaStackAllocationNode {
    @CompilerDirectives.CompilationFinal
    private FrameSlot stackPointer;

    protected FrameSlot getStackPointerSlot() {
        if (this.stackPointer == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.stackPointer = this.getRootNode().getFrameDescriptor().findFrameSlot((Object)"<stackpointer>");
        }
        return this.stackPointer;
    }

    @Specialization
    protected LLVMNativePointer alloc(VirtualFrame frame, long size, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
        return LLVMNativePointer.create(LLVMStack.allocateStackMemory(frame, memory, this.getStackPointerSlot(), size, 8));
    }
}

