/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.literals;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public class LLVMSimpleLiteralNode {

    public static final class LLVMNativePointerLiteralNode
    extends LLVMExpressionNode {
        private final long address;

        public LLVMNativePointerLiteralNode(LLVMNativePointer address) {
            this.address = address.asNative();
        }

        @Override
        public LLVMNativePointer executeLLVMNativePointer(VirtualFrame frame) {
            return LLVMNativePointer.create(this.address);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeLLVMNativePointer(frame);
        }
    }

    public static final class LLVMManagedPointerLiteralNode
    extends LLVMExpressionNode {
        private final LLVMManagedPointer address;

        public LLVMManagedPointerLiteralNode(LLVMManagedPointer address) {
            this.address = address;
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.address.copy();
        }
    }

    public static final class LLVM80BitFloatLiteralNode
    extends LLVMExpressionNode {
        private final boolean sign;
        private final int exponent;
        private final long fraction;

        public LLVM80BitFloatLiteralNode(LLVM80BitFloat literal) {
            this.sign = literal.getSign();
            this.exponent = literal.getExponent();
            this.fraction = literal.getFraction();
        }

        @Override
        public LLVM80BitFloat executeLLVM80BitFloat(VirtualFrame frame) {
            return new LLVM80BitFloat(this.sign, this.exponent, this.fraction);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeLLVM80BitFloat(frame);
        }
    }

    public static final class LLVMDoubleLiteralNode
    extends LLVMExpressionNode {
        private final double literal;

        public LLVMDoubleLiteralNode(double literal) {
            this.literal = literal;
        }

        @Override
        public double executeDouble(VirtualFrame frame) {
            return this.literal;
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeDouble(frame);
        }
    }

    public static final class LLVMFloatLiteralNode
    extends LLVMExpressionNode {
        private final float literal;

        public LLVMFloatLiteralNode(float literal) {
            this.literal = literal;
        }

        @Override
        public float executeFloat(VirtualFrame frame) {
            return this.literal;
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return Float.valueOf(this.executeFloat(frame));
        }
    }

    public static final class LLVMI64LiteralNode
    extends LLVMExpressionNode {
        private final long literal;

        public LLVMI64LiteralNode(long literal) {
            this.literal = literal;
        }

        @Override
        public long executeI64(VirtualFrame frame) {
            return this.literal;
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeI64(frame);
        }
    }

    public static final class LLVMI32LiteralNode
    extends LLVMExpressionNode {
        private final int literal;

        public LLVMI32LiteralNode(int literal) {
            this.literal = literal;
        }

        @Override
        public int executeI32(VirtualFrame frame) {
            return this.literal;
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeI32(frame);
        }
    }

    public static final class LLVMI16LiteralNode
    extends LLVMExpressionNode {
        private final short literal;

        public LLVMI16LiteralNode(short literal) {
            this.literal = literal;
        }

        @Override
        public short executeI16(VirtualFrame frame) {
            return this.literal;
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeI16(frame);
        }
    }

    public static final class LLVMI8LiteralNode
    extends LLVMExpressionNode {
        private final byte literal;

        public LLVMI8LiteralNode(byte literal) {
            this.literal = literal;
        }

        @Override
        public byte executeI8(VirtualFrame frame) {
            return this.literal;
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeI8(frame);
        }
    }

    public static final class LLVMI1LiteralNode
    extends LLVMExpressionNode {
        private final boolean literal;

        public LLVMI1LiteralNode(boolean literal) {
            this.literal = literal;
        }

        @Override
        public boolean executeI1(VirtualFrame frame) {
            return this.literal;
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeI1(frame);
        }
    }

    public static final class LLVMIVarBitLiteralNode
    extends LLVMExpressionNode {
        private final LLVMIVarBit literal;

        public LLVMIVarBitLiteralNode(LLVMIVarBit literal) {
            this.literal = literal;
        }

        @Override
        public LLVMIVarBit executeLLVMIVarBit(VirtualFrame frame) {
            return this.literal.copy();
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeLLVMIVarBit(frame);
        }
    }
}

