/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pthread.LLVMPThreadContext;
import com.oracle.truffle.llvm.runtime.pthread.PThreadExitException;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class LLVMPThreadStart {

    public static final class LLVMPThreadFunctionRootNode
    extends RootNode {
        @Node.Child
        private LLVMExpressionNode callNode;
        private final FrameSlot functionSlot;
        private final FrameSlot argSlot;
        private final FrameSlot spSlot;
        @CompilerDirectives.CompilationFinal
        TruffleLanguage.ContextReference<LLVMContext> ctxRef;

        private static FrameDescriptor createFrameDescriptor() {
            FrameDescriptor descriptor = new FrameDescriptor();
            descriptor.addFrameSlot((Object)"function");
            descriptor.addFrameSlot((Object)"arg");
            descriptor.addFrameSlot((Object)"sp");
            return descriptor;
        }

        @CompilerDirectives.TruffleBoundary
        public LLVMPThreadFunctionRootNode(LLVMLanguage language) {
            super((TruffleLanguage)language, LLVMPThreadFunctionRootNode.createFrameDescriptor());
            FrameDescriptor descriptor = this.getFrameDescriptor();
            this.functionSlot = descriptor.findFrameSlot((Object)"function");
            this.argSlot = descriptor.findFrameSlot((Object)"arg");
            this.spSlot = descriptor.findFrameSlot((Object)"sp");
            this.callNode = CommonNodeFactory.createFunctionCall(CommonNodeFactory.createFrameRead(PointerType.VOID, this.functionSlot), new LLVMExpressionNode[]{CommonNodeFactory.createFrameRead(PointerType.VOID, this.spSlot), CommonNodeFactory.createFrameRead(PointerType.VOID, this.argSlot)}, new FunctionType(PointerType.VOID, new Type[]{PointerType.VOID}, false));
        }

        public Object execute(VirtualFrame frame) {
            if (this.ctxRef == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.ctxRef = this.lookupContextReference(LLVMLanguage.class);
            }
            try (LLVMStack.StackPointer sp = ((LLVMContext)this.ctxRef.get()).getThreadingStack().getStack().newFrame();){
                Object[] arguments = frame.getArguments();
                Object function = arguments[0];
                Object arg = arguments[1];
                frame.setObject(this.functionSlot, function);
                frame.setObject(this.argSlot, arg);
                frame.setObject(this.spSlot, (Object)sp);
                Object object = this.callNode.executeGeneric(frame);
                return object;
            }
        }
    }

    static final class LLVMPThreadRunnable
    implements Runnable {
        private boolean isThread;
        private Object startRoutine;
        private Object arg;
        private LLVMContext context;

        LLVMPThreadRunnable(Object startRoutine, Object arg, LLVMContext context, boolean isThread) {
            this.startRoutine = startRoutine;
            this.arg = arg;
            this.context = context;
            this.isThread = isThread;
        }

        @Override
        public void run() {
            LLVMPThreadContext pThreadContext = this.context.getpThreadContext();
            try {
                Object returnValue = pThreadContext.getPthreadCallTarget().call(new Object[]{this.startRoutine, this.arg});
                if (returnValue == null) {
                    returnValue = LLVMNativePointer.createNull();
                }
                pThreadContext.setThreadReturnValue(Thread.currentThread().getId(), returnValue);
            }
            catch (PThreadExitException key) {
            }
            catch (Throwable t) {
                pThreadContext.setThreadReturnValue(Thread.currentThread().getId(), LLVMNativePointer.createNull());
                throw t;
            }
            finally {
                if (this.isThread) {
                    for (int key = 1; key <= pThreadContext.getNumberOfPthreadKeys(); ++key) {
                        LLVMPointer keyMapping;
                        LLVMPointer destructor = pThreadContext.getDestructor(key);
                        if (destructor == null || destructor.isNull() || (keyMapping = pThreadContext.getAndRemoveSpecificUnlessNull(key)) == null) continue;
                        assert (!keyMapping.isNull());
                        new LLVMPThreadRunnable(destructor, keyMapping, this.context, false).run();
                    }
                    pThreadContext.clearThreadId();
                }
            }
        }
    }
}

