/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public final class LLVMPThreadKeyIntrinsics {

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="key"), @NodeChild(type=LLVMExpressionNode.class, value="value")})
    public static abstract class LLVMPThreadSetSpecific
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(int key, LLVMPointer value, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            if (!context.getpThreadContext().setSpecific(key, value)) {
                return 22;
            }
            return 0;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="key")
    public static abstract class LLVMPThreadGetSpecific
    extends LLVMBuiltin {
        @Specialization
        protected LLVMPointer doIntrinsic(int key, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            LLVMPointer value = context.getpThreadContext().getSpecific(key);
            return value != null ? value : LLVMNativePointer.createNull();
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="key")
    public static abstract class LLVMPThreadKeyDelete
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(int key, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            context.getpThreadContext().deletePThreadKey(key);
            return 0;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="destructor")
    public static abstract class LLVMPThreadKeyCreate
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(LLVMPointer destructor, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            return context.getpThreadContext().createPThreadKey(destructor);
        }
    }
}

