/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetElementPtrNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetElementPtrNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDirectLoadNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
@NodeField(type=int.class, name="numberExplicitArguments")
public abstract class LLVMX86_64BitVACopy
extends LLVMBuiltin {
    @Node.Child
    private LLVMGetElementPtrNode.LLVMIncrementPointerNode pointerArithmeticStructInit = LLVMGetElementPtrNodeGen.LLVMIncrementPointerNodeGen.create();
    @Node.Child
    private LLVMStoreNode gpOffsetStore = LLVMI32StoreNodeGen.create(null, null);
    @Node.Child
    private LLVMStoreNode fpOffsetStore = LLVMI32StoreNodeGen.create(null, null);
    @Node.Child
    private LLVMStoreNode overflowArgAreaStore = LLVMPointerStoreNodeGen.create(null, null);
    @Node.Child
    private LLVMStoreNode regSaveAreaStore = LLVMPointerStoreNodeGen.create(null, null);
    @Node.Child
    private LLVMLoadNode gpOffsetLoad = LLVMI32LoadNodeGen.create(null);
    @Node.Child
    private LLVMLoadNode fpOffsetLoad = LLVMI32LoadNodeGen.create(null);
    @Node.Child
    private LLVMLoadNode overflowArgAreaLoad = LLVMDirectLoadNodeFactory.LLVMPointerDirectLoadNodeGen.create(null);
    @Node.Child
    private LLVMLoadNode regSaveAreaLoad = LLVMDirectLoadNodeFactory.LLVMPointerDirectLoadNodeGen.create(null);

    private void setGPOffset(LLVMPointer address, int value) {
        LLVMPointer p = this.pointerArithmeticStructInit.executeWithTarget(address, 0);
        this.gpOffsetStore.executeWithTarget(p, value);
    }

    private void setFPOffset(LLVMPointer address, int value) {
        LLVMPointer p = this.pointerArithmeticStructInit.executeWithTarget(address, 4);
        this.fpOffsetStore.executeWithTarget(p, value);
    }

    private void setOverflowArgArea(LLVMPointer address, Object value) {
        LLVMPointer p = this.pointerArithmeticStructInit.executeWithTarget(address, 8);
        this.overflowArgAreaStore.executeWithTarget(p, value);
    }

    private void setRegSaveArea(LLVMPointer address, Object value) {
        LLVMPointer p = this.pointerArithmeticStructInit.executeWithTarget(address, 16);
        this.regSaveAreaStore.executeWithTarget(p, value);
    }

    private int getGPOffset(LLVMPointer address) {
        LLVMPointer p = this.pointerArithmeticStructInit.executeWithTarget(address, 0);
        return (Integer)this.gpOffsetLoad.executeWithTarget(p);
    }

    private int getFPOffset(LLVMPointer address) {
        LLVMPointer p = this.pointerArithmeticStructInit.executeWithTarget(address, 4);
        return (Integer)this.fpOffsetLoad.executeWithTarget(p);
    }

    private Object getOverflowArgArea(LLVMPointer address) {
        LLVMPointer p = this.pointerArithmeticStructInit.executeWithTarget(address, 8);
        return this.overflowArgAreaLoad.executeWithTarget(p);
    }

    private Object getRegSaveArea(LLVMPointer address) {
        LLVMPointer p = this.pointerArithmeticStructInit.executeWithTarget(address, 16);
        return this.regSaveAreaLoad.executeWithTarget(p);
    }

    public abstract int getNumberExplicitArguments();

    @Specialization
    protected Object doVoid(LLVMPointer dest, LLVMPointer source) {
        this.setGPOffset(dest, this.getGPOffset(source));
        this.setFPOffset(dest, this.getFPOffset(source));
        this.setOverflowArgArea(dest, this.getOverflowArgArea(source));
        this.setRegSaveArea(dest, this.getRegSaveArea(source));
        return null;
    }
}

