/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugAggregateObjectBuilder;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugBuilder;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugWriteNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMDebugWriteNode.class)
public final class LLVMDebugWriteNodeFactory {

    @GeneratedBy(value=LLVMDebugWriteNode.AggregateWriteNode.class)
    public static final class AggregateWriteNodeGen
    extends LLVMDebugWriteNode.AggregateWriteNode {
        @Node.Child
        private LLVMExpressionNode llvmValueRead_;
        @Node.Child
        private LLVMExpressionNode containerRead_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private LLVMDebugValue.Builder valueProcessor_;

        private AggregateWriteNodeGen(LLVMDebugBuilder builder, int partIndex, int[] clearIndices, LLVMExpressionNode llvmValueRead, LLVMExpressionNode containerRead) {
            super(builder, partIndex, clearIndices);
            this.llvmValueRead_ = llvmValueRead;
            this.containerRead_ = containerRead;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object llvmValueReadValue_ = this.llvmValueRead_.executeGeneric(frameValue);
            Object containerReadValue_ = this.containerRead_.executeGeneric(frameValue);
            if (state != 0 && llvmValueReadValue_ instanceof LLVMDebugAggregateObjectBuilder) {
                LLVMDebugAggregateObjectBuilder llvmValueReadValue__ = (LLVMDebugAggregateObjectBuilder)llvmValueReadValue_;
                this.setPart(llvmValueReadValue__, containerReadValue_, this.valueProcessor_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(llvmValueReadValue_, containerReadValue_);
        }

        private void executeAndSpecialize(Object llvmValueReadValue, Object containerReadValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (llvmValueReadValue instanceof LLVMDebugAggregateObjectBuilder) {
                    LLVMDebugAggregateObjectBuilder llvmValueReadValue_ = (LLVMDebugAggregateObjectBuilder)llvmValueReadValue;
                    LLVMDebugValue.Builder valueProcessor___ = this.createBuilder();
                    if (valueProcessor___ instanceof Node) {
                        super.insert((Node)valueProcessor___);
                    }
                    this.valueProcessor_ = valueProcessor___;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    this.setPart(llvmValueReadValue_, containerReadValue, this.valueProcessor_);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.llvmValueRead_, this.containerRead_}, new Object[]{llvmValueReadValue, containerReadValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDebugWriteNode.AggregateWriteNode create(LLVMDebugBuilder builder, int partIndex, int[] clearIndices, LLVMExpressionNode llvmValueRead, LLVMExpressionNode containerRead) {
            return new AggregateWriteNodeGen(builder, partIndex, clearIndices, llvmValueRead, containerRead);
        }
    }

    @GeneratedBy(value=LLVMDebugWriteNode.SimpleWriteNode.class)
    public static final class SimpleWriteNodeGen
    extends LLVMDebugWriteNode.SimpleWriteNode {
        @Node.Child
        private LLVMExpressionNode llvmValueRead_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private LLVMDebugValue.Builder valueProcessor_;

        private SimpleWriteNodeGen(LLVMDebugBuilder builder, FrameSlot slot, LLVMExpressionNode llvmValueRead) {
            super(builder, slot);
            this.llvmValueRead_ = llvmValueRead;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object llvmValueReadValue_ = this.llvmValueRead_.executeGeneric(frameValue);
            if (state != 0) {
                this.write(frameValue, llvmValueReadValue_, this.valueProcessor_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, llvmValueReadValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(VirtualFrame frameValue, Object llvmValueReadValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMDebugValue.Builder valueProcessor___ = this.createBuilder();
                if (valueProcessor___ instanceof Node) {
                    super.insert((Node)valueProcessor___);
                }
                this.valueProcessor_ = valueProcessor___;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                this.write(frameValue, llvmValueReadValue, this.valueProcessor_);
                return;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDebugWriteNode.SimpleWriteNode create(LLVMDebugBuilder builder, FrameSlot slot, LLVMExpressionNode llvmValueRead) {
            return new SimpleWriteNodeGen(builder, slot, llvmValueRead);
        }
    }
}

