/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public final class LLVMComplexDoubleMul
extends LLVMExpressionNode {
    @Node.Child
    private LLVMExpressionNode aNode;
    @Node.Child
    private LLVMExpressionNode bNode;
    @Node.Child
    private LLVMExpressionNode cNode;
    @Node.Child
    private LLVMExpressionNode dNode;
    @Node.Child
    private LLVMExpressionNode alloc;
    @Node.Child
    private LLVMDoubleStoreNode store;

    public LLVMComplexDoubleMul(LLVMExpressionNode alloc, LLVMExpressionNode a, LLVMExpressionNode b, LLVMExpressionNode c, LLVMExpressionNode d) {
        this.alloc = alloc;
        this.aNode = a;
        this.bNode = b;
        this.cNode = c;
        this.dNode = d;
        this.store = LLVMDoubleStoreNodeGen.create(null, null);
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        try {
            double a = this.aNode.executeDouble(frame);
            double b = this.bNode.executeDouble(frame);
            double c = this.cNode.executeDouble(frame);
            double d = this.dNode.executeDouble(frame);
            double ac = a * c;
            double bd = b * d;
            double ad = a * d;
            double bc = b * c;
            double zReal = ac - bd;
            double zImag = ad + bc;
            LLVMPointer allocatedMemory = this.alloc.executeLLVMPointer(frame);
            this.store.executeWithTarget(allocatedMemory, zReal);
            this.store.executeWithTarget(allocatedMemory.increment(8L), zImag);
            return allocatedMemory;
        }
        catch (UnexpectedResultException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(e);
        }
    }
}

