/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;

public abstract class LLVMComplex80BitFloatDiv
extends LLVMExpressionNode {
    @Node.Child
    private LLVMExpressionNode aNode;
    @Node.Child
    private LLVMExpressionNode bNode;
    @Node.Child
    private LLVMExpressionNode cNode;
    @Node.Child
    private LLVMExpressionNode dNode;
    @Node.Child
    private LLVMExpressionNode alloc;
    @Node.Child
    private LLVM80BitFloatStoreNode store;

    public LLVMComplex80BitFloatDiv(LLVMExpressionNode alloc, LLVMExpressionNode a, LLVMExpressionNode b, LLVMExpressionNode c, LLVMExpressionNode d) {
        this.alloc = alloc;
        this.aNode = a;
        this.bNode = b;
        this.cNode = c;
        this.dNode = d;
        this.store = LLVM80BitFloatStoreNodeGen.create(null, null);
    }

    int getSizeInBytes() {
        return this.getDataLayout().getSize(PrimitiveType.X86_FP80);
    }

    @Specialization
    public Object doDiv(VirtualFrame frame, @Cached(value="getSizeInBytes()") int sizeInBytes) {
        try {
            LLVM80BitFloat longDoubleA = this.aNode.executeLLVM80BitFloat(frame);
            LLVM80BitFloat longDoubleB = this.bNode.executeLLVM80BitFloat(frame);
            LLVM80BitFloat longDoubleC = this.cNode.executeLLVM80BitFloat(frame);
            LLVM80BitFloat longDoubleD = this.dNode.executeLLVM80BitFloat(frame);
            double a = longDoubleA.getDoubleValue();
            double b = longDoubleB.getDoubleValue();
            double c = longDoubleC.getDoubleValue();
            double d = longDoubleD.getDoubleValue();
            double denom = c * c + d * d;
            double zReal = (a * c + b * d) / denom;
            double zImag = (b * c - a * d) / denom;
            LLVMPointer allocatedMemory = this.alloc.executeLLVMPointer(frame);
            this.store.executeWithTarget(allocatedMemory, LLVM80BitFloat.fromDouble(zReal));
            this.store.executeWithTarget(allocatedMemory.increment(sizeInBytes), LLVM80BitFloat.fromDouble(zImag));
            return allocatedMemory;
        }
        catch (UnexpectedResultException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(e);
        }
    }
}

