/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemSetNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemoryIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMMemoryIntrinsic.class)
public final class LLVMMemoryIntrinsicFactory {

    @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMFree.class)
    public static final class LLVMFreeNodeGen
    extends LLVMMemoryIntrinsic.LLVMFree {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory memory_;

        private LLVMFreeNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                return this.doVoid(child0Value__, this.memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public void execute(LLVMPointer child0Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isNativePointer(child0Value)) {
                LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
                this.doVoid(child0Value_, this.memory_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(child0Value);
        }

        private Object executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isNativePointer(child0Value)) {
                    LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
                    this.memory_ = LLVMNode.getLLVMMemory();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doVoid(child0Value_, this.memory_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMMemoryIntrinsic.LLVMFree create(LLVMExpressionNode child0) {
            return new LLVMFreeNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMRealloc.class)
    public static final class LLVMReallocNodeGen
    extends LLVMMemoryIntrinsic.LLVMRealloc {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory void0_memory_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory void1_memory_;

        private LLVMReallocNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public LLVMNativePointer executeWithTarget(LLVMNativePointer child0Value, Object child1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    return this.doVoid(child0Value, child1Value_, this.void0_memory_);
                }
                if ((state & 2) != 0 && child1Value instanceof Long) {
                    long child1Value_ = (Long)child1Value;
                    return this.doVoid(child0Value, child1Value_, this.void1_memory_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value, child1Value);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 2) == 0 && state != 0) {
                return this.executeGeneric_int0(frameValue, state, child0Value_);
            }
            if ((state & 1) == 0 && state != 0) {
                return this.executeGeneric_long1(frameValue, state, child0Value_);
            }
            return this.executeGeneric_generic2(frameValue, state, child0Value_);
        }

        private Object executeGeneric_int0(VirtualFrame frameValue, int state, Object child0Value_) {
            int child1Value_;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 1) != 0);
            if (LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                return this.doVoid(child0Value__, child1Value_, this.void0_memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_long1(VirtualFrame frameValue, int state, Object child0Value_) {
            long child1Value_;
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 2) != 0);
            if (LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                return this.doVoid(child0Value__, child1Value_, this.void1_memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state, Object child0Value_) {
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                if ((state & 1) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doVoid(child0Value__, child1Value__, this.void0_memory_);
                }
                if ((state & 2) != 0 && child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doVoid(child0Value__, child1Value__, this.void1_memory_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private LLVMNativePointer executeAndSpecialize(Object child0Value, Object child1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isNativePointer(child0Value)) {
                    LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
                    if (child1Value instanceof Integer) {
                        int child1Value_ = (Integer)child1Value;
                        this.void0_memory_ = LLVMNode.getLLVMMemory();
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMNativePointer lLVMNativePointer = this.doVoid(child0Value_, child1Value_, this.void0_memory_);
                        return lLVMNativePointer;
                    }
                    if (child1Value instanceof Long) {
                        long child1Value_ = (Long)child1Value;
                        this.void1_memory_ = LLVMNode.getLLVMMemory();
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMNativePointer lLVMNativePointer = this.doVoid(child0Value_, child1Value_, this.void1_memory_);
                        return lLVMNativePointer;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMMemoryIntrinsic.LLVMRealloc create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMReallocNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMCalloc.class)
    public static final class LLVMCallocNodeGen
    extends LLVMMemoryIntrinsic.LLVMCalloc {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory void0_memory_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory void1_memory_;

        private LLVMCallocNodeGen(LLVMMemSetNode memSet, LLVMExpressionNode child0, LLVMExpressionNode child1) {
            super(memSet);
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 2) == 0 && state != 0) {
                return this.executeGeneric_int_int0(frameValue, state);
            }
            if ((state & 1) == 0 && state != 0) {
                return this.executeGeneric_long_long1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_int_int0(VirtualFrame frameValue, int state) {
            int child1Value_;
            int child0Value_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doVoid(child0Value_, child1Value_, this.void0_memory_);
        }

        private Object executeGeneric_long_long1(VirtualFrame frameValue, int state) {
            long child1Value_;
            long child0Value_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doVoid(child0Value_, child1Value_, this.void1_memory_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Integer) {
                int child0Value__ = (Integer)child0Value_;
                if (child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doVoid(child0Value__, child1Value__, this.void0_memory_);
                }
            }
            if ((state & 2) != 0 && child0Value_ instanceof Long) {
                long child0Value__ = (Long)child0Value_;
                if (child1Value_ instanceof Long) {
                    long child1Value__ = (Long)child1Value_;
                    return this.doVoid(child0Value__, child1Value__, this.void1_memory_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private LLVMNativePointer executeAndSpecialize(Object child0Value, Object child1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (child0Value instanceof Integer) {
                    int child0Value_ = (Integer)child0Value;
                    if (child1Value instanceof Integer) {
                        int child1Value_ = (Integer)child1Value;
                        this.void0_memory_ = LLVMNode.getLLVMMemory();
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMNativePointer lLVMNativePointer = this.doVoid(child0Value_, child1Value_, this.void0_memory_);
                        return lLVMNativePointer;
                    }
                }
                if (child0Value instanceof Long) {
                    long child0Value_ = (Long)child0Value;
                    if (child1Value instanceof Long) {
                        long child1Value_ = (Long)child1Value;
                        this.void1_memory_ = LLVMNode.getLLVMMemory();
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMNativePointer lLVMNativePointer = this.doVoid(child0Value_, child1Value_, this.void1_memory_);
                        return lLVMNativePointer;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMMemoryIntrinsic.LLVMCalloc create(LLVMMemSetNode memSet, LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMCallocNodeGen(memSet, child0, child1);
        }
    }

    @GeneratedBy(value=LLVMMemoryIntrinsic.LLVMMalloc.class)
    public static final class LLVMMallocNodeGen
    extends LLVMMemoryIntrinsic.LLVMMalloc {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory void0_memory_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory void1_memory_;

        private LLVMMallocNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 2) == 0 && state != 0) {
                return this.executeGeneric_int0(frameValue, state);
            }
            if ((state & 1) == 0 && state != 0) {
                return this.executeGeneric_long1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_int0(VirtualFrame frameValue, int state) {
            int child0Value_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doVoid(child0Value_, this.void0_memory_);
        }

        private Object executeGeneric_long1(VirtualFrame frameValue, int state) {
            long child0Value_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doVoid(child0Value_, this.void1_memory_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Integer) {
                int child0Value__ = (Integer)child0Value_;
                return this.doVoid(child0Value__, this.void0_memory_);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Long) {
                long child0Value__ = (Long)child0Value_;
                return this.doVoid(child0Value__, this.void1_memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private LLVMNativePointer executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (child0Value instanceof Integer) {
                    int child0Value_ = (Integer)child0Value;
                    this.void0_memory_ = LLVMNode.getLLVMMemory();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMNativePointer lLVMNativePointer = this.doVoid(child0Value_, this.void0_memory_);
                    return lLVMNativePointer;
                }
                if (child0Value instanceof Long) {
                    long child0Value_ = (Long)child0Value;
                    this.void1_memory_ = LLVMNode.getLLVMMemory();
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVMNativePointer lLVMNativePointer = this.doVoid(child0Value_, this.void1_memory_);
                    return lLVMNativePointer;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMMemoryIntrinsic.LLVMMalloc create(LLVMExpressionNode child0) {
            return new LLVMMallocNodeGen(child0);
        }
    }
}

