/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemMove;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMMemMove.class)
public final class LLVMMemMoveFactory {

    @GeneratedBy(value=LLVMMemMove.LLVMMemMoveI64.class)
    public static final class LLVMMemMoveI64NodeGen
    extends LLVMMemMove.LLVMMemMoveI64 {
        @Node.Child
        private LLVMExpressionNode dest_;
        @Node.Child
        private LLVMExpressionNode src_;
        @Node.Child
        private LLVMExpressionNode length_;
        @Node.Child
        private LLVMExpressionNode isVolatile_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMMemMoveI64NodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode dest, LLVMExpressionNode src, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
            super(memMove);
            this.dest_ = dest;
            this.src_ = src;
            this.length_ = length;
            this.isVolatile_ = isVolatile;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            boolean isVolatileValue_;
            long lengthValue_;
            int state = this.state_;
            Object destValue_ = this.dest_.executeGeneric(frameValue);
            Object srcValue_ = this.src_.executeGeneric(frameValue);
            try {
                lengthValue_ = this.length_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
                return this.executeAndSpecialize(destValue_, srcValue_, ex.getResult(), isVolatileValue);
            }
            try {
                isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(destValue_, srcValue_, lengthValue_, ex.getResult());
            }
            if (state != 0 && LLVMTypes.isPointer(destValue_)) {
                LLVMPointer destValue__ = LLVMTypes.asPointer(destValue_);
                if (LLVMTypes.isPointer(srcValue_)) {
                    LLVMPointer srcValue__ = LLVMTypes.asPointer(srcValue_);
                    return this.doVoid(destValue__, srcValue__, lengthValue_, isVolatileValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(destValue_, srcValue_, lengthValue_, isVolatileValue_);
        }

        private Object executeAndSpecialize(Object destValue, Object srcValue, Object lengthValue, Object isVolatileValue) {
            int state = this.state_;
            if (LLVMTypes.isPointer(destValue)) {
                LLVMPointer destValue_ = LLVMTypes.asPointer(destValue);
                if (LLVMTypes.isPointer(srcValue)) {
                    LLVMPointer srcValue_ = LLVMTypes.asPointer(srcValue);
                    if (lengthValue instanceof Long) {
                        long lengthValue_ = (Long)lengthValue;
                        if (isVolatileValue instanceof Boolean) {
                            boolean isVolatileValue_ = (Boolean)isVolatileValue;
                            this.state_ = state |= 1;
                            return this.doVoid(destValue_, srcValue_, lengthValue_, isVolatileValue_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.dest_, this.src_, this.length_, this.isVolatile_}, new Object[]{destValue, srcValue, lengthValue, isVolatileValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMMemMove.LLVMMemMoveI64 create(LLVMMemMoveNode memMove, LLVMExpressionNode dest, LLVMExpressionNode src, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
            return new LLVMMemMoveI64NodeGen(memMove, dest, src, length, isVolatile);
        }
    }
}

