/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMTruffleIsHandleToManaged;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMTruffleIsHandleToManaged.class)
public final class LLVMTruffleIsHandleToManagedNodeGen
extends LLVMTruffleIsHandleToManaged {
    @Node.Child
    private LLVMExpressionNode child0_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

    private LLVMTruffleIsHandleToManagedNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 6) == 0 && state != 0) {
            return this.executeGeneric_long0(frameValue, state);
        }
        return this.executeGeneric_generic1(frameValue, state);
    }

    private Object executeGeneric_long0(VirtualFrame frameValue, int state) {
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doLongCase(child0Value_, this.lLVMLanguageContextReference_);
    }

    private Object executeGeneric_generic1(VirtualFrame frameValue, int state) {
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if ((state & 1) != 0 && child0Value_ instanceof Long) {
            long child0Value__ = (Long)child0Value_;
            return this.doLongCase(child0Value__, this.lLVMLanguageContextReference_);
        }
        if ((state & 2) != 0 && LLVMTypes.isNativePointer(child0Value_)) {
            LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
            return this.doPointerCase(child0Value__, this.lLVMLanguageContextReference_);
        }
        if ((state & 4) != 0 && LLVMTruffleIsHandleToManagedNodeGen.fallbackGuard_(state, child0Value_)) {
            return this.doGeneric(child0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_);
    }

    @Override
    public boolean executeI1(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 6) == 0 && state != 0) {
            return this.executeI1_long2(frameValue, state);
        }
        return this.executeI1_generic3(frameValue, state);
    }

    private boolean executeI1_long2(VirtualFrame frameValue, int state) {
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doLongCase(child0Value_, this.lLVMLanguageContextReference_);
    }

    private boolean executeI1_generic3(VirtualFrame frameValue, int state) {
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if ((state & 1) != 0 && child0Value_ instanceof Long) {
            long child0Value__ = (Long)child0Value_;
            return this.doLongCase(child0Value__, this.lLVMLanguageContextReference_);
        }
        if ((state & 2) != 0 && LLVMTypes.isNativePointer(child0Value_)) {
            LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
            return this.doPointerCase(child0Value__, this.lLVMLanguageContextReference_);
        }
        if ((state & 4) != 0 && LLVMTruffleIsHandleToManagedNodeGen.fallbackGuard_(state, child0Value_)) {
            return this.doGeneric(child0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object child0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__ == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                }
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doLongCase(child0Value_, (TruffleLanguage.ContextReference<LLVMContext>)lLVMLanguageContextReference__);
                return bl;
            }
            if (LLVMTypes.isNativePointer(child0Value)) {
                LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
                TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__ == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                }
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doPointerCase(child0Value_, (TruffleLanguage.ContextReference<LLVMContext>)lLVMLanguageContextReference__);
                return bl;
            }
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            boolean bl = this.doGeneric(child0Value);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state, Object child0Value) {
        if ((state & 1) == 0 && child0Value instanceof Long) {
            return false;
        }
        return (state & 2) != 0 || !LLVMTypes.isNativePointer(child0Value);
    }

    public static LLVMTruffleIsHandleToManaged create(LLVMExpressionNode child0) {
        return new LLVMTruffleIsHandleToManagedNodeGen(child0);
    }
}

