/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsString;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPolyglotAsString.class)
public final class LLVMPolyglotAsStringNodeGen
extends LLVMPolyglotAsString {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @Node.Child
    private LLVMExpressionNode object_;
    @Node.Child
    private LLVMExpressionNode buffer_;
    @Node.Child
    private LLVMExpressionNode buflen_;
    @Node.Child
    private LLVMReadCharsetNode charset_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMPolyglotAsStringNodeGen(LLVMExpressionNode object, LLVMExpressionNode buffer, LLVMExpressionNode buflen, LLVMReadCharsetNode charset) {
        this.object_ = object;
        this.buffer_ = buffer;
        this.buflen_ = buflen;
        this.charset_ = charset;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        long buflenValue_;
        int state = this.state_;
        Object objectValue_ = this.object_.executeGeneric(frameValue);
        Object bufferValue_ = this.buffer_.executeGeneric(frameValue);
        try {
            buflenValue_ = this.buflen_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object charsetValue = this.charset_.execute(frameValue);
            return this.executeAndSpecialize(frameValue, objectValue_, bufferValue_, ex.getResult(), charsetValue);
        }
        Object charsetValue_ = this.charset_.execute(frameValue);
        if (state != 0 && charsetValue_ instanceof LLVMReadCharsetNode.LLVMCharset) {
            LLVMReadCharsetNode.LLVMCharset charsetValue__ = (LLVMReadCharsetNode.LLVMCharset)charsetValue_;
            return this.doAsString(frameValue, objectValue_, bufferValue_, buflenValue_, charsetValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, objectValue_, bufferValue_, buflenValue_, charsetValue_);
    }

    @Override
    public long executeI64(VirtualFrame frameValue) {
        long buflenValue_;
        int state = this.state_;
        Object objectValue_ = this.object_.executeGeneric(frameValue);
        Object bufferValue_ = this.buffer_.executeGeneric(frameValue);
        try {
            buflenValue_ = this.buflen_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object charsetValue = this.charset_.execute(frameValue);
            return this.executeAndSpecialize(frameValue, objectValue_, bufferValue_, ex.getResult(), charsetValue);
        }
        Object charsetValue_ = this.charset_.execute(frameValue);
        if (state != 0 && charsetValue_ instanceof LLVMReadCharsetNode.LLVMCharset) {
            LLVMReadCharsetNode.LLVMCharset charsetValue__ = (LLVMReadCharsetNode.LLVMCharset)charsetValue_;
            return this.doAsString(frameValue, objectValue_, bufferValue_, buflenValue_, charsetValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, objectValue_, bufferValue_, buflenValue_, charsetValue_);
    }

    private long executeAndSpecialize(VirtualFrame frameValue, Object objectValue, Object bufferValue, Object buflenValue, Object charsetValue) {
        int state = this.state_;
        if (buflenValue instanceof Long) {
            long buflenValue_ = (Long)buflenValue;
            if (charsetValue instanceof LLVMReadCharsetNode.LLVMCharset) {
                LLVMReadCharsetNode.LLVMCharset charsetValue_ = (LLVMReadCharsetNode.LLVMCharset)charsetValue;
                this.state_ = state |= 1;
                return this.doAsString(frameValue, objectValue, bufferValue, buflenValue_, charsetValue_);
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.object_, this.buffer_, this.buflen_, this.charset_}, new Object[]{objectValue, bufferValue, buflenValue, charsetValue});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMPolyglotAsString create(LLVMExpressionNode object, LLVMExpressionNode buffer, LLVMExpressionNode buflen, LLVMReadCharsetNode charset) {
        return new LLVMPolyglotAsStringNodeGen(object, buffer, buflen, charset);
    }

    @GeneratedBy(value=LLVMPolyglotAsString.WriteStringNode.class)
    static final class WriteStringNodeGen
    extends LLVMPolyglotAsString.WriteStringNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private WriteData write_cache;

        private WriteStringNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected long execute(VirtualFrame frameValue, ByteBuffer arg0Value, Object arg1Value, long arg2Value, int arg3Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isPointer(arg1Value)) {
                LLVMPointer arg1Value_ = LLVMTypes.asPointer(arg1Value);
                WriteData s1_ = this.write_cache;
                while (s1_ != null) {
                    if (arg0Value.getClass() == s1_.srcBufferClass_) {
                        return this.doWrite(arg0Value, arg1Value_, arg2Value, arg3Value, s1_.srcBufferClass_);
                    }
                    s1_ = s1_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private long executeAndSpecialize(ByteBuffer arg0Value, Object arg1Value, long arg2Value, int arg3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isPointer(arg1Value)) {
                    LLVMPointer arg1Value_ = LLVMTypes.asPointer(arg1Value);
                    int count1_ = 0;
                    WriteData s1_ = this.write_cache;
                    if (state != 0) {
                        while (s1_ != null && arg0Value.getClass() != s1_.srcBufferClass_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null) {
                        Class<?> srcBufferClass__ = arg0Value.getClass();
                        if (arg0Value.getClass() == srcBufferClass__ && count1_ < 3) {
                            s1_ = new WriteData(this.write_cache);
                            s1_.srcBufferClass_ = srcBufferClass__;
                            this.write_cache = s1_;
                            this.state_ = state |= 1;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        long l = this.doWrite(arg0Value, arg1Value_, arg2Value, arg3Value, s1_.srcBufferClass_);
                        return l;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            WriteData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.write_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotAsString.WriteStringNode create() {
            return new WriteStringNodeGen();
        }

        @GeneratedBy(value=LLVMPolyglotAsString.WriteStringNode.class)
        private static final class WriteData {
            @CompilerDirectives.CompilationFinal
            WriteData next_;
            @CompilerDirectives.CompilationFinal
            Class<? extends ByteBuffer> srcBufferClass_;

            WriteData(WriteData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotAsString.BoxedEncodeStringNode.class)
    static final class BoxedEncodeStringNodeGen
    extends LLVMPolyglotAsString.BoxedEncodeStringNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private Boxed0Data boxed0_cache;
        @CompilerDirectives.CompilationFinal
        private BranchProfile boxed1_exception_;

        private BoxedEncodeStringNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        ByteBuffer execute(Object arg0Value, LLVMReadCharsetNode.LLVMCharset arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    Boxed0Data s1_ = this.boxed0_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(arg0Value)) {
                            return this.doBoxed(arg0Value, arg1Value, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.boxed1Boundary(state, arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private ByteBuffer boxed1Boundary(int state, Object arg0Value, LLVMReadCharsetNode.LLVMCharset arg1Value) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                ByteBuffer byteBuffer = this.doBoxed(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), this.boxed1_exception_);
                return byteBuffer;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer executeAndSpecialize(Object arg0Value, LLVMReadCharsetNode.LLVMCharset arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                ByteBuffer byteBuffer;
                if (exclude == 0) {
                    int count1_ = 0;
                    Boxed0Data s1_ = this.boxed0_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.interop_.accepts(arg0Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (Boxed0Data)super.insert((Node)new Boxed0Data(this.boxed0_cache));
                        s1_.interop_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value));
                        s1_.exception_ = BranchProfile.create();
                        this.boxed0_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        ByteBuffer byteBuffer2 = this.doBoxed(arg0Value, arg1Value, s1_.interop_, s1_.exception_);
                        return byteBuffer2;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.boxed1_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.boxed0_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    byteBuffer = this.doBoxed(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), this.boxed1_exception_);
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return byteBuffer;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Boxed0Data s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.boxed0_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotAsString.BoxedEncodeStringNode create() {
            return new BoxedEncodeStringNodeGen();
        }

        @GeneratedBy(value=LLVMPolyglotAsString.BoxedEncodeStringNode.class)
        private static final class Boxed0Data
        extends Node {
            @Node.Child
            Boxed0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            Boxed0Data(Boxed0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotAsString.EncodeStringNode.class)
    static final class EncodeStringNodeGen
    extends LLVMPolyglotAsString.EncodeStringNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private LLVMAsForeignNode foreign_asForeign_;
        @Node.Child
        private LLVMPolyglotAsString.BoxedEncodeStringNode foreign_encode_;

        private EncodeStringNodeGen() {
        }

        @Override
        protected ByteBuffer execute(Object arg0Value, LLVMReadCharsetNode.LLVMCharset arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg0Value instanceof String) {
                    String arg0Value_ = (String)arg0Value;
                    return this.doString(arg0Value_, arg1Value);
                }
                if ((state & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return this.doForeign(arg0Value_, arg1Value, this.foreign_asForeign_, this.foreign_encode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private ByteBuffer executeAndSpecialize(Object arg0Value, LLVMReadCharsetNode.LLVMCharset arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arg0Value instanceof String) {
                    String arg0Value_ = (String)arg0Value;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    ByteBuffer byteBuffer = this.doString(arg0Value_, arg1Value);
                    return byteBuffer;
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    this.foreign_asForeign_ = (LLVMAsForeignNode)super.insert((Node)LLVMAsForeignNode.create());
                    this.foreign_encode_ = (LLVMPolyglotAsString.BoxedEncodeStringNode)super.insert((Node)BoxedEncodeStringNodeGen.create());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    ByteBuffer byteBuffer = this.doForeign(arg0Value_, arg1Value, this.foreign_asForeign_, this.foreign_encode_);
                    return byteBuffer;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotAsString.EncodeStringNode create() {
            return new EncodeStringNodeGen();
        }
    }
}

