/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMCMathsIntrinsics;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMFloatStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMCMathsIntrinsics.class)
public final class LLVMCMathsIntrinsicsFactory {

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMCopySign.class)
    public static final class LLVMCopySignNodeGen
    extends LLVMCMathsIntrinsics.LLVMCopySign {
        @Node.Child
        private LLVMExpressionNode magnitude_;
        @Node.Child
        private LLVMExpressionNode sign_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMCopySignNodeGen(LLVMExpressionNode magnitude, LLVMExpressionNode sign) {
            this.magnitude_ = magnitude;
            this.sign_ = sign;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float_float0(VirtualFrame frameValue, int state) {
            float signValue_;
            float magnitudeValue_;
            try {
                magnitudeValue_ = this.magnitude_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object signValue = this.sign_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), signValue);
            }
            try {
                signValue_ = this.sign_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(Float.valueOf(magnitudeValue_), ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doFloat(magnitudeValue_, signValue_));
        }

        private Object executeGeneric_double_double1(VirtualFrame frameValue, int state) {
            double signValue_;
            double magnitudeValue_;
            try {
                magnitudeValue_ = this.magnitude_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object signValue = this.sign_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), signValue);
            }
            try {
                signValue_ = this.sign_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(magnitudeValue_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doDouble(magnitudeValue_, signValue_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object magnitudeValue_ = this.magnitude_.executeGeneric(frameValue);
            Object signValue_ = this.sign_.executeGeneric(frameValue);
            if ((state & 1) != 0 && magnitudeValue_ instanceof Float) {
                float magnitudeValue__ = ((Float)magnitudeValue_).floatValue();
                if (signValue_ instanceof Float) {
                    float signValue__ = ((Float)signValue_).floatValue();
                    return Float.valueOf(this.doFloat(magnitudeValue__, signValue__));
                }
            }
            if ((state & 2) != 0 && magnitudeValue_ instanceof Double) {
                double magnitudeValue__ = (Double)magnitudeValue_;
                if (signValue_ instanceof Double) {
                    double signValue__ = (Double)signValue_;
                    return this.doDouble(magnitudeValue__, signValue__);
                }
            }
            if ((state & 4) != 0 && magnitudeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat magnitudeValue__ = (LLVM80BitFloat)magnitudeValue_;
                if (signValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat signValue__ = (LLVM80BitFloat)signValue_;
                    return this.doLLVM80BitFloat(magnitudeValue__, signValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(magnitudeValue_, signValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double signValue_;
            double magnitudeValue_;
            int state = this.state_;
            try {
                magnitudeValue_ = this.magnitude_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object signValue = this.sign_.executeGeneric(frameValue);
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult(), signValue));
            }
            try {
                signValue_ = this.sign_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(magnitudeValue_, ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doDouble(magnitudeValue_, signValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(magnitudeValue_, signValue_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float signValue_;
            float magnitudeValue_;
            int state = this.state_;
            try {
                magnitudeValue_ = this.magnitude_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object signValue = this.sign_.executeGeneric(frameValue);
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult(), signValue));
            }
            try {
                signValue_ = this.sign_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(magnitudeValue_), ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doFloat(magnitudeValue_, signValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(magnitudeValue_), Float.valueOf(signValue_)));
        }

        private Object executeAndSpecialize(Object magnitudeValue, Object signValue) {
            int state = this.state_;
            if (magnitudeValue instanceof Float) {
                float magnitudeValue_ = ((Float)magnitudeValue).floatValue();
                if (signValue instanceof Float) {
                    float signValue_ = ((Float)signValue).floatValue();
                    this.state_ = state |= 1;
                    return Float.valueOf(this.doFloat(magnitudeValue_, signValue_));
                }
            }
            if (magnitudeValue instanceof Double) {
                double magnitudeValue_ = (Double)magnitudeValue;
                if (signValue instanceof Double) {
                    double signValue_ = (Double)signValue;
                    this.state_ = state |= 2;
                    return this.doDouble(magnitudeValue_, signValue_);
                }
            }
            if (magnitudeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat magnitudeValue_ = (LLVM80BitFloat)magnitudeValue;
                if (signValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat signValue_ = (LLVM80BitFloat)signValue;
                    this.state_ = state |= 4;
                    return this.doLLVM80BitFloat(magnitudeValue_, signValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.magnitude_, this.sign_}, new Object[]{magnitudeValue, signValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMCopySign create(LLVMExpressionNode magnitude, LLVMExpressionNode sign) {
            return new LLVMCopySignNodeGen(magnitude, sign);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMATan2.class)
    public static final class LLVMATan2NodeGen
    extends LLVMCMathsIntrinsics.LLVMATan2 {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMATan2NodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double_double0(VirtualFrame frameValue, int state) {
            double child1Value_;
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doIntrinsic(child0Value_, child1Value_);
        }

        private Object executeGeneric_float_float1(VirtualFrame frameValue, int state) {
            float child1Value_;
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_, child1Value_));
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                if (child1Value_ instanceof Double) {
                    double child1Value__ = (Double)child1Value_;
                    return this.doIntrinsic(child0Value__, child1Value__);
                }
            }
            if ((state & 2) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                if (child1Value_ instanceof Float) {
                    float child1Value__ = ((Float)child1Value_).floatValue();
                    return Float.valueOf(this.doIntrinsic(child0Value__, child1Value__));
                }
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                if (child1Value_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat child1Value__ = (LLVM80BitFloat)child1Value_;
                    return this.doIntrinsic(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child1Value_;
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            try {
                child1Value_ = this.child1_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child1Value_;
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            try {
                child1Value_ = this.child1_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), Float.valueOf(child1Value_)));
        }

        private Object executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                if (child1Value instanceof Double) {
                    double child1Value_ = (Double)child1Value;
                    this.state_ = state |= 1;
                    return this.doIntrinsic(child0Value_, child1Value_);
                }
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                if (child1Value instanceof Float) {
                    float child1Value_ = ((Float)child1Value).floatValue();
                    this.state_ = state |= 2;
                    return Float.valueOf(this.doIntrinsic(child0Value_, child1Value_));
                }
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                if (child1Value instanceof LLVM80BitFloat) {
                    LLVM80BitFloat child1Value_ = (LLVM80BitFloat)child1Value;
                    this.state_ = state |= 4;
                    return this.doIntrinsic(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMATan2 create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMATan2NodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMATan.class)
    public static final class LLVMATanNodeGen
    extends LLVMCMathsIntrinsics.LLVMATan {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMATanNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double0(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 1;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 2;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMATan create(LLVMExpressionNode child0) {
            return new LLVMATanNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMTanh.class)
    public static final class LLVMTanhNodeGen
    extends LLVMCMathsIntrinsics.LLVMTanh {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMTanhNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double0(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 1;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 2;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMTanh create(LLVMExpressionNode child0) {
            return new LLVMTanhNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMTan.class)
    public static final class LLVMTanNodeGen
    extends LLVMCMathsIntrinsics.LLVMTan {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMTanNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double0(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 1;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 2;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMTan create(LLVMExpressionNode child0) {
            return new LLVMTanNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMACos.class)
    public static final class LLVMACosNodeGen
    extends LLVMCMathsIntrinsics.LLVMACos {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMACosNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double0(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 1;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 2;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMACos create(LLVMExpressionNode child0) {
            return new LLVMACosNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMCosh.class)
    public static final class LLVMCoshNodeGen
    extends LLVMCMathsIntrinsics.LLVMCosh {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMCoshNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double0(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 1;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 2;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMCosh create(LLVMExpressionNode child0) {
            return new LLVMCoshNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMCos.class)
    public static final class LLVMCosNodeGen
    extends LLVMCMathsIntrinsics.LLVMCos {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMCosNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double0(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 1;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 2;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMCos create(LLVMExpressionNode child0) {
            return new LLVMCosNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMASin.class)
    public static final class LLVMASinNodeGen
    extends LLVMCMathsIntrinsics.LLVMASin {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMASinNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double0(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 1;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 2;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMASin create(LLVMExpressionNode child0) {
            return new LLVMASinNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMSinh.class)
    public static final class LLVMSinhNodeGen
    extends LLVMCMathsIntrinsics.LLVMSinh {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMSinhNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double0(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 1;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 2;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMSinh create(LLVMExpressionNode child0) {
            return new LLVMSinhNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMSin.class)
    public static final class LLVMSinNodeGen
    extends LLVMCMathsIntrinsics.LLVMSin {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMSinNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double0(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 1;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 2;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMSin create(LLVMExpressionNode child0) {
            return new LLVMSinNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMPow.class)
    public static final class LLVMPowNodeGen
    extends LLVMCMathsIntrinsics.LLVMPow {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMPowNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x3E) == 0 && state != 0) {
                return this.executeGeneric_float_int0(frameValue, state);
            }
            if ((state & 0x3D) == 0 && state != 0) {
                return this.executeGeneric_float_float1(frameValue, state);
            }
            if ((state & 0x3B) == 0 && state != 0) {
                return this.executeGeneric_double_int2(frameValue, state);
            }
            if ((state & 0x37) == 0 && state != 0) {
                return this.executeGeneric_double_double3(frameValue, state);
            }
            if ((state & 0x2F) == 0 && state != 0) {
                return this.executeGeneric_int4(frameValue, state);
            }
            return this.executeGeneric_generic5(frameValue, state);
        }

        private Object executeGeneric_float_int0(VirtualFrame frameValue, int state) {
            int child1Value_;
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doFloat(child0Value_, child1Value_));
        }

        private Object executeGeneric_float_float1(VirtualFrame frameValue, int state) {
            float child1Value_;
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doFloat(child0Value_, child1Value_));
        }

        private Object executeGeneric_double_int2(VirtualFrame frameValue, int state) {
            int child1Value_;
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doDouble(child0Value_, child1Value_);
        }

        private Object executeGeneric_double_double3(VirtualFrame frameValue, int state) {
            double child1Value_;
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doDouble(child0Value_, child1Value_);
        }

        private Object executeGeneric_int4(VirtualFrame frameValue, int state) {
            int child1Value_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 0x10) != 0);
            if (child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic5(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 3) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                if ((state & 1) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return Float.valueOf(this.doFloat(child0Value__, child1Value__));
                }
                if ((state & 2) != 0 && child1Value_ instanceof Float) {
                    float child1Value__ = ((Float)child1Value_).floatValue();
                    return Float.valueOf(this.doFloat(child0Value__, child1Value__));
                }
            }
            if ((state & 0xC) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                if ((state & 4) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doDouble(child0Value__, child1Value__);
                }
                if ((state & 8) != 0 && child1Value_ instanceof Double) {
                    double child1Value__ = (Double)child1Value_;
                    return this.doDouble(child0Value__, child1Value__);
                }
            }
            if ((state & 0x30) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                if ((state & 0x10) != 0 && child1Value_ instanceof Integer) {
                    int child1Value__ = (Integer)child1Value_;
                    return this.doIntrinsic(child0Value__, child1Value__);
                }
                if ((state & 0x20) != 0 && child1Value_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat child1Value__ = (LLVM80BitFloat)child1Value_;
                    return this.doIntrinsic(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            if ((state & 8) == 0 && (state & 0xC) != 0) {
                return this.executeDouble_int6(frameValue, state, child0Value_);
            }
            if ((state & 4) == 0 && (state & 0xC) != 0) {
                return this.executeDouble_double7(frameValue, state, child0Value_);
            }
            return this.executeDouble_generic8(frameValue, state, child0Value_);
        }

        private double executeDouble_int6(VirtualFrame frameValue, int state, double child0Value_) throws UnexpectedResultException {
            int child1Value_;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            assert ((state & 4) != 0);
            return this.doDouble(child0Value_, child1Value_);
        }

        private double executeDouble_double7(VirtualFrame frameValue, int state, double child0Value_) throws UnexpectedResultException {
            double child1Value_;
            try {
                child1Value_ = this.child1_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            assert ((state & 8) != 0);
            return this.doDouble(child0Value_, child1Value_);
        }

        private double executeDouble_generic8(VirtualFrame frameValue, int state, double child0Value_) throws UnexpectedResultException {
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 4) != 0 && child1Value_ instanceof Integer) {
                int child1Value__ = (Integer)child1Value_;
                return this.doDouble(child0Value_, child1Value__);
            }
            if ((state & 8) != 0 && child1Value_ instanceof Double) {
                double child1Value__ = (Double)child1Value_;
                return this.doDouble(child0Value_, child1Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            if ((state & 2) == 0 && (state & 3) != 0) {
                return this.executeFloat_int9(frameValue, state, child0Value_);
            }
            if ((state & 1) == 0 && (state & 3) != 0) {
                return this.executeFloat_float10(frameValue, state, child0Value_);
            }
            return this.executeFloat_generic11(frameValue, state, child0Value_);
        }

        private float executeFloat_int9(VirtualFrame frameValue, int state, float child0Value_) throws UnexpectedResultException {
            int child1Value_;
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult()));
            }
            assert ((state & 1) != 0);
            return this.doFloat(child0Value_, child1Value_);
        }

        private float executeFloat_float10(VirtualFrame frameValue, int state, float child0Value_) throws UnexpectedResultException {
            float child1Value_;
            try {
                child1Value_ = this.child1_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult()));
            }
            assert ((state & 2) != 0);
            return this.doFloat(child0Value_, child1Value_);
        }

        private float executeFloat_generic11(VirtualFrame frameValue, int state, float child0Value_) throws UnexpectedResultException {
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child1Value_ instanceof Integer) {
                int child1Value__ = (Integer)child1Value_;
                return this.doFloat(child0Value_, child1Value__);
            }
            if ((state & 2) != 0 && child1Value_ instanceof Float) {
                float child1Value__ = ((Float)child1Value_).floatValue();
                return this.doFloat(child0Value_, child1Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), child1Value_));
        }

        private Object executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_ = state |= 1;
                    return Float.valueOf(this.doFloat(child0Value_, child1Value_));
                }
                if (child1Value instanceof Float) {
                    float child1Value_ = ((Float)child1Value).floatValue();
                    this.state_ = state |= 2;
                    return Float.valueOf(this.doFloat(child0Value_, child1Value_));
                }
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_ = state |= 4;
                    return this.doDouble(child0Value_, child1Value_);
                }
                if (child1Value instanceof Double) {
                    double child1Value_ = (Double)child1Value;
                    this.state_ = state |= 8;
                    return this.doDouble(child0Value_, child1Value_);
                }
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_ = state |= 0x10;
                    return this.doIntrinsic(child0Value_, child1Value_);
                }
                if (child1Value instanceof LLVM80BitFloat) {
                    LLVM80BitFloat child1Value_ = (LLVM80BitFloat)child1Value;
                    this.state_ = state |= 0x20;
                    return this.doIntrinsic(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMPow create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMPowNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMFmod.class)
    public static final class LLVMFmodNodeGen
    extends LLVMCMathsIntrinsics.LLVMFmod {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFmodNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double_double0(VirtualFrame frameValue, int state) {
            double child1Value_;
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doIntrinsic(child0Value_, child1Value_);
        }

        private Object executeGeneric_float_float1(VirtualFrame frameValue, int state) {
            float child1Value_;
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult());
            }
            assert ((state & 2) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_, child1Value_));
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                if (child1Value_ instanceof Double) {
                    double child1Value__ = (Double)child1Value_;
                    return this.doIntrinsic(child0Value__, child1Value__);
                }
            }
            if ((state & 2) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                if (child1Value_ instanceof Float) {
                    float child1Value__ = ((Float)child1Value_).floatValue();
                    return Float.valueOf(this.doIntrinsic(child0Value__, child1Value__));
                }
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                if (child1Value_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat child1Value__ = (LLVM80BitFloat)child1Value_;
                    return this.doIntrinsic(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child1Value_;
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            try {
                child1Value_ = this.child1_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child1Value_;
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            try {
                child1Value_ = this.child1_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), Float.valueOf(child1Value_)));
        }

        private Object executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                if (child1Value instanceof Double) {
                    double child1Value_ = (Double)child1Value;
                    this.state_ = state |= 1;
                    return this.doIntrinsic(child0Value_, child1Value_);
                }
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                if (child1Value instanceof Float) {
                    float child1Value_ = ((Float)child1Value).floatValue();
                    this.state_ = state |= 2;
                    return Float.valueOf(this.doIntrinsic(child0Value_, child1Value_));
                }
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                if (child1Value instanceof LLVM80BitFloat) {
                    LLVM80BitFloat child1Value_ = (LLVM80BitFloat)child1Value;
                    this.state_ = state |= 4;
                    return this.doIntrinsic(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMFmod create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMFmodNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMModf.class)
    public static final class LLVMModfNodeGen
    extends LLVMCMathsIntrinsics.LLVMModf {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private LLVMDoubleStoreNode intrinsic0_store_;
        @Node.Child
        private LLVMFloatStoreNode intrinsic1_store_;
        @Node.Child
        private LLVM80BitFloatStoreNode intrinsic2_store_;

        private LLVMModfNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_double0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_float1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_double0(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            assert ((state & 1) != 0);
            if (LLVMTypes.isPointer(child1Value_)) {
                LLVMPointer child1Value__ = LLVMTypes.asPointer(child1Value_);
                return this.doIntrinsic(child0Value_, child1Value__, this.intrinsic0_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_float1(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            assert ((state & 2) != 0);
            if (LLVMTypes.isPointer(child1Value_)) {
                LLVMPointer child1Value__ = LLVMTypes.asPointer(child1Value_);
                return Float.valueOf(this.doIntrinsic(child0Value_, child1Value__, this.intrinsic1_store_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(Float.valueOf(child0Value_), child1Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(child1Value_)) {
                LLVMPointer child1Value__ = LLVMTypes.asPointer(child1Value_);
                if ((state & 1) != 0 && child0Value_ instanceof Double) {
                    double child0Value__ = (Double)child0Value_;
                    return this.doIntrinsic(child0Value__, child1Value__, this.intrinsic0_store_);
                }
                if ((state & 2) != 0 && child0Value_ instanceof Float) {
                    float child0Value__ = ((Float)child0Value_).floatValue();
                    return Float.valueOf(this.doIntrinsic(child0Value__, child1Value__, this.intrinsic1_store_));
                }
                if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                    return this.doIntrinsic(child0Value__, child1Value__, this.intrinsic2_store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isPointer(child1Value_)) {
                LLVMPointer child1Value__ = LLVMTypes.asPointer(child1Value_);
                return this.doIntrinsic(child0Value_, child1Value__, this.intrinsic0_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 2) != 0 && LLVMTypes.isPointer(child1Value_)) {
                LLVMPointer child1Value__ = LLVMTypes.asPointer(child1Value_);
                return this.doIntrinsic(child0Value_, child1Value__, this.intrinsic1_store_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), child1Value_));
        }

        private Object executeAndSpecialize(Object child0Value, Object child1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isPointer(child1Value)) {
                    LLVMPointer child1Value_ = LLVMTypes.asPointer(child1Value);
                    if (child0Value instanceof Double) {
                        double child0Value_ = (Double)child0Value;
                        this.intrinsic0_store_ = (LLVMDoubleStoreNode)super.insert((Node)LLVMCMathsIntrinsics.LLVMModf.createDoubleStore());
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        Double d = this.doIntrinsic(child0Value_, child1Value_, this.intrinsic0_store_);
                        return d;
                    }
                    if (child0Value instanceof Float) {
                        float child0Value_ = ((Float)child0Value).floatValue();
                        this.intrinsic1_store_ = (LLVMFloatStoreNode)super.insert((Node)LLVMCMathsIntrinsics.LLVMModf.createFloatStore());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        Float f = Float.valueOf(this.doIntrinsic(child0Value_, child1Value_, this.intrinsic1_store_));
                        return f;
                    }
                    if (child0Value instanceof LLVM80BitFloat) {
                        LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                        this.intrinsic2_store_ = (LLVM80BitFloatStoreNode)super.insert((Node)LLVMCMathsIntrinsics.LLVMModf.create80BitFloatStore());
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        LLVM80BitFloat lLVM80BitFloat = this.doIntrinsic(child0Value_, child1Value_, this.intrinsic2_store_);
                        return lLVM80BitFloat;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMModf create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMModfNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMLdexp.class)
    public static final class LLVMLdexpNodeGen
    extends LLVMCMathsIntrinsics.LLVMLdexp {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMLdexpNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float_int0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double_int1(frameValue, state);
            }
            if ((state & 3) == 0 && state != 0) {
                return this.executeGeneric_int2(frameValue, state);
            }
            return this.executeGeneric_generic3(frameValue, state);
        }

        private Object executeGeneric_float_int0(VirtualFrame frameValue, int state) {
            int child1Value_;
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_, child1Value_));
        }

        private Object executeGeneric_double_int1(VirtualFrame frameValue, int state) {
            int child1Value_;
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_, child1Value_);
        }

        private Object executeGeneric_int2(VirtualFrame frameValue, int state) {
            int child1Value_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 4) != 0);
            if (child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic3(VirtualFrame frameValue, int state) {
            int child1Value_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__, child1Value_));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__, child1Value_);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            int child1Value_;
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            int child1Value_;
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), child1Value_));
        }

        private Object executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child1Value instanceof Integer) {
                int child1Value_ = (Integer)child1Value;
                if (child0Value instanceof Float) {
                    float child0Value_ = ((Float)child0Value).floatValue();
                    this.state_ = state |= 1;
                    return Float.valueOf(this.doIntrinsic(child0Value_, child1Value_));
                }
                if (child0Value instanceof Double) {
                    double child0Value_ = (Double)child0Value;
                    this.state_ = state |= 2;
                    return this.doIntrinsic(child0Value_, child1Value_);
                }
                if (child0Value instanceof LLVM80BitFloat) {
                    LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                    this.state_ = state |= 4;
                    return this.doIntrinsic(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMLdexp create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMLdexpNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMExp2.class)
    public static final class LLVMExp2NodeGen
    extends LLVMCMathsIntrinsics.LLVMExp2 {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMExp2NodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMExp2 create(LLVMExpressionNode child0) {
            return new LLVMExp2NodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMExpm1.class)
    public static final class LLVMExpm1NodeGen
    extends LLVMCMathsIntrinsics.LLVMExpm1 {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMExpm1NodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMExpm1 create(LLVMExpressionNode child0) {
            return new LLVMExpm1NodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMExp.class)
    public static final class LLVMExpNodeGen
    extends LLVMCMathsIntrinsics.LLVMExp {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMExpNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMExp create(LLVMExpressionNode child0) {
            return new LLVMExpNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMMaxnum.class)
    public static final class LLVMMaxnumNodeGen
    extends LLVMCMathsIntrinsics.LLVMMaxnum {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMMaxnumNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 2) == 0 && state != 0) {
                return this.executeGeneric_float_float0(frameValue, state);
            }
            if ((state & 1) == 0 && state != 0) {
                return this.executeGeneric_double_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float_float0(VirtualFrame frameValue, int state) {
            float child1Value_;
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_, child1Value_));
        }

        private Object executeGeneric_double_double1(VirtualFrame frameValue, int state) {
            double child1Value_;
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                if (child1Value_ instanceof Float) {
                    float child1Value__ = ((Float)child1Value_).floatValue();
                    return Float.valueOf(this.doIntrinsic(child0Value__, child1Value__));
                }
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                if (child1Value_ instanceof Double) {
                    double child1Value__ = (Double)child1Value_;
                    return this.doIntrinsic(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child1Value_;
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            try {
                child1Value_ = this.child1_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child1Value_;
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            try {
                child1Value_ = this.child1_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), Float.valueOf(child1Value_)));
        }

        private Object executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                if (child1Value instanceof Float) {
                    float child1Value_ = ((Float)child1Value).floatValue();
                    this.state_ = state |= 1;
                    return Float.valueOf(this.doIntrinsic(child0Value_, child1Value_));
                }
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                if (child1Value instanceof Double) {
                    double child1Value_ = (Double)child1Value;
                    this.state_ = state |= 2;
                    return this.doIntrinsic(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMMaxnum create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMMaxnumNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMMinnum.class)
    public static final class LLVMMinnumNodeGen
    extends LLVMCMathsIntrinsics.LLVMMinnum {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMMinnumNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 2) == 0 && state != 0) {
                return this.executeGeneric_float_float0(frameValue, state);
            }
            if ((state & 1) == 0 && state != 0) {
                return this.executeGeneric_double_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float_float0(VirtualFrame frameValue, int state) {
            float child1Value_;
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_, child1Value_));
        }

        private Object executeGeneric_double_double1(VirtualFrame frameValue, int state) {
            double child1Value_;
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), child1Value);
            }
            try {
                child1Value_ = this.child1_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_, child1Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                if (child1Value_ instanceof Float) {
                    float child1Value__ = ((Float)child1Value_).floatValue();
                    return Float.valueOf(this.doIntrinsic(child0Value__, child1Value__));
                }
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                if (child1Value_ instanceof Double) {
                    double child1Value__ = (Double)child1Value_;
                    return this.doIntrinsic(child0Value__, child1Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child1Value_;
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            try {
                child1Value_ = this.child1_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child1Value_;
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child1Value = this.child1_.executeGeneric(frameValue);
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult(), child1Value));
            }
            try {
                child1Value_ = this.child1_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_), Float.valueOf(child1Value_)));
        }

        private Object executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                if (child1Value instanceof Float) {
                    float child1Value_ = ((Float)child1Value).floatValue();
                    this.state_ = state |= 1;
                    return Float.valueOf(this.doIntrinsic(child0Value_, child1Value_));
                }
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                if (child1Value instanceof Double) {
                    double child1Value_ = (Double)child1Value;
                    this.state_ = state |= 2;
                    return this.doIntrinsic(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMMinnum create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMMinnumNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMFAbsVectorNode.class)
    public static final class LLVMFAbsVectorNodeGen
    extends LLVMCMathsIntrinsics.LLVMFAbsVectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFAbsVectorNodeGen(LLVMExpressionNode child0, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                return this.doVector(child0Value__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                return this.doVector(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private LLVMVector executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value_ = (LLVMDoubleVector)child0Value;
                this.state_ = state |= 1;
                return this.doVector(child0Value_);
            }
            if (child0Value instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value_ = (LLVMFloatVector)child0Value;
                this.state_ = state |= 2;
                return this.doVector(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMFAbsVectorNode create(LLVMExpressionNode child0, int vectorLength) {
            return new LLVMFAbsVectorNodeGen(child0, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMFAbs.class)
    public static final class LLVMFAbsNodeGen
    extends LLVMCMathsIntrinsics.LLVMFAbs {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFAbsNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMFAbs create(LLVMExpressionNode child0) {
            return new LLVMFAbsNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMAbs.class)
    public static final class LLVMAbsNodeGen
    extends LLVMCMathsIntrinsics.LLVMAbs {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile managed_negated_;

        private LLVMAbsNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xE) == 0 && state != 0) {
                return this.executeGeneric_int0(frameValue, state);
            }
            if ((state & 0xD) == 0 && state != 0) {
                return this.executeGeneric_long1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_int0(VirtualFrame frameValue, int state) {
            int child0Value_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doInt(child0Value_);
        }

        private Object executeGeneric_long1(VirtualFrame frameValue, int state) {
            long child0Value_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doLong(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Integer) {
                int child0Value__ = (Integer)child0Value_;
                return this.doInt(child0Value__);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Long) {
                long child0Value__ = (Long)child0Value_;
                return this.doLong(child0Value__);
            }
            if ((state & 4) != 0 && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                return this.doNative(child0Value__);
            }
            if ((state & 8) != 0 && LLVMTypes.isManagedPointer(child0Value_)) {
                LLVMManagedPointer child0Value__ = LLVMTypes.asManagedPointer(child0Value_);
                return this.doManaged(child0Value__, this.managed_negated_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doInt(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            long child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doLong(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_));
        }

        private Object executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (child0Value instanceof Integer) {
                    int child0Value_ = (Integer)child0Value;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doInt(child0Value_);
                    return n;
                }
                if (child0Value instanceof Long) {
                    long child0Value_ = (Long)child0Value;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Long l = this.doLong(child0Value_);
                    return l;
                }
                if (LLVMTypes.isNativePointer(child0Value)) {
                    LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVMNativePointer lLVMNativePointer = this.doNative(child0Value_);
                    return lLVMNativePointer;
                }
                if (LLVMTypes.isManagedPointer(child0Value)) {
                    LLVMManagedPointer child0Value_ = LLVMTypes.asManagedPointer(child0Value);
                    this.managed_negated_ = ConditionProfile.createBinaryProfile();
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedPointer lLVMManagedPointer = this.doManaged(child0Value_, this.managed_negated_);
                    return lLVMManagedPointer;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMAbs create(LLVMExpressionNode child0) {
            return new LLVMAbsNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMFloor.class)
    public static final class LLVMFloorNodeGen
    extends LLVMCMathsIntrinsics.LLVMFloor {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFloorNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMFloor create(LLVMExpressionNode child0) {
            return new LLVMFloorNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMCeil.class)
    public static final class LLVMCeilNodeGen
    extends LLVMCMathsIntrinsics.LLVMCeil {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMCeilNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMCeil create(LLVMExpressionNode child0) {
            return new LLVMCeilNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMRint.class)
    public static final class LLVMRintNodeGen
    extends LLVMCMathsIntrinsics.LLVMRint {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMRintNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMRint create(LLVMExpressionNode child0) {
            return new LLVMRintNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMLog1p.class)
    public static final class LLVMLog1pNodeGen
    extends LLVMCMathsIntrinsics.LLVMLog1p {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMLog1pNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMLog1p create(LLVMExpressionNode child0) {
            return new LLVMLog1pNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMLog10.class)
    public static final class LLVMLog10NodeGen
    extends LLVMCMathsIntrinsics.LLVMLog10 {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMLog10NodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMLog10 create(LLVMExpressionNode child0) {
            return new LLVMLog10NodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMLog2.class)
    public static final class LLVMLog2NodeGen
    extends LLVMCMathsIntrinsics.LLVMLog2 {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMLog2NodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMLog2 create(LLVMExpressionNode child0) {
            return new LLVMLog2NodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMLog.class)
    public static final class LLVMLogNodeGen
    extends LLVMCMathsIntrinsics.LLVMLog {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMLogNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMLog create(LLVMExpressionNode child0) {
            return new LLVMLogNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMCMathsIntrinsics.LLVMSqrt.class)
    public static final class LLVMSqrtNodeGen
    extends LLVMCMathsIntrinsics.LLVMSqrt {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMSqrtNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_float0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_double1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_float0(VirtualFrame frameValue, int state) {
            float child0Value_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return Float.valueOf(this.doIntrinsic(child0Value_));
        }

        private Object executeGeneric_double1(VirtualFrame frameValue, int state) {
            double child0Value_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doIntrinsic(child0Value_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Float) {
                float child0Value__ = ((Float)child0Value_).floatValue();
                return Float.valueOf(this.doIntrinsic(child0Value__));
            }
            if ((state & 2) != 0 && child0Value_ instanceof Double) {
                double child0Value__ = (Double)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value__ = (LLVM80BitFloat)child0Value_;
                return this.doIntrinsic(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectDouble(this.executeAndSpecialize(child0Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectFloat(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doIntrinsic(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectFloat(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return Float.valueOf(this.doIntrinsic(child0Value_));
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 2;
                return this.doIntrinsic(child0Value_);
            }
            if (child0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat child0Value_ = (LLVM80BitFloat)child0Value;
                this.state_ = state |= 4;
                return this.doIntrinsic(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCMathsIntrinsics.LLVMSqrt create(LLVMExpressionNode child0) {
            return new LLVMSqrtNodeGen(child0);
        }
    }
}

